<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/../html/class.RequiredElement.php" );





class HTMLDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_HTML; // html code of field
	var $ms_Required; // if this is a label for required field
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function HTMLDataField( $ps_HTML, $ps_Required = FALSE, 
													$paAttributes = array(), $paParentAttributes = array() ) {
		if(is_array( $ps_Required ) ) { /* shift parameters */
			$paParentAttributes = $paAttributes;
			$paAttributes = $ps_Required;
			$ps_Required = FALSE;
		}
		$this->DataField( $paAttributes, $paParentAttributes );
		$this->SetHTML( $ps_HTML );
		$this->SetRequired( $ps_Required );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetHTML( $ps_HTML ) {
		$this->ms_HTML = $ps_HTML;
	}

	function GetHTML() {
		return $this->ms_HTML;
	}

	function SetRequired( $ps_Required ) {
		$this->ms_Required = $ps_Required;
	}

	function GetRequired() {
		return $this->ms_Required;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
	}

	function GetInputPresentation() {

		$loRet = $this->GetRequired() ? 
			new RequiredElement( $this->GetHTML() ) : 
			new HTMLElement( $this->GetHTML() );

		return $this->WrapParentTags( $loRet );
	}

	function GetOutputPresentation() {
		return $this->WrapParentTags( new HTMLElement( $this->GetHTML() ) );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new HTMLElement( "" );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
