<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Data.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.MultiTablesForm.php" );
include_once( dirname(__FILE__) . "/class.FormButtonData.php" );






class MultiSetData extends Data {

	/* -------------------- Members -------------------- */
	var $ma_Data; // titles & objects of class SetOfRowsData are stored here
	var $ma_Buttons; // buttons are here
	var $ma_Hidden; // hidden fields
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function MultiSetData() {
		$this->ClearData();
		$this->ClearButtons();
		$this->ClearHidden();
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access $ma_Data -------------------- */
	function ClearData() {
		$this->ma_Data = array();
	}

	function AppendData( $po_Data, $pm_Title ) {
		$this->ma_Data[] = array( "data"=>$po_Data, "title"=>$pm_Title );
	}

	function &GetData( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Data;
		if( $ps_Index == cc_LastElement )
			return $this->ma_Data[ count($this->ma_Data) - 1 ];
		return $this->ma_Data[$ps_Index];
	}
	/* -------------------- end methods to access $ma_Data -------------------- */





	/* -------------------- methods to access buttons -------------------- */
	function ClearButtons() {
		$this->ma_Buttons = array();
	}

	function AppendButton( $ps_Label, $ps_JS="javascript:doChange()", 
												 $ps_ID=NULL, $plIsSubmit=NULL ) {

		$this->ma_Buttons[] = new FormButtonData( $ps_Label, $ps_JS,$ps_ID, $plIsSubmit );
		
	}

	function &GetButtons( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Buttons;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Buttons[ count($this->ma_Buttons) - 1 ];
		return $this->ma_Buttons[$ps_Index];
	}
	/* -------------------- end methods to access buttons -------------------- */

	/* -------------------- methods to access hidden fields -------------------- */
	function ClearHidden() {
		$this->ma_Hidden = array();
	}

	function AppendHidden( $po_First ) {
		$la_Arguments = func_get_args();
		array_splice( $this->ma_Hidden, count($this->ma_Hidden), 0, array_values( $la_Arguments ) );
	}

	function &GetHidden( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Hidden;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Hidden[ count($this->ma_Hidden) - 1 ];
		return $this->ma_Hidden[$ps_Index];
	}

	function CountHidden() {
		return count( $this->ma_Hidden );
	}
	/* -------------------- end methods to access hidden fields -------------------- */

	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		global $DEBUG;
		
		$la_data =& $this->GetData();
		for($i=0; $i<count($la_data); $i++){
			$lo_item =& $la_data[$i]["data"];
			$lo_item->SetFromArray( $pa_Data );
			$lo_item =& $la_data[$i]["title"];
			if(is_object($lo_item)){
				$lo_item->SetFromArray( $pa_Data );	
			}
		}
		
		foreach( $this->GetHidden() as $lo_Hidden ){
			$lo_Hidden->SetFromArray( $pa_Data );
		}
	}
	/* -------------------- end SetFromArray -------------------- */


	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $pa_FormAttributes ) {
		$lo_Result = new MultiTablesForm( $pa_FormAttributes );
		foreach( $this->GetData() as $la_Data ){
			$lo_title =& $la_Data["title"];
			if(is_object($lo_title) && is_subclass_of($lo_title,"data") ){
				$lo_Result->AppendForm( $la_Data["data"]->GetInputPresentation( array(), 
					$lo_title->GetInputPresentation(), NULL, 0 ) );
			}else{
				$lo_Result->AppendForm( $la_Data["data"]->GetInputPresentation( array(), 
					$lo_title, NULL, 0 ) );
			}	
		}	
		foreach( $this->GetButtons() as $lo_Button )
			$lo_Result->AppendButton( $lo_Button->GetInputPresentation() );
		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );	
		return $lo_Result;
	}

	function GetOutputPresentation() {
		$lo_Result = new MultiTablesForm( array() );
		foreach( $this->GetData() as $la_Data )
			$lo_Result->AppendForm( $la_Data["data"]->GetOutputPresentation( $la_Data["title"] ) );
		return $lo_Result;
	}

	function GetHiddenPresentation() {
		$lo_Result = new CompoundElement();
		foreach( $this->GetData() as $la_Data )
			$lo_Result->AppendToContent( $la_Data["data"]->GetHiddenPresentation() );
		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );	
		return $lo_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
