<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( dirname(__FILE__) . '/class.TableView.php');
include_once( dirname(__FILE__) . '/../data/class.HTMLDataField.php');
include_once( dirname(__FILE__) . '/../data/class.ButtonURLData.php');
include_once( dirname(__FILE__) . '/../data/class.CompoundDataField.php');
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( dirname(__FILE__) . '/../html/class.PagedInfoForm.php');
include_once( dirname(__FILE__) . '/../html/class.DivElement.php');



class PagedTableView extends TableView {

	var $maParameters;
	var $maSteps;
	var $moFormLink;
	var $maHiddens;
	var $maWidths;
	var $miFormIndex;
	var $mcAnchor;
	var $miBodySize;
	var $mcNoItemsMessage;
	

	function PagedTableView( &$poDataSource, $piTotalNumber, $poHeader = NULL, $poFooter = NULL ){
	
		global $DEBUG;

		/*
		if($DEBUG){
			echo "PagedTableView::PagedTableView<br><pre>\n";
			print_r(func_get_args());
			echo "</pre><hr>\n";
		}
		*/
		
		$this->maParameters = array();
		$this->miBodySize = 0;
		$this->mcNoItemsMessage = "No items available!";

		$this->TableView( $poDataSource, $poHeader, $poFooter ); ## call parent constructor 

		$this->TotalNumber( $piTotalNumber );

		if( method_exists( $poDataSource, 'PageSize' ) ) {
			$this->PageSize( $poDataSource->PageSize() );
		}

		if( method_exists( $poDataSource, 'StartIndex' ) ) {
			$this->StartIndex( $poDataSource->StartIndex() );
		}

		$this->Steps( $piTotalNumber );
		$this->maWidths = array();
		$this->miFormIndex = 0;
	}

	function &Widths( $paWidths = NULL ){
		if( is_array( $paWidths ) ){
			$this->maWidths = $paWidths;
		}
		return $this->maWidths;
	}

	function &Anchor( $pcAnchor = NULL ){
		if( !is_null( $pcAnchor ) ){
			$this->mcAnchor = $pcAnchor;
		}
		return $this->mcAnchor;
	}


	function &getWidths(){
		reset( $this->maWidths );
		return $this->maWidths;
	}

	function TotalNumber( $piNumber = NULL ) {
		if( is_numeric( $piNumber ) ){
			$this->maParameters['total_number'] = $piNumber;
		}
		return $this->maParameters['total_number'];
	}

	function StartIndex( $piNumber = NULL ) {
		if( is_numeric( $piNumber ) ){
			$this->maParameters['start_index'] = $piNumber;
		}
		return $this->maParameters['start_index'];
	}
	
	function NoItemsMessage( $pcNoItemsMessage = NULL ) {
		if( is_string( $pcNoItemsMessage ) ){
			$this->mcNoItemsMessage = $pcNoItemsMessage;
		}
		return $this->mcNoItemsMessage;
	}

	function PageSize( $piNumber = NULL ) {
		global $DEBUG;
		if( is_numeric( $piNumber ) ){
			$this->maParameters['page_size'] = $piNumber;
		}
		return $this->maParameters['page_size'];
		if($DEBUG){
			echo "PagedTableView::PageSize<br><pre>\n";
			print_r($this->maParameters);
			echo "</pre><hr>\n";
		}
	}


	function &Parameters( $paParam = NULL ) {
		if( is_array( $paParam ) ) {
			$this->maParameters = $paParam;
		}
		return $this->maParameters;
	}

  function &Steps( $paSteps = NULL ) {

		if( is_array( $paSteps ) ) {
			$this->maSteps = $paSteps;
    }elseif(is_numeric( $paSteps ) ){

      $laSteps = array(  10 => 10 );

      for( $i = 25; $i <= $paSteps ; $i *=2  ){
       $laSteps[$i] = $i;
      }

      $laSteps[$i] = $i;

      $this->maSteps = $laSteps;

    }
		return $this->maSteps;
	}

	function &Hiddens( $paHiddens = NULL ) {
		if( is_array( $paHiddens ) ) {
			$this->maHiddens = $paHiddens;
		}
		return $this->maHiddens;
	}

	function &Parameter( $lcName, $lcValue=NULL ){
		$laParam =& $this->Parameters();
		if(!is_null( $lcValue)){
			$laParam[$lcName] = $lcValue;
		}
		if( array_key_exists( $lcName, $laParam ) ){
			return $laParam[$lcName];
		} else {
			return NULL;
		}
	}

	function &setParameter( $lcName, $lcValue = NULL ){

		$laParam =& $this->Parameters();

		if( is_array( $lcName ) ){
			return $this->Parameters( array_merge( $laParam, $lcName ) );
			 
		}else{
			$laParam[$lcName] = $lcValue;
			return $laParam[$lcName];
		}

	}

	function &FormIndex( $piFormIndex = NULL ){
		if( !is_null($piFormIndex)){
			$this->miFormIndex = $piFormIndex;
		}
		return $this->miFormIndex;
	}

	function &GetOutputPresentation( $paFormAttributes, $poTitle = NULL, 
																	 $poNoData = NULL, $plInputPresentation = FALSE ) {

		global $DEBUG;
		global $confixx_interface_version;

		if( !is_null($poNoData) && is_null( $this->DataSource() ) ){
			return is_object( $pm_NoData ) ? $pm_NoData : new HTMLElement( $pm_NoData );
		}

		$loResult = new PagedInfoForm( $paFormAttributes, $poTitle ); 
		$loResult->FormIndex( $this->FormIndex() );
		$loResult->Anchor( $this->Anchor() );

		if($DEBUG){
			/*
			echo "PagedTableView::GetOutputPresentation<br><pre>\n";
			print_r($loResult);
			echo "</pre><hr>\n";
			*/
		}

		$loPagedForm =& $loResult->getPagedForm();
		
		$loPagedForm->Parameters( $this->Parameters() );
		$loPagedForm->Steps( $this->Steps() );

		$loPagedForm->setStepsElement( $loPagedForm->makeStepsElement() );
		$loPagedForm->setInfoElement( $loPagedForm->makeInfoElement() );

		if( $confixx_interface_version == 'powp' ) {
			$loPagedForm->setPrevNextElement( $loPagedForm->makePageNavigationElement() );

		} else {
			$loPagedForm->setPrevNextElement( $loPagedForm->makePrevNextElement() );
		}


																			 
#
# title
#
		
		$laCellAttributes = array();
		$laRowAttributes = array();

		if ( $laTitleRows =& $this->prepareTitle() ) {
			$liCurRow=0;
			if($this->maParameters['total_number']>0) { 
			foreach ( $laTitleRows as $loTitle ) {
				$loHeader =& $loResult->appendHeaderRow( $laRowAttributes );

				if( is_a( $loTitle,'CompoundValue' ) ) {
				
					$loIterCel =& $loTitle->getTreeIterator();

					while( $loCel =& $loIterCel->getNext() ) {
						$llAppend = TRUE;
						if (is_a( $loCel, 'DataValue' ) ) {

							if ( $loDataField =& $loCel->getDataField() ) { 
								
								$loHTML = $loCel->getPresentation();
								
								$loItem =& $loResult->AppendCell( $loDataField->GetParentAttributes(), $loHTML );
								$llAppend = FALSE;
							} 
						}
						if( $llAppend ) {
							$loItem =& $loResult->AppendCell( $laCellAttributes, new HTMLElement( $loCel->Value() ) );
						}
					}
					
				} elseif( is_a( $loTitle, 'KeyValue' ) ) {
					$loResult->AppendCell( $laCellAttributes, new HTMLElement( $loTitle->Value() )  );
					
				} elseif( method_exists( $loTitle, 'GetInputPresentation' ) ) {
					$loResult->AppendCell( $laCellAttributes, $loTitle->GetInputPresentation()   );

				} elseif( method_exists( $loTitle, 'GetOutputPresentation' ) ) {
					$loResult->AppendCell( $laCellAttributes, $loTitle->GetOutputPresentation()   );
					
				} else {
					$loResult->AppendCell( $laCellAttributes, new HTMLDataField( $loTitle )  );
				}

				if($liCurRow==0){
					$laWidths =& $this->getWidths();
					if(is_array($laWidths)){
						$laCells =& $loHeader->GetContent();

						$lcWidth = current( $laWidths );
						for ( $i = 0; $i < count($laCells); $i++ ) {
							if( $lcWidth ) {
								$laCells[$i]->SetAttribute( 'width', $lcWidth  );
							} else {
								$laCells[$i]->UnsetAttribute( 'width' );
							}
							$lcWidth = next($laWidths);
						}
					}
				}
				$liCurRow++;
			} }
		}

#
# /title
#


#
# body
#
	if($this->maParameters['total_number']>0)  { 
		$loDS =& $this->DataSource();
      
		if( method_exists( $loDS, 'getSetOfRowsData') ){
			$loSetOfRows =& $loDS->getSetOfRowsData();

		} elseif( method_exists( $loDS, 'SetOfRowsData') ){
			$loSetOfRows =& $loDS->SetOfRowsData();

		} else {
			$loSetOfRows = NULL;
		}
		$this->mlBodySize = 0;

		if( is_a( $loSetOfRows,'SetOfRowsData' ) ) {
			$liID=0;
			foreach( $loSetOfRows->GetRows() as $loRow ) {
				$loResult->AppendRow( $laRowAttributes );
				$this->mlBodySize++;
				$liID++;
				foreach( $loRow->GetFields() as $loField ) {
					$laAttributes = $loField->GetParentAttributes();
					$loCell = $plInputPresentation? 
						$loField->GetInputPresentation( $liID ):
						$loField->GetOutputPresentation();

					$loResult->AppendCell( $laAttributes, $loCell );
				}
			}

		} elseif( method_exists( $loDS, 'getConversedRow') ) {

			
			$loIterRow =& $loDS->getFirstIterator();
			while( $loRow =& $loIterRow->getNext() ){


				if($DEBUG){
					echo "PagedTableView::GetOutputPresentation : call getConversedRow<br>\n";
					/*
					echo "<br><pre>\n";
					print_r($loRow);
					echo "</pre><hr>\n";
					*/
				}

				$laCells =& $loDS->getConversedRow( $loRow );

				if( is_array( $laCells ) ) {

					$loResult->AppendRow( $laRowAttributes );
					$this->miBodySize++;

					/*
					if($DEBUG){
						echo "PagedTableView::GetOutputPresentation : the row is accepted ".$this->miBodySize."<br>\n";

						echo "<br><pre>\n";
						print_r( $laCells );
						echo "</pre><hr>\n";
					}
					*/


					foreach ( $laCells as $loDataCell ){

						if( is_array( $loDataCell ) ) {
							list( $loDataCell, $laCellAttributes ) = $loDataCell;
							/*
							if($DEBUG){
								echo "PagedTableView::GetOutputPresentation<pre>\n";
								print_r($loDataCell);
								echo "</pre><hr><pre>\n";
								print_r($laCellAttributes);
								echo "</pre><hr>\n";

			    				}
							*/
						} else {
							$laCellAttributes = array();
						}



						if( is_a( $loDataCell, 'Element' ) ) {

							$loCell = $loDataCell;
							
						} elseif( method_exists( $loDataCell, 'GetOutputPresentation' ) ) {
							$loCell = $plInputPresentation? 
								$loDataCell->GetInputPresentation():  
								$loDataCell->GetOutputPresentation();

							if( method_exists( $loDataCell, 'GetParentAttributes' ) ) {
								$laCellAttributes = $loDataCell->GetParentAttributes();
							} else {
								if($DEBUG){
									echo "PagedTableView::GetOutputPresentation : error : method 'GetParentAttributes' is not exist<br>\n";
								}
							}
						}else{
							if($DEBUG){
					 			echo "PagedTableView::GetOutputPresentation : error : undefined type of cell<br><pre>\n";
								print_r($loDataCell);
								echo "</pre><hr>\n";
							}
						}
						
						$loResult->AppendCell( $laCellAttributes, $loCell  );
					}
					/*
					echo "<br><pre>\n";
					print_r($loResult);
					echo "</pre><hr>\n";
					*/
				}else{
					if($DEBUG){
						echo "PagedTableView::GetOutputPresentation : the row is skiped<br>\n";
					}
				}
				unset($loRow);
			}

		} elseif( is_a( $loDS, 'CompoundValue' ) ){

			$loIterRow =& $loDS->getFirstIterator();
			$liID=0;
			
			while( $loRow =& $loIterRow->getNext() ){
				
				$loResult->AppendRow( $laRowAttributes );
				$this->miBodySize++;
				$liID++;

				unset($loIterCel);
				$loIterCel =& $loRow->getTreeIterator();
				while ( $loCel =& $loIterCel->getNext() ) {

					$loCell = $plInputPresentation? 
						new TextDataField( $loCel->Value(), $loCel->Key().'['.$liID.']' ):
						new HTMLDataField( $loCel->Value() );

					$loResult->AppendCell( $laCellAttributes, $loCell  );

					unset($loCel);

				}
				unset($loRow);
				
			}
		} else {
			if( $DBEUG ) {
				echo "PagedTableView::GetInputPresentation : data source is not found<br><pre>\n";
				print_r($loDS);
				echo "<pre><hr>\n";
			}
		}
	} else { // If no items show message
		$loResultBox = new DivElement(array()); 
		$loResultBox->AppendAttributes(array("align"=>"center"));
		$loResultBox->AppendToContent($this->mcNoItemsMessage);
		$loResult->AppendToContent($loResultBox);
	}
#
# /body
#

#
# buttons
#
		if ( $loButtons =& $this->Buttons() ) {

			if( is_a( $loButtons, 'CompondValue' ) ) {
				$loButtonPanel = new CompoundDataField();
				$loIterCel =& $loButtons->getFirstIterator();
				while ( $loCel =& $loIterCel->getNext() ){
					if( is_a( $loCel, 'ValueButtonHref' ) ) {
						$loButtonPanel->AppendItem( new ButtonURLData( $loCel->Value(), 
																					 $loCel->getLinkDataField() )
																				);
					}
				
				}
			} elseif( is_a( $this->moButtons, 'CompoundDataField' ) ) {
				$loButtonPanel =& $this->moButtons;
			}
			$loResult->AppendButtons( $loButtonPanel->GetInputPresentation() );
		}

#
# /buttons
#
		$loResult->appendToParameters( $this->maHiddens );

		$loResult->updateBodyContent();


		return $loResult;
		
	}

	function &GetInputPresentation( $paFormAttributes, $poTitle = NULL, $poNoData = NULL  ){
		global $DEBUG;
		/*
		if($DEBUG){
			echo "PagedTableView::GetInputPresentation<br><pre>\n";
			print_r(func_get_args());
			echo "</pre><hr>\n";
		}
		*/
		return $this->GetOutputPresentation( $paFormAttributes, $poTitle, $poNoData, TRUE );
	}

	function getBodySize(){
		return $this->miBodySize;
	}
}

?>
