<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.TableElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );





class InfoTable extends FieldsetElement {

	/* -------------------- Members -------------------- */
	var $ms_CurrentHeader; // current row is header - so, add <th>, not <td>
	var $ms_Odd; // current row is odd
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function InfoTable( $pm_Title=NULL ) {
		if($pm_Title){
			$lo_Legend = new LegendElement( array(), $pm_Title );
		}else{
			$lo_Legend = new HTMLElement( '' );
		}
		$lo_Top = new CompoundElement( );
		$lo_Table = new TableElement( array( "class"=>"InfoTable" ) );
		$lo_Help = new CompoundElement( );
		$this->FieldsetElement( array(), $lo_Legend, $lo_Top, $lo_Table, $lo_Help );
		$this->ms_CurrentHeader = FALSE;
		$this->ms_Odd = 1;
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetTop() {
		return $this->GetContent(1);
	}

	function &GetTable() {
		return $this->GetContent(2);
	}

	function &GetHelp() {
		return $this->GetContent(3);
	}
	/* -------------------- end methods for internal use only -------------------- */





	/* -------------------- add cells/rows to table -------------------- */
	function AppendRow( $pa_Attributes, $ps_Header = FALSE ) {
		$this->ms_CurrentHeader = $ps_Header;
		$lo_Table =& $this->GetTable();
		if( !$ps_Header ) {
			if( $this->ms_Odd )
				$la_Attributes = array_merge( $pa_Attributes, array( "class"=>"oddrowbg" ) );
			else
				$la_Attributes = array_merge( $pa_Attributes, array( "class"=>"evenrowbg" ) );
			$this->ms_Odd ^= 1;
		}
		else
			$la_Attributes = $pa_Attributes;
		$lo_Table->AppendRow( $la_Attributes );
	}

	function AppendCell( $pa_Attributes ) {
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent( cc_LastElement );
		$la_Arguments = func_get_args();
		array_splice( $la_Arguments, 1, 0, $this->ms_CurrentHeader );
		call_user_func_array( array( &$lo_Row, "AppendCell" ), $la_Arguments );
	}
	/* -------------------- end add cells/rows to table -------------------- */





	/* -------------------- add help -------------------- */
	function AppendHelp( $pm_Text ) {
		$lo_Help =& $this->GetHelp();
		foreach( func_get_args() as $lm_Text )
			$lo_Help->AppendToContent( new PElement( array(), is_object($lm_Text) ? $lm_Text :
						new HTMLElement( $lm_Text ) ) );
	}
	/* -------------------- end add help -------------------- */





	/* -------------------- add to top -------------------- */
	function AppendTop( $pm_Text ) {
		$lo_Top =& $this->GetTop();
		$lo_Top->AppendToContent( new PElement( array(), $pm_Text ) );
	}
	/* -------------------- end add to top -------------------- */





	/* -------------------- SetWidths -------------------- */
	function SetWidths( $ps_First ){
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent(0);
		if( is_object($lo_Row) ) {
			$la_Widths = func_get_args();
			$la_Cells =& $lo_Row->GetContent();
			for ( $i=0; $i<count($la_Widths) && $i<count($la_Cells); $i++ )
				$la_Cells[$i]->AppendAttributes( array( "width"=>$la_Widths[$i] ) );
		}
	}
	/* -------------------- end SetWidths -------------------- */

}
?>
