<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.TDElement.php" );
include_once( dirname(__FILE__) . "/class.THElement.php" );





class TRElement extends TagWithEndElement {

	var $mlHeader; /* this row is a header row */

	/* -------------------- Constructor -------------------- */
	function TRElement( $pa_Attributes ) {
		global $DEBUG;
		$la_Arguments = func_get_args();
		array_unshift( $la_Arguments, "tr" );
		$this->isHeader( FALSE );
		call_user_func_array( array( &$this, "TagWithEndElement" ), $la_Arguments );
	}
	/* -------------------- end Constructor -------------------- */




	function &isHeader( $plHeader = NULL ){
		global $DEBUG;
		if( !is_null( $plHeader ) ) {
			$this->mlHeader = $plHeader;
		}

		return $this->mlHeader;
	}


	/* -------------------- cells (td/th elements) -------------------- */
	function &AppendCell( $pa_Attributes, $ps_TH = NULL ) {

		$la_Arguments = func_get_args();

		if(is_object($pa_Attributes)){
			$pa_Attributes = array();
			$ps_TH = NULL;

		} elseif(is_object($ps_TH)){
			array_shift( $la_Arguments );
			$ps_TH = NULL;

		} else {
			array_splice( $la_Arguments, 0, 2 );
		}
		
		if( is_null( $ps_TH ) ) {
			$ps_TH = $this->isHeader();
		}
		$lo_Cell = $ps_TH ? new THElement( $pa_Attributes ) : new TDElement( $pa_Attributes );

		if( count( $la_Arguments ) )
			call_user_func_array( array( &$lo_Cell, "AppendToContent" ), $la_Arguments );
		return $this->AppendToContent( $lo_Cell );
	}


	function &AppendHeaderCell( $pa_Atributes = array() ){
		$la_Arguments = func_get_args();
		if( is_object( $pa_Atributes )){
			$paAtributes = array();
		}else{
			array_shift( $la_Arguments );
		}
		$lo_Cell = new THElement( $pa_Attributes );

		if( count( $la_Arguments ) )
			call_user_func_array( array( &$lo_Cell, "AppendToContent" ), $la_Arguments );
		return $this->AppendToContent( $lo_Cell );
	}

	/* -------------------- end cells (td/th elements) -------------------- */





	/* -------------------- GetColSpan -------------------- */
	function GetColSpan() {
		$ls_Result = 0;
		foreach( $this->GetContent() as $lo_Cell )
			$ls_Result += $lo_Cell->GetAttribute("colspan") ? $lo_Cell->GetAttribute("colspan") : 1;
		return $ls_Result;
	}
	/* -------------------- end GetColSpan -------------------- */

}
?>
