<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Element.php" );





class TextElement extends Element {

	/* -------------------- Members -------------------- */
	var $ms_Text; // text of element, will be encoded before output
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function TextElement( $ps_Text ) {
		$this->Element();
		$this->SetText( $ps_Text );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetText( $ps_Text ) {
		$this->ms_Text = $ps_Text;
	}

	function GetText() {
		return $this->ms_Text;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- GetHTML -------------------- */
	function GetHTML() {
		return htmlspecialchars( $this->GetText() );
	}
	/* -------------------- end GetHTML -------------------- */

}
?>
