<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'Mail/IMAPv2.php' );

/**
 * Wrapper for PEAR:: Mail_IMAPv2
 *
 * @author       Confixx team
 * @category     Mail
 */
class ConfixxIMAPv2 extends Mail_IMAPv2
{
  /**
   * Constructor
   */
  function ConfixxIMAPv2()
  {
    $laArgs = func_get_args();
    call_user_func_array( array( &$this, 'Mail_IMAPv2'), $laArgs );
  }

   /**
    * Simply return mailbox resource
    *
    * @return   Resource of type (imap)
    */
    function getMailbox()
    {
        return $this->mailbox;
    }

   /**
    * Set member variable containing header information.  Creates an array containing
    * associative indices referring to various header information.  Use {@link var_dump}
    * or {@link print_r} on the {@link $header} member variable to view information
    * gathered by this function.
    *
    * If $ret is true, returns array containing header information on success and false
    * on failure.
    *
    * If $ret is false, adds the header information to the $header member variable
    * and returns BOOL.
    *
    * @param    int     &$mid           message id
    * @param    string  &$pid           (optional) part id to retrieve headers for.
    * @param    bool    $rtn
    *   (optional) If true return the headers, if false, assign to $header member variable.
    *
    * @param    array   $args
    *   (optional) Associative array containing extra arguments.
    *
    *       $args['from_length'] int
    *           From field length for imap_headerinfo.
    *
    *       $args['subject_length'] int
    *           Subject field length for imap_headerinfo
    *
    *       $args['default_host'] string
    *           Default host for imap_headerinfo & imap_rfc822_parse_headers
    *
    * @return   Array|BOOL
    */

    function getHeaders(&$mid, $pid = '0', $rtn = false, $args = array())
    {
        $this->_checkIfParsed($mid);

        if ($pid == $this->msg[$mid]['pid']) {
            $pid = '0';
        }

        if ($pid !== '0') {
            if (false === ($raw_headers = $this->getRawHeaders($mid, $pid, true, true))) {
                return false;
            }

            if ($raw_headers === true) {
                $pid = '0';
            }
        }

        if (!isset($args['from_length'])) {
            $args['from_length'] = 1024;
        }

        if (!isset($args['subject_length'])) {
            $args['subject_length'] = 1024;
        }

        if (!isset($args['default_host'])) {
            $args['default_host'] = null;
        }

        // Parse the headers
        $header_info = 
        	($pid === '0')?
                imap_headerinfo($this->mailbox, $mid, $args['from_length'], $args['subject_length'], $args['default_host'])
            :
                imap_rfc822_parse_headers($raw_headers, $args['default_host']);

        // Since individual member variable creation might create extra overhead,
        // and having individual variables referencing this data and the original
        // object would be too much as well, we'll just copy the object into an
        // associative array, preform clean-up on those elements that require it,
        // and destroy the original object after copying.

        if (!is_object($header_info)) {
            $this->error->push(
                Mail_IMAPv2_ERROR_INVALID_PID,
                'error',
                array(
                    'pid' => $pid
                )
            );
            return false;
        }

        $headers = get_object_vars($header_info);

        foreach ($headers as $key => $value) {
      
          
            if (!is_object($value) && !is_array($value)) {
                // Decode all the headers using utf8_decode(imap_utf8())
                $this->header[$mid][$key] = $value;
            }
        }

        // copy udate or create it from date string.
        $this->header[$mid]['udate'] = (isset($header_info->udate) && !empty($header_info->udate))? 
            $header_info->udate
        :
            strtotime($header_info->Date);

        // clean up addresses
        $line = array(
        	'from',
        	'reply_to',
       		'sender',
        	'return_path',
        	'to',
        	'cc',
        	'bcc'
        );

        for ($i = 0; $i < count($line); $i++) {
            if (isset($header_info->$line[$i])) {
                $this->_parseHeaderLine($mid, $header_info->$line[$i], $line[$i]);
            }
        }

        // All possible information has been copied, destroy original object
        unset($header_info);

        return ($rtn)? $this->header[$mid] : false;
    }

   /**
    * Wrapper method for {@link imap_open}.  Accepts a URI abstraction in
    * the following format: imap://user:pass@mail.example.com:143/INBOX#notls
    * instead of the standard connection arguments used in imap_open.
    * Replace the protocol with one of pop3|pop3s imap|imaps nntp|nntps.
    * Place intial folder in the file path portion, and optionally append
    * tls|notls|novalidate-cert in the anchor portion of the URL.  A port
    * number is optional, however, leaving it off could lead to a serious
    * degradation in preformance.
    *
    * Since Mail_IMAPv2 0.1.0 the $options argument became the $get_info argument.
    * constants for action were removed and the argument is now a BOOL toggle.
    *
    * Fixed bug with / symbol in password
    *
    * @param    string           $uri   server URI
    * @param    bool             $get_info
    *   (optional) true by default. If true, make a call to {@link getMailboxInfo}
    *   if false do not call {@link getMailboxInfo}
    * @return   BOOL
    * @tutorial http://www.smilingsouls.net/index.php?content=Mail_IMAP/connect
    * @access   public
    * @see      imap_open
    */
    function connect($uri, $get_info = true)
    {

        if (!class_exists('Net_URL') && !@include_once('Net/URL.php')) {
			$this->error->push(Mail_IMAPv2_ERROR, 'error', null, 'Inclusion of Net_URL not successful.');
            return false;
        }
        $opt = (isset($this->option['open']))? $this->option['open'] : null;

        $net_url =& new Net_URL($uri);

        $uri  = '{'.$net_url->host;

        if (!empty($net_url->port)) {
            $uri .= ':'.$net_url->port;
        }

        $secure   = ('tls' == substr($net_url->anchor, 0, 3))? '' : '/ssl';

        $uri .= ('s' == (substr($net_url->protocol, -1)))? '/'.substr($net_url->protocol, 0, 4).$secure : '/'.$net_url->protocol;

        if (!empty($net_url->anchor)) {
            $uri .= '/'.$net_url->anchor;
        }

        $uri .= '}';

        $this->mailboxInfo['Mail_IMAPv2']['version'] = 'Mail_IMAPv2 0.2.0 Beta';
        $this->mailboxInfo['host'] = $uri;

        // Trim off the leading slash '/'
        if (!empty($net_url->path)) {
            $this->mailboxInfo['folder'] = substr($net_url->path, 1, (strlen($net_url->path) - 1));
            $uri .= $this->mailboxInfo['folder'];
        }

        $this->mailboxInfo['user'] = urldecode($net_url->user);
        if (false === ($this->mailbox = @imap_open($uri, urldecode($net_url->user), urldecode($net_url->pass), $opt))) {
            $this->error->push(
            	Mail_IMAPv2_ERROR,
            	'error',
            	null,
            	'Unable to build a connection to the specified mail server.'
            );
            $ret = false;
        } else {
            $ret = true;
        }

        // get mailbox info
        if ($get_info) {
            $this->getMailboxInfo(false);
        }

        return $ret;
    }

}	
?>
