<?

function run_soap( $script, &$args, $listen=NULL ){
	global $ServerID, $DEBUG, $PHP_AUTH_USER;

	if( $DEBUG ){
		echo "run_soap: args<br><pre>\n";
		print_r( $args );
		echo "</pre><hr>\n";
	}

	if( array_key_exists( 'server_id', $args ) ){
		$lcServerID = $args['server_id'];
		unset( $args['server_id'] );
	}else{
		$lcServerID = $ServerID;
	}

	if( ! array_key_exists( 'h', $args ) ){
		$id = safe_query2( "SELECT confixx_domain FROM admin WHERE server_id=?",
											 new SQLString( $lcServerID ) );
		list( $local_host ) = db_fetch_array( $id );
		db_free_query( $id );
	
		$args['h'] = $local_host;
	}

	/*
	echo "run_soap: _SESSION<br><pre>\n";
	print_r($_SESSION);	
	echo "</pre><hr>\n";
	*/

	if( ! array_key_exists( 'l', $args ) ){
		$args['l'] = $PHP_AUTH_USER;
		$args['p'] = '"'.$_SESSION['_users'][$ServerID][$PHP_AUTH_USER]['password'].'"';
	}

	/*
	if( $DEBUG ){
		$args['dbg'] = NULL;
	}
	*/
	
	foreach( $args as $key => $val ){
		$script .= " -$key";
		if( is_string($val) && $val ){
			$script .= "=$val";
		}
	}

	$script .= ' 2>&1';

	if( is_array( $listen ) && count( $listen ) > 0 ){
		$reHead = '/^('.join( '|', $listen ).'|error-)/';
	}else{
		$reHead = '/^error-/';
	}

	if( $DEBUG ){
		echo "run_soap: $script<br><pre>\n";
	}

	$result = array();

	$fh = popen( $script, 'r' );
	while( ! feof( $fh ) ){
		$line = fgets( $fh, 1024 );

		if( $DEBUG ){
			echo htmlspecialchars( $line );
		}

		list( $key, $value ) = split( ':', $line, 2 );
		$key = trim( $key );
		if( ! preg_match( $reHead, $key, $matches ) ){
			continue;
		}
		$group = $matches[1];
		$value = trim($value);
		if( ! array_key_exists( $group, $result )){
			$result[ $group ] = array();
		}
		
		if( $group == 'error-' ){
			if( array_key_exists( $key, $result[$group] )){
				$result[$group][$key] .= "<br>\n".$value;
			}else{
				$result[$group][$key] = $value;
			}
		}else{
			if( array_key_exists( $key, $result[$group] )){
				$result[$group][$key][] = $value;
			}else{
				$result[$group][$key] = array( $value );
			}
		}
	}
	if( $DEBUG ){
		echo "\nResult:\n";
		print_r($result);
		echo "</pre>\n";
	}
	pclose( $fh );

	return $result;
}

?>