<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( 'class.UserMysql.php' );

function addDbSet( &$poRows, &$paInds, &$paParams, $piWebappId ){
	global $PHP_AUTH_USER, $ServerID;
	$laSet = array();
	foreach( $paInds as $liInd ){
		$lcName = "values[$liInd]";
		$lcValue = $paParams[$liInd]['value'];
		$lcRole = $paParams[$liInd]['role'][2];
		if( $lcRole == 'user' && ! $lcValue ){
			$lcValue = $PHP_AUTH_USER;
		}
		$laSet[$lcRole] = array( $lcName, $lcValue );
	}

	//	echo "addDbSet<br><pre>\n";
	//	print_r($laSet);
	//	echo "</pre><hgr>\n";

	$loUser = new SQLString( $PHP_AUTH_USER );
	$loServerID = new SQLString( $ServerID );

	$laOptions['new'] = ltext( 'wa_db_create' );
	$id = safe_query2( " SELECT dbname, kommentar FROM mysql_datenbanken ".
										 " WHERE kunde=? AND server_id=?".
										 " ORDER BY dbname", $loUser, $loServerID );

	while( list($lcName, $lcComment) = db_fetch_array($id,'N')){
		if( $lcComment ){
			if( strlen( $lcComment ) > 16 ){
				$lcComment = substr( $lcComment, 0, 14 ).'...';
			}
			$lcComment = $lcName.' '.$lcComment;
		}else{
			$lcComment = $lcName;
		}
		$laOptions[$lcName] = $lcComment;
	}
	db_free_query( $id );

	$loTitle = new HTMLDataField( ltext('wa_db_options') );
	$loTitle->SetColSpan( 2 );
	$loTitle->ParentAttribute( 'align', 'left' );
	$poRows->AppendHeaderRow( $loTitle );

	$poRows->AppendRow( new HTMLDataField( ltext( 'wa_db_name' ) ), 
											new OptionsDataField( $laOptions, 
																						$laSet['name'][1],
																						$laSet['name'][0] 
																						)
											);

	$loCheck = new CheckDataField( 1,	'clean_db' );

	$id = safe_query2("SELECT clean_db FROM webapp_user WHERE kunde=? AND server_id=? AND webapp_id=?",
										$loUser, $loServerID, new SQLInteger( $piWebappId ));
	list( $liClean ) = db_fetch_array( $id );
	db_free_query( $id );

	$loCheck->isChecked( $liClean );

	$poRows->AppendRow( new HTMLDataField( ltext('wa_db_clean') ),
										$loCheck );

	
  $poRows->AppendRow( new HTMLDataField( ltext( 'wa_db_user' ) ), 
											new TextDataField( $laSet['user'][1],
																				 $laSet['user'][0] )
											);

  $poRows->AppendRow( new HTMLDataField( ltext( 'wa_db_password' ) ), 
											new PasswordDataField( $laSet['passwd'][1],
																						 $laSet['passwd'][0] )
											);
	
}

function addAdminSet( &$poRows, &$paInds, &$paParams, $pcGroup = 'admin' ){
	global $PHP_AUTH_USER, $ServerID;
	global $DEBUG;

	$laSet = array();
	foreach( $paInds as $liInd ){
		$lcValue = $paParams[$liInd]['value'];
		$lcRole = $paParams[$liInd]['role'][2];
		if( $lcRole == 'passwd' ){
			$lcName = "values[$liInd][]";
		}else{
			$lcName = "values[$liInd]";
		}
		$laSet[$lcRole] = array( $lcName, $lcValue );
	}

	$loTitle = new HTMLDataField( ltext('wa_'.$pcGroup.'_options') );
	$loTitle->SetColSpan( 2 );
	$loTitle->ParentAttribute( 'align', 'left' );
	$poRows->AppendHeaderRow( $loTitle );

	if( array_key_exists( 'login', $laSet ) ){
		$lcValue = $laSet['login'][1];
		if( ! $lcValue ){
			$lcValue = 'admin';
		}
    $poRows->AppendRow( new HTMLDataField( ltext( 'wa_'.$pcGroup.'_login' ) ), 
												new TextDataField( $lcValue,
																					 $laSet['login'][0] )
												);
	}

	if( array_key_exists( 'name', $laSet ) ){
		$lcValue = $laSet['name'][1];
		if( ! $lcValue ){
			$lcValue = 'admin';
		}
    $poRows->AppendRow( new HTMLDataField( ltext( 'wa_'.$pcGroup.'_name' ) ), 
												new TextDataField( $lcValue,
																					 $laSet['name'][0] )
												);
	}

	if( array_key_exists( 'email', $laSet ) ){
		$lcValue = $laSet['email'][1];
    $poRows->AppendRow( new HTMLDataField( ltext( 'wa_'.$pcGroup.'_email' ) ), 
												new TextDataField( $lcValue,
																					 $laSet['email'][0] )
												);
	}

	if( array_key_exists( 'passwd', $laSet ) ){
    $poRows->AppendRow( new HTMLDataField( ltext( 'wa_'.$pcGroup.'_passwd' ) ), 
												new PasswordDataField( $laSet['passwd'][1],
																							 $laSet['passwd'][0] )
												);

    $poRows->AppendRow( new HTMLDataField( ltext( 'wa_'.$pcGroup.'_passwd2' ) ), 
												new PasswordDataField( $laSet['passwd'][1],
																							 $laSet['passwd'][0].'2' )
												);
	}
}

function addPersInfoSet( &$poRows, &$paInds, &$paParams ){
	global $DEBUG;

  $laSet = array();
  $liVisibleCount = 0;

	foreach( $paInds as $liInd ){
		$lcValue = $paParams[$liInd]['value'];
		$lcRole = $paParams[$liInd]['role'][2];
		$lcName = "values[$liInd]";
		$laSet[$lcRole] = array( $lcName, $lcValue,  $paParams[$liInd]['valtype'] );
	}

	if($DEBUG){
		echo "personal info:<br><pre>\n";
		print_r( $laSet );
		echo "</pre><hr>\n";
	}

	foreach( $laSet as $lcRole => $laParam ){
    list( $lcName, $lcValue, $lcValType ) = $laParam;
    
    if( $lcValType != 'hidden' ){
      if( $liVisibleCount == 0 ){
	      $loTitle = new HTMLDataField( ltext('wa_persinfo_options') );
        $loTitle->SetColSpan( 2 );
        $loTitle->ParentAttribute( 'align', 'left' );
        $poRows->AppendHeaderRow( $loTitle );
        $liVisibleCount++;
      }
      $poRows->AppendRow( new HTMLDataField( ltext( 'wa_persinfo_'.$lcRole ) ), 
												new TextDataField( $lcValue,
																					 $lcName ));
    }else{
      $poRows->AppendHidden( new TextDataField( $lcValue, $lcName ) );
    }
	}

}

function addAppSet( &$poRows, &$paInds, &$paParams, $pcWebapp = '' ){
	global $DEBUG;

  $laSet = array();
  $liVisibleCount = 0;

	foreach( $paInds as $liInd ){
		$lcValue = $paParams[$liInd]['value'];
		$lcRole = $paParams[$liInd]['role'][2];
		$lcName = "values[$liInd]";
		$laSet[$lcRole] = array( $lcName, $lcValue,  $paParams[$liInd]['valtype'] );
	}

	if( $DEBUG ){
		echo "application:<br><pre>\n";
		print_r( $laSet );
		echo "</pre><hr>\n";
	}


	foreach( $laSet as $lcRole => $laParam ){
		list( $lcName, $lcValue, $lcValType ) = $laParam;

		if( $lcRole == 'path' && ! $lcValue){
			$lcValue = $pcWebapp;
		}
    
    if( $lcValType != 'hidden' ){
      if( $liVisibleCount == 0 ){
        $loTitle = new HTMLDataField( ltext('wa_app_options') );
        $loTitle->SetColSpan( 2 );
        $loTitle->ParentAttribute( 'align', 'left' );
        $poRows->AppendHeaderRow( $loTitle );
        $liVisibleCount++;
      }
      $poRows->AppendRow( new HTMLDataField( ltext( 'wa_app_'.$lcRole ) ), 
                          new TextDataField( $lcValue,
                                             $lcName )
                          );
    }else{
      $poRows->AppendHidden( new TextDataField( $lcValue, $lcName ) );
    }
	}

}


function addCompanySet( &$poRows, &$paInds, &$paParams ){

}


function addServerSet( &$poRows, &$paInds, &$paParams ){

}

function addFileSet( &$poRows, &$paInds, &$paParams ){

}

function addUnknownSet( &$poRows, &$paInds, &$paParams, $pcRealm = 'unkn' ){

	$lcPrefix = 'wa_'.$pcRealm.'_';
  $liVisibleCount = 0;

	foreach( $paInds as $liInd ){
		$lcName = "values[$liInd]";
		$lcValue = $paParams[$liInd]['value'];

		$lcKey = $lcPrefix.$lcName;

    $lcLocale = ltext( $lcKey );

		if( ! $lcLocale ){
			$lcLocale = $lcName;
    }

    if( $paParams[$liInd]['valtype'] != 'hidden' ){

      if( $liVisibleCount == 0 ){
        $loTitle = new HTMLDataField( ltext('wa_unkn_options') );
        $loTitle->SetColSpan( 2 );
        $loTitle->ParentAttribute( 'align', 'left' );
        $poRows->AppendHeaderRow( $loTitle );
        $liVisibleCount++;
      }

      $poRows->AppendRow( new HTMLDataField( $paParams[$liInd]['name'] ),
                          new TextDataField( $lcValue, $lcName ) );
     }else{
      $poRows->AppendHidden( new TextDataField( $lcValue, $lcName ) );
    }
  }

  
}

function &getParams( &$paIds, &$paValues, &$paRoles, $paNames ){
	foreach( $paNames as $lcName ){
		$llNotFound = TRUE;
		foreach( $paIds as $liId ){
			if( $paRoles[$liId] == $lcName ){
				$laRet[] = $paValues[$liId];
				$llNotFound = FALSE;
				break;
			}
		}
		if( $llNotFound ){
			$laRet[] = NULL;
		}
	}
	return $laRet;
}

function checkDbSet( &$paIds, &$paNames, &$paValues, &$paRoles, $pcWebAppName = '' ){
	global $PHP_AUTH_USER, $ServerID, $DEBUG;

	$loMysqlUser = new UserMysql( $PHP_AUTH_USER );

	$laRoleValues = array();
	$liNameInd = 0;
	foreach( $paIds as $liId ){
		$laRoleValues[$paRoles[$liId]] = $paValues[$liId];
		if( $paRoles[$liId] == 'name' ){
			$liNameInd = $liId;
		}
	}

	if( $DEBUG ){
		echo "checkDbSet<br><pre>\n";
		print_r($laRoleValues);
		echo "</pre><hr>\n";
	}
	if( ! $laRoleValues['passwd'] ){
		return ltext( 'wa_db_err_emprty_passwd' );
	}

	if( $laRoleValues['name'] == 'new' ){
		$lcDbName = $loMysqlUser->registerNewDB( $pcWebAppName );
		if( ! $lcDbName ){
			return $loMysqlUser->getError();
		}

		$loMysqlUser->createDB( $lcDbName, $laRoleValues['passwd'] );

		$paValues[$liNameInd] = $lcDbName;
		
	}

	
	//	echo "checkDbSet:<br><pre>\n";
	//	print_r($paValues);
	//	echo "</pre><hr>\n";

	if( ! $loMysqlUser->checkPassword( $laRoleValues['passwd'] ) ){
		return ltext( 'wa_db_err_passwd' );
	}

	return NULL; // OK
}

function checkAdminSet( &$paIds, &$paNames, &$paValues, &$paRoles, $pcGroup='admin' ){
	foreach( $paIds as $liId ){
		if( $paRoles[$liId] == 'passwd' ){
			if( is_array( $paValues[$liId] ) ){
				list( $lcPasswd, $lcPasswd2 ) = $paValues[$liId];
				if( $lcPasswd !== $lcPasswd2 ){
					$paValues[$liId] = NULL;
					return ltext( 'wa_admin_err_passwds' );
				}
			}
		}
	}
	return NULL; // OK
}

?>
