<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.SQLValuesSource.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../module.Database.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../module.Genlib.php" );





class IPRestrictionValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function IPRestrictionValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
    {
	$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
       global $ServerID;
	     return "SELECT id, ip, rest FROM iprestriction WHERE server_id='$ServerID'" . $this->GetOrder();
    }

    function GetSearchSQL ( &$pa_Search )
    {
      global $ServerID;
    	if ( ! $this->CheckIP(ff_GetFromPostGet("ipsearch")) ) return "SELECT NULL";
    	$regip = str_replace("*","[0-9|*]*",ff_GetFromPostGet("ipsearch")); 
    	$regip = str_replace(".",")[.]([*]|",$regip);
    	$regip = "([*]|".$regip.")";	
		return 'SELECT id, ip, rest FROM iprestriction WHERE server_id=\''.$ServerID.'\' AND  ip REGEXP "^' . db_quote( $regip ) . '$" ' . $this->GetOrder();
    }

    // to help GetBrowseSQL & GetSearchSQL
    function GetOrder()
    {
	$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
	switch ( $this->GetSortColumn() )
	{
	    case "accept":
		return " ORDER BY rest $ls_Reverse ";
	    case "ip":
	    default:
		return " ORDER BY INET_ATON(REPLACE(ip,'*','255')) $ls_Reverse ";
	}
    }

    function GetDefaultSort()
    {
	return "ip";
    }

    function GetCountBrowseSQL()
    {
      global $ServerID;
	    return "SELECT COUNT(*) FROM iprestriction WHERE server_id='$ServerID'";
    }

    function GetCountSearchSQL()
    {
      global $ServerID;
    	if ( ! $this->CheckIP(ff_GetFromPostGet("ipsearch")) ) return "SELECT NULL";
    	$regip = str_replace("*","[0-9|*]*",ff_GetFromPostGet("ipsearch")); 
    	$regip = str_replace(".",")[.]([*]|",$regip);
    	$regip = "([*]|".$regip.")";    	
		return 'SELECT COUNT(*) FROM iprestriction WHERE  server_id=\''.$ServerID.'\' AND ip REGEXP "^' . db_quote( $regip ) . '$" ' . $this->GetOrder();
    }

    function AddElement()
    {
      global $ServerID;
	$ls_IP = ff_GetFromPostGet ("ip");
	if ( ! $this->CheckIP($ls_IP) )
	    return array( "message"=>ltext( "ipr_incorrectip", array($ls_IP) ) );
	$ls_Restriction = ff_GetFromPostGet ("rest");
	if ( $ls_Restriction != "accept" )
	    $ls_Restriction = "deny";
	$lo_DB =& get_db_connection();
	$lo_DB->Execute
		( "INSERT INTO iprestriction ( ip, rest, server_id ) VALUES ( '" . db_quote($ls_IP) . "', '$ls_Restriction', $ServerID )" );
	return NULL;
    }

    function EditElements()
    {
      global $ServerID;
	$ls_Error = "";
	$la_IPs = ff_GetFromPostGet ("ip");
	$la_Restritions = ff_GetFromPostGet ("rest");

	if ( !is_array($la_IPs) )
	    return;
	$lo_DB =& get_db_connection();
	foreach ( $la_IPs as $ls_ID => $ls_IP )
	{
	    if ( ! $this->CheckIP($ls_IP) )
	    {
		$ls_Error = ltext( "ipr_incorrectip", array($ls_IP) ); // some error messages are lost
		continue;
	    }
	    $ls_Restriction = $la_Restritions[$ls_ID]?'accept':'deny';

			$sql = "UPDATE iprestriction SET ip = '" . db_quote($ls_IP) .
		    "', rest = '$ls_Restriction' WHERE id = '" . db_quote($ls_ID) . "' AND  server_id='$ServerID'";

	    $lo_DB->Execute ( $sql );
	}
	return strlen ($ls_Error) ? array( "message"=>$ls_Error ) : NULL;
    }

    function DeleteElements ( &$pa_IDs )
    {
      global $ServerID;
	if ( count($pa_IDs) )
	{
	    $lo_DB =& get_db_connection();
	    for ( $i=0; $i<count($pa_IDs); $i++ )
		$pa_IDs[$i] = "'" . db_quote($pa_IDs[$i]) . "'";
	    $lo_DB->Execute ( "DELETE FROM iprestriction WHERE server_id='$ServerID' AND id IN ( " . implode( ",", $pa_IDs ) . " )" );
	    return 1; // not absolutely correct
	}
	return 0;
    }

    function ValidateAdd()
    {
	return NULL;
    }

    function ValidateEdit()
    {
	return NULL;
    }

    function ValidateDelete()
    {
	return NULL;
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- other methods -------------------- */
    function CheckIP ( $ps_IP )
    {
    return preg_match ( "/^(\*|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(\*|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){1,3}$/", $ps_IP );
    }

    function NewDeny ( $ps_ID, $ps_IP )
    {
      global $ServerID;
	$lo_DB =& get_db_connection ();
	$lo_Query = $lo_DB->Select ( "SELECT id FROM iprestriction WHERE  server_id='$ServerID' AND id=".db_full_quote($ps_ID)." AND ip=".
		db_full_quote($ps_IP)." AND rest = 'deny'" );
	return $lo_Query->nextrow() ? FALSE : TRUE;
    }
    /* -------------------- end other methods -------------------- */

}
?>
