<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.SQLValuesSource.php" );
include_once ( dirname(__FILE__) . "/../module.Database.php" );
include_once ( dirname(__FILE__) . "/../module.Genlib.php" );





class MenuBlocksValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function MenuBlocksValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
    {
	$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
      global $ServerID;
	return "SELECT menublock.id, menublock.label, usertype, COUNT(menuitem.id) AS itemscount, overview FROM menublock
		LEFT JOIN menuitem ON menuitem.menublock_id=menublock.id AND menublock.server_id=menuitem.server_id WHERE menublock.server_id='$ServerID' GROUP BY menublock.id " . $this->GetOrder();
    }

    // to help GetSearchSQL & GetCountSearchSQL
    function GetSearch ( &$pa_Search )
    {
	$ls_Label = strlen($pa_Search[0]->GetValue()) ?
		" menublock.label LIKE '%" . db_quote($pa_Search[0]->GetValue()) . "%'" : "";
	$ls_UserType = strlen($pa_Search[1]->GetValue()) ?
		" menublock.usertype LIKE '%" . db_quote($pa_Search[1]->GetValue()) . "%'" : "";
	return strlen($ls_Label) && strlen($ls_UserType) ? "$ls_Label AND $ls_UserType" : "$ls_Label $ls_UserType";
    }

    // to help GetBrowseSQL & GetSearchSQL
    function GetOrder()
    {
	$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
	switch ( $this->GetSortColumn() )
	{
	    case "usertype":
		return " ORDER BY menublock.usertype $ls_Reverse ";
	    case "label":
	    default:
		return " ORDER BY menublock.label $ls_Reverse ";
	}
    }

    function GetDefaultSort()
    {
	return "label";
    }

    function GetSearchSQL ( &$pa_Search )
    {
      global $ServerID;
	return "SELECT menublock.id, menublock.label, usertype, COUNT(menuitem.id) AS itemscount, overview FROM menublock
		LEFT JOIN menuitem ON menuitem.menublock_id=menublock.id  AND menublock.server_id=menuitem.server_id WHERE menublock.server_id='$ServerID' AND " . $this->GetSearch($pa_Search) . "
		GROUP BY menublock.id " . $this->GetOrder();
    }

    function GetCountBrowseSQL()
    {
      global $ServerID;
	    return "SELECT COUNT(*) FROM menublock WHERE server_id='$ServerID'";
    }

    function GetCountSearchSQL ( &$pa_Search )
    {
      global $ServerID;
	    return "SELECT COUNT(*) FROM menublock WHERE server_id='$ServerID' AND " . $this->GetSearch($pa_Search);
    }

    function GetElementSQL()
    {
      global $ServerID;
	    return "SELECT id, label, overview, usertype FROM menublock WHERE server_id='$ServerID' AND id=" . ff_GetFromPostGet("menublock_id");
    }

    function AddElement()
    {
      global $ServerID;
    	$lo_DB =& get_db_connection();
    	$lo_DB->Execute ( "
    		INSERT INTO menublock ( label, usertype, overview, server_id )
    		VALUES ( " . db_full_quote($_POST["label"]) . ", " . db_full_quote($_POST["usertype"]) . ", " .
    		db_full_quote($_POST["overview"]) . ", '$ServerID' )" );
    	return NULL;
    }

    function EditElements()
    {
      global $ServerID;
	$lo_DB =& get_db_connection();
	if ( is_array($_POST["label"]) )
	    foreach ( $_POST["label"] as $ls_ID => $ls_Value )
	    {
		$lo_DB->Execute ( "UPDATE menublock SET label=" . db_full_quote($ls_Value) . ", usertype=" .
			db_full_quote($_POST["usertype"][$ls_ID]) . ", overview=" .
			db_full_quote($_POST["overview"][$ls_ID]) .
			" WHERE server_id='$ServerID' AND id=" . db_full_quote($ls_ID) );
	    }
	return NULL;
    }

    function DeleteElements ( &$pa_IDs )
    {
      global $ServerID;
	$lo_DB =& get_db_connection();
	$ls_IDs = implode( ",", db_full_quote_array($pa_IDs) );
	$lo_DB->lockTables ( NULL, array( "menuitem", "menublock" ) );
	$lo_DB->Execute ( "DELETE FROM menuitem WHERE server_id='$ServerID' AND menublock_id IN ( $ls_IDs )" );
	$lo_DB->Execute ("DELETE FROM menublock WHERE server_id='$ServerID' AND id IN ( $ls_IDs )");
	$lo_DB->unLockTables();
    }

    function ValidateAdd()
    {
	if ( strlen($_POST["label"]) && ( $_POST["usertype"]=='reseller' || $_POST["usertype"]=='user' ) )
	    return NULL;
	return array( "message"=>ltext("cm_wronglabel") );
    }

    function ValidateEdit()
    {
	if ( is_array($_POST["label"]) )
	    foreach ( $_POST["label"] as $ls_ID => $ls_Value )
	    {
		if ( !strlen($ls_Value) )
		    return array( "message"=>ltext("cm_wronglabel") );
		if ( $_POST["usertype"][$ls_ID]!='reseller' && $_POST["usertype"][$ls_ID]!='user' )
		    return array( "message"=>ltext("cm_wronglabel") );
	    }
	return NULL;
    }

    function ValidateDelete ( &$pa_IDs )
    {
	return NULL;
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
