<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

db_master_connect();

$ServerID = $server_id ? $server_id : $masterServerID;

$loReseller = new SQLString( $anbieter );
$loServerID = new SQLString( $ServerID );

## status des anbieters
$lrId = safe_query2( "SELECT gesperrt FROM anbieter WHERE anbieter = ? AND server_id=?",
										 $loReseller, $loServerID );
list( $gesperrt ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lfId );
## /status des anbieters

## anzahl kunden
$lrId = safe_query2( "SELECT COUNT(anbieter) FROM kunden WHERE anbieter = ? AND server_id=?", 
										 $loReseller, $loServerID );
list( $anzahlkunden ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lfId );
##

$loData = new SetOfRowsData();
$loPage = new MainPageElement();

if( $gesperrt == 0 ){
	$loData->AppendRow( new HTMLDataField( ltext( 'anaesp_text1', array( $anbieter ) ) ),
											new YesNoDataField( array( 'yes' => ltext( 'g_yes' ) ), 
																					array( 'no' => ltext( 'g_no' ) ),
																					'',
																					'sperren',
																					cc_RadioGroupPresentation
																					)
											);
	
	$loData->AppendHidden( new TextDataField( $anbieter,"anbieter" ) );	
	$loData->AppendHidden( new TextDataField( $ServerID,"server_id" ) );	
	$loData->AppendHidden( new TextDataField( $ret_path,"ret_path" ) );	

	$loData->AppendButton( ltext( "anaesp_button1" ), "javascript:doChange()", cc_IDOk );
	$lcTitle = ltext( 'anae_cell_block' ) . ' <strong>'.htmlspecialchars( $anbieter ).'</strong>';
	$loForm  = $loData->GetInputPresentation( array( "action" => "anbieter_aendern_sperren2.php" ),
	     		                                  $lcTitle );
	$loForm->AppendTop( ltext( "anaesp_descr1", array( $anbieter, $anzahlkunden ) ) );
			
	$loPage->AppendToContent( $loForm );
	$loPage->OutputHTML( js_f_call_help('', 'anaesp_title1' ) );	

}elseif( $gesperrt == 1 ){
	$loData->AppendRow( new HTMLDataField( ltext( 'anaesp_text2', array( $anbieter ) ) ),
		                new YesNoDataField( array( 'yes' => ltext( 'g_yes' ) ), 
		                                    array( 'no' => ltext( 'g_no' ) ),
		                                    '',
		                                    'freigeben',
		                                    cc_RadioGroupPresentation 
		                                    ) 
		               );
	
	$loData->AppendHidden( new TextDataField( $anbieter, "anbieter" ) );	
	$loData->AppendHidden( new TextDataField( $ServerID, "server_id" ) );	
	$loData->AppendHidden( new TextDataField( $ret_path, "ret_path" ) );	
	$loData->AppendButton( ltext( "anaesp_button1" ), "javascript:doChange()", cc_IDOk );
	$lcTitle = ltext( 'anae_cell_block' ) . ' <strong>'.htmlspecialchars( $anbieter ).'</strong>';
	$loForm = $loData->GetInputPresentation( array( "action" => "anbieter_aendern_sperren2.php" ),
			                                 $lcTitle );
	$loForm->AppendTop( ltext( "anaesp_descr2", array( $anbieter ) ) );
	$loPage->AppendToContent( $loForm );
	$loPage->OutputHTML( js_f_call_help( '', 'anaesp_title2' ) );	
}
db_close(); 

?>
