<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'class.SQLInteger.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( 'db/class.DBConnect.php' );
include_once( '../include/elements/html/module.Constants.php' );
include_once( 'defines.php');
include_once( '../include/elements/data/class.IconDataField.php' );

global $DEBUG;
//$DEBUG = 1;

if( $DEBUG ){
	echo "db_access.php: POST<br><pre>\n";
	var_dump( $_POST );
	echo "</pre><br>\n";
}

$loMysql =& getMasterMysqlConnect();
$GLOBALS['db_connection_id'] = $loMysql->ConnectionID();

switch( $action ){
  case 'new':
    if( ! istleer( $host ) ){
      $host = strtolower( $host );
        $lcSQL = "GRANT ALL PRIVILEGES ON $dbMasterDB.*".
                " TO '$dbMasterUser'@? ".
    		        " IDENTIFIED BY '$dbMasterPw'";
    		
       	safe_query2( $lcSQL, new SQLString( $host ) );
        safe_query2( "FLUSH PRIVILEGES" );
    }
    $host = '';
		break;
  case 'delete':
    if( istleer( $confirm ) ){
    	$confirm = 0;
    }
    $lcHosts = '';
    if( isset( $hosts ) && is_array( $hosts ) && $liCount = count( $hosts ) ){
      if( ! in_array( '%', $hosts ) || $confirm == 1 ){
    	for( $i = 0; $i < $liCount; $i++ ){
 	      $hosts[$i] = strtolower( $hosts[$i]);
      	safe_query2( "REVOKE ALL PRIVILEGES ON $dbMasterDB.* FROM '$dbMasterUser'@?", 
      	              new SQLString( $hosts[$i] ) );
      	$lcHosts .= ( $i ? ', ': '' ).$hosts[$i];             
    	}
   	  $fehlertext = ltext( 'dba_hosts_deleted', $lcHosts );
   	  safe_query2( "FLUSH PRIVILEGES" );
      }else{
        $loMysql->disconnect();
        include( 'db_access_confirm.php' );
        exit();
      }
    }
  break;
  case 'priv':
      if( $priv == 'all' ){
        $lcSQL = "GRANT ALL PRIVILEGES ON $dbMasterDB.*".
                " TO '$dbMasterUser'@'%' ".
    		        " IDENTIFIED BY '$dbMasterPw'";
       	safe_query2( $lcSQL );
        safe_query2( "FLUSH PRIVILEGES" );
      }elseif( $priv == 'none' ){
       	safe_query2( "REVOKE ALL PRIVILEGES ON $dbMasterDB.* FROM '$dbMasterUser'@'%'" ); 
        $lcSQL = "GRANT SELECT ON $dbMasterDB.*".
                " TO '$dbMasterUser'@'%' ".
    		        " IDENTIFIED BY '$dbMasterPw'";
       	safe_query2( $lcSQL );
        safe_query2( "FLUSH PRIVILEGES" );
      }
  break;
}

$listFormIndex = 0;
//
// Add form
//
$loNewHost = new SetOfRowsData();
$loNewHost->AppendRow( new HTMLDataField( ltext('dba_host')),
                       new HTMLDataField( '&nbsp;'),
										   new TextDataField( $host, 'host' ),
										   new HTMLDataField( '&nbsp;'),
										   new ButtonData( ltext('ll_add'), "javascript:doChange()", cc_IDAdd )
										 );
$loNewHost->AppendHidden( new TextDataField( 'new', 'action' ));

$loAddForm = $loNewHost->GetInputPresentation( array( 'action' => 'db_access.php',
																							  		  'method' => 'post',
																									    'name'   => 'add' )
																						  , ltext( 'dba_add_host' ) );
$listFormIndex++;																						  

//
// List of hosts
//
initPagingSettings( $_POST, array( 'to_search' => $to_search ) );

$lcNoShow = "'$mysqlMasterHost', '$db_host'";
$lcSQL    = "SELECT COUNT( Host ) FROM db WHERE Db = '$dbMasterDB' AND User = '$dbMasterUser' AND Host NOT IN ($lcNoShow)";
$lrId     = db_query( $lcSQL );

list( $total_number ) = db_fetch_array( $lrId );
db_free_query( $lrId );

//Sort settings 
if( ! isset( $direction ) ){
  $direction = 'asc';
}

$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir  =  ( $direction =='desc' ) ? 'asc' : 'desc';

$lcOrder = " ORDER BY Host";

if ( $direction == 'desc' ) {
  $lcOrder .= " DESC";
}

if( isset( $to_search ) && strlen( $to_search ) ){
	$lcSQL .= " AND Host LIKE '%?%'";
	$loQuery = new SQLQuery( $lcSQL, array( new SQLValue( $to_search, 'S' ) ) );
	$loQuery->doQuery();
	
	list( $total_number ) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT Host FROM db WHERE Db = '$dbMasterDB' AND User = '$dbMasterUser' AND Host NOT IN ($lcNoShow)".
	         " AND Host LIKE '%?%'".$lcOrder;
	$loQuery->Query( $lcSQL );
}else{
	$loQuery = new SQLQuery( "SELECT Host FROM db WHERE Db = '$dbMasterDB' AND User = '$dbMasterUser' AND Host NOT IN ($lcNoShow) ".$lcOrder );
}

$loDS       = new ConversedDBValue( $loQuery, $page_size, $start_index-1 );
$loTemplate = new CompoundValue( new ValueFromArray( 'Host' ),
																 new ValueFromArray( 'Host' ) /* select */
																 );
$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('hosts', this.checked, $listFormIndex)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$laContent  = array();
$laContent['host'] = new CompoundDataField( new HTMLDataField( ltext( 'dba_host' )),
																						 new IconDataField( $lcDirIcon ));
$laContent['host']->SetSeparator('');

$loTitle = new CompoundValue( new DataValue( 'host', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','host',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['host']
																																)
																						 ),
															$loSelValue
															);
$laWidths = array('97%', '3%' );

$loDS->Template( $loTemplate );
//
// Call-back functions
//
function makeSelect( $poSrc ){

	$loCheckBox = new CheckDataField( $poSrc, 'hosts[]');
	$loCheckBox->ParentAttribute('align','center');
	
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
	
}

//=====================================================

$loConv = new CompoundValue( NULL,
														 new ValueFormated( 'select', NULL, 'makeSelect' )
														 );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'rest', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex( $listFormIndex );

if( isset( $to_search ) && strlen($to_search ) ){
		$loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
	}else{
		$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
}

$loTbl = $loPTV->GetOutputPresentation( array( 'action' => 'db_access.php#list',
																						 'name' => 'list_rest' ), 
     																			  ltext( 'dba_host_list' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'to_search', $to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_search', 
																																	'size' => '16',
																																	'value' => $to_search,
																																	'MAXLENGTH'=> '16' )
																													 ) 
																		 );
	
$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_search','',$listFormIndex);".
																							 "submitForm('start_index',1,1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('ll_delete');
$lcConfirm = ltext('ll_confirm_delete');
$lcNothing = ltext('ll_nothing');

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('action','delete',$listFormIndex);".
																								"deleteSelected('hosts','$lcConfirm',$listFormIndex,'$lcNothing')",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'mail_to_search' => $mail_to_search ) );

if( ( isset( $to_search ) && strlen( $to_search ) ) || $total_number > 0 ){
	$loTbl->setSearchElement( $loSearch );
}
if( $total_number > 0 ){
	$loTbl->setGroupActionElement( $loGroup );
}

$loTbl->updateBodyContent();

// Change connection! 
$loMysql->disconnect();
db_master_connect();

$page = new MainPageElement( $loAddForm, $loTbl );
$page->OutputHTML( array( '../js/paged_form.js' ), js_f_call_help( '', 'dba_desc1' ) );

?>
