<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( 'auth.php' );

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );

include_once( '../include/elements/data/class.PagedTableView.php' );

include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );

include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

include_once( 'defines.php' );

global $DEBUG;
//$DEBUG = 1;

if($DEBUG){
	echo "einstellungen_httpd_kunde.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

db_master_connect();

$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'einstellungen_httpd_kunde.php',
										 'head_id' => 'httpd_spec_kunde',
										 'head_text' => ltext('eihtku_cell_user'),
										 'menu_node_id' => 'menu_node_httpd_spec_kunde'
										 );
$loPathBar->pushPathBar( $laFirstItem );


initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search,
																	 'server_to_search' => $server_to_search ) );

$lcSQL = "SELECT COUNT(*) FROM kunden";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$loWhereAnd = new SQLFieldSet (new SQLField('k.server_id','a.server_id','U'));

if( isset($server_to_search) && $server_to_search ){
	$loWhereAnd->addField( 'k.server_id', $server_to_search, 'C' );
 }
$lcWhere = $loWhereAnd->getSQLWhere( ' AND ' );


if( isset($name_to_search) && $name_to_search ){
	$loWhereOr = new SQLFieldSet ();
	$loWhereOr->addField( 'k.kunde', '%'.$name_to_search.'%', 'C' );
	$loWhereOr->addField( 's.name', '%'.$name_to_search.'%', 'C' );
																
	$lcWhereOr = $loWhereOr->getSQLWhere( ' OR ' );
	$lcWhere .= " AND ( $lcWhereOr )";

}

$loName = new SQLValue( $name_to_search, 'S' );
$lcSQL = "SELECT COUNT(*) FROM kunden k, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
	" WHERE $lcWhere";

$loQuery = new SQLQuery( $lcSQL );
$loQuery->doQuery();
list($total_number) = $loQuery->fetchArray('N');
$loQuery->finish();

$lcSQL = "SELECT k.kunde, k.httpdspezial, a.confixx_domain, s.name, k.server_id ".
	" FROM kunden k, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
	" WHERE $lcWhere".
	" ORDER BY kunde";
$loQuery->Query( $lcSQL );

$listFormIndex = 0;

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'kunde' ),
																 new CompoundValue( new ValueFromArray( 'confixx_domain' ),
																										new ValueFromArray( 'name' )
																										),
																 new CompoundValue(new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																 new CompoundValue( new ValueFromArray( 'kunde' ),
																										new ValueFromArray( 'httpdspezial' ),
																										new ValueFromArray( 'server_id' )
																										),
																 new ValueFromArray( 'httpdspezial' )
																 );

$loTitle = new CompoundValue( new ValueLocale( 'eihtkusu_cell_user' ),
															new ValueLocale( 'eihtkusu_cell_server' ),
															new ValueLocale( 'eihtkusu_cell_domains' ),
															new ValueLocale( 'll_change' ),
															new ValueLocale( 'me_httpd' )
															);

$laWidths = array(  '10%', '25%','20%', '5%', '40%' );

$loDS->Template( $loTemplate );

//===================================================
//
// function to make visible objects

function &makeServerName( &$poSrc ){
	list($lcHostname,$lcName) = $poSrc->listValue();
	$loName = new HTMLDataField($lcHostname." ($lcName)" );
	return $loName;
}

$gcChange = ltext( 'eiht_cell_domain' );
$gcOn = ltext( 'll_on' );
$gcOff = ltext( 'll_off' );

function &makeStatusLink( &$poParams ){
	global $gcChange, $gcOn, $gcOff;
	global $confixx_interface_version;

	list($lcKunde,$lcSpec, $lcServerID) = $poParams->listValue();

	if($lcSpec){
		$loCnt = new IconDataField( cc_OnDNSIcon );
	} else {
		$loCnt = new IconDataField( cc_OffDNSIcon );
	}
	

	$loLink = new LinkDataField( 'einstellungen_httpd_kunde_aendern.php',
															 '',
															 array('kunde' => $lcKunde,
																		 'server_id'=> $lcServerID ),
															 $loCnt
															 );
	$loLink->Attribute( 'title', $gcChange );
	$loLink->ParentAttribute( 'align', 'center' );

	return $loLink;
}

function &makeSpecialView( $pcSpecial ){
	if($pcSpecial){
		$laLines = explode( "\n", $pcSpecial );
		if(count($laLines) > 2){
			array_splice($laLines,2);
			array_push($laLines,'...');
		}
		$loSpec = new CompoundDataField();
		$loSpec->SetSeparator("<br>\n");
		foreach($laLines as $lcLine){
			$loSpec->AppendToContent( new HTMLDataField( $lcLine ) );
		}
		return $loSpec;
	} else {
		return new HTMLDataField('');
	}
}

$goDomains = new SQLQuery("SELECT domain FROM domains WHERE kunde=? AND server_id=? ORDER BY domain");

function &makeDomainList( &$poSrc ){
	global $goDomains;
	list($lcKunde,$lcServerID) = $poSrc->listValue();
	$laList = array();

	$goDomains->doQuery( array( new SQLValue($lcKunde,'C'),
															new SQLValue($lcServerID,'C') ) );

	while( list($lcDomain) = $goDomains->fetchArray() ){
		$laList[] = $lcDomain;
	}
	$goDomains->freeResult();
	$loList = new HTMLDataField( join(', ',$laList) );
	return $loList;
}
//
// end function to make visible objects
//==================================================

$loDS->Conversion( new CompoundValue( NULL, /* user */
																			new ValueFormated( 'server', NULL, 'makeServerName' ),
																			new ValueFormated( 'domains', NULL, 'makeDomainList' ),
																			new ValueFormated( 'change', NULL, 'makeStatusLink' ),
																			new ValueFormated( 'special', NULL, 'makeSpecialView' )
																			)
									 );

$loDS->doQuery();


$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );

$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex(0);

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'einstellungen_httpd_kunde.php#list',
																						 'name' => 'list_res' ), 
																			ltext( 'eiht_cell_user' ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ) );

$dsSearch->addValue( new ValueLocale( 'alse_cell_server' ));

$dsServers = new CompoundDBValue( "SELECT a.server_id, s.name, a.hostname ".
																	" FROM admin a LEFT JOIN server s ON s.server_id=a.server_id WHERE a.server_id != '$masterServerID' ".
																	" ORDER BY s.name, a.hostname");
$dsServers->doQuery();

$loIter =& $dsServers->getFirstIterator();

$loServerSelect = new CompoundValue();
while( $loItem =& $loIter->getNext() ){
	
	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();
	
	$lcPrompt = $lcHostname;
	$loServerSelect->addValue( new KeyValue( 'server_to_search', $lcServerID ),
														 new KeyValue( 'name', $lcPrompt )
														 );
 }

$loServerSelect->addValue( new KeyValue( 'server_to_search', '' ),
													 new ValueLocale('ll_all' ) );
														 
$dsSearch->addValue( $loServerSelect );
$dsSearch->addValue( new ValueLocale( 'll_search' ) );
$dsSearch->addValue( new ValueLocale( 'll_show_all' ) );


$loSearch = new SimpleSearchElement( array(),
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $ip_to_search,
																																	'MAXLENGTH'=> '64' )
																													 ) ,
																		 new HTMLElement( '' ), // prompt
																		 new SelectElement(array( 'name' => 'server_to_search' )), 
																		 new PPButtonElement( '',
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													),
																		 new PPButtonElement( '',
																													"javascript:setValue('name_to_search','',$listFormIndex);".
																													"javascript:setValue('server_to_search','',$listFormIndex);".
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													)
																		 );
$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search,
																						'server_to_search' => $server_to_search) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();
	
$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

?>
