<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );/*{{{*/
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/class.HOPermissions.php' );
/*}}}*/

db_connect();

$DEBUG = 0;

$laData = array();
$lbChangeAction = ! empty( $httpd_id );
$listFormIndex = 0;

if( ! empty( $action ) ){/*{{{*/
  switch( $action ){
  case 'save':
    // Checks for empty fields  
    if( istleer( $label ) ){
      $fehlertext = ltext( 'form_empty_required_fields' );
      break;
    }

    if( empty( $new_state_label ) ){
      $new_state_label = array();
      $new_state_data  = array();
    }
      
    foreach( $new_state_label as $tmp ){
        if( istleer( $tmp ) ){
          $fehlertext = ltext( 'form_empty_required_fields' );
          break 2;
       }
     }

     /**
      * Update
      */
    if( $lbChangeAction ){
      $laBad = array();
      $laDelete = array();

      if( empty( $state_label ) ){
        $state_label = array();
        $state_data  = array();
      }

      // Checks for empty fields  
      foreach( $state_label as $tmp ){
          if( istleer( $tmp ) ){
            $fehlertext = ltext( 'form_empty_required_fields' );
            break 2;
         }
       }

      foreach( $state_ids as $liStateId ){
        if( ! array_key_exists( $liStateId, $state_label ) ){
          $lrId = safe_query2( " SELECT COUNT(*) FROM httpd_entries ".
                               " WHERE state = ? AND server_id='$ServerID'",
                               new SQLInteger( $liStateId ) );
          list( $liCount ) = db_fetch_array( $lrId, 'N');
          db_free_query( $lrId );
          if( $liCount ){
            $laBad[] = $liStateId;
          }else{
            $laDelete[] = $liStateId;
          }
        }
      }
      if( count( $laBad ) ){
        $fehlertext = ltext('httpd_options_delete_error1', implode( ', ', $laBad ) );
        break;
      }
      safe_query2( "UPDATE httpd_definitions SET  label = ? 
                      WHERE id = ?", 
                     new SQLString( $label),
                     new SQLInteger( $httpd_id )
                   );
          
       foreach( $state_ids as $liStateId ){
          safe_query2( "UPDATE httpd_states SET  label = ?, data = ? 
                        WHERE id = ?", 
                       new SQLString( $state_label[$liStateId] ),
                       new SQLString( $state_data[$liStateId] ),
                       new SQLInteger( $liStateId )
                     );
       }
      
      foreach( $laDelete as $liStateId ){
          safe_query2( "DELETE FROM httpd_states WHERE id = ?", 
                        new SQLInteger( $liStateId ) );
       }

      foreach( $new_state_label as $liStateId => $lcStateLabel ){
         safe_query2( "INSERT INTO httpd_states SET httpd_id = ?,  label = ? , data = ?", 
                      new SQLInteger( $httpd_id ), new SQLString( $lcStateLabel ), 
                      new SQLString( $new_state_data[$liStateId] ) );
      }

		  safe_query2( "UPDATE kunden SET httpd=1");
      safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0" );

      }else{
        /**
         * New item
         */
        $lrId = safe_query2( "INSERT INTO httpd_definitions SET  label = ?", 
                      new SQLString( $label ) );
        $liHttpdId = db_insert_id( $lrId );
        foreach( $new_state_label as $liStateId => $lcStateLabel ){
          safe_query2( "INSERT INTO httpd_states SET httpd_id = ?,  label = ? , data = ?", 
                        new SQLInteger( $liHttpdId ), 
                        new SQLString( $lcStateLabel ), 
                        new SQLString( $new_state_data[$liStateId] ) );
        }
         /**
          * Httpd options
          */
         $loHttpdOptions = new HOPermissions( );
         $lrId = safe_query2( "SELECT server_id FROM anbieter WHERE anbieter='res0' AND server_id <> '$masterServerID'" );
         while( $laRow = db_fetch_array($lrId, 'A')){
           $loHttpdOptions->ServerID( $laRow['server_id'] );
           $loHttpdOptions->saveForReseller( 'res0', array( $liHttpdId => 1 ) ); 
         }
         db_free_query( $lrId );
      }
      $fehlertext = ltext('pi_datasaved');
    case 'cancel':
  default:
    include 'httpd_options.php';
    exit;
  }
}/*}}}*/

$laData['states'] = array();

if( $lbChangeAction ){
  $lrId = safe_query2( "SELECT s.label, s.data, s.id, d.label AS option_label FROM httpd_definitions d
                        LEFT JOIN httpd_states s ON d.id = s.httpd_id 
                        WHERE d.id = ? ORDER BY s.id",  new SQLInteger( $httpd_id ) );
  $i = 0;

  while( $laRow = db_fetch_array( $lrId, 'A' ) ){
    if( $i == 0 ){
      $laData['id'] = $httpd_id;
      $laData['label'] = $laRow['option_label'];
      $i++;
    }
    $laData['states'][$laRow['id']] = array( 'label' => $laRow['label'], 'data' => $laRow['data'] );
  }
	db_free_query( $lrId );
}elseif( $label ){
  $laData['label'] = $label;
}

$loData = new SetOfRowsData();
$loData->AppendRow( new HTMLDataField( ltext("httpd_option_desc"), 
                                       false, array(), array('colspan' => 2 ) ) );

$loData->AppendRow( new HTMLDataField( "<sup class=required>*</sup> - ".ltext("fp_required_fields"), 
                                        false, array(), array('colspan' => 2 ) ) );

$loData->AppendRow( new HTMLDataField( ltext('httpd_option_label').'<sup class=required>*</sup>'), 
                  	new TextDataField( $laData['label'] , 'label' ) );


foreach( $laData['states'] as $liStateId => $laState ){
  $loData->AppendRow( new HTMLDataField( ltext('httpd_option_state_label').'<sup class=required>*</sup>' ), 
                      new TextDataField( $laState['label'] , "state_label[$liStateId]", true, array( 'id' => 'state_label' ) ) );

  $loData->AppendRow( new HTMLDataField( ltext('httpd_option_state_data')), 
                      new LongTextDataField( $laState['data'], "state_data[$liStateId]", array( 'id' => 'state_data' ) ) );
  
  $loData->AppendHidden( new TextDataField( $liStateId, 'state_ids[]' ) );
}


if( empty( $laData['states'] ) || ! empty( $new_state_label ) ){
  if( empty( $new_state_label ) ){
    $new_state_label = array( '' );
    $new_state_data  = array( '' );
  }
  foreach($new_state_label as $id => $value ){
    $loData->AppendRow( new HTMLDataField( ltext('httpd_option_state_label').'<sup class=required>*</sup>' ), 
                        new TextDataField( $value , "new_state_label[]", true, array( 'id' => 'state_label' ) ) );

    $loData->AppendRow( new HTMLDataField( ltext('httpd_option_state_data')), 
                        new LongTextDataField( $new_state_data[$id], "new_state_data[]" , array( 'id' => 'state_data' ) ) );
  }
}

if( $lbChangeAction ){
  $loData->AppendHidden( new TextDataField( $httpd_id, 'httpd_id' ) );
}

$loLinkBlock = new CompoundDataField(  new LinkDataField( "javascript:dropArea();",
                                                          "",
	                                                        array( ),
                                                          ltext('delete_area') ) ,
                                         new LinkDataField( "javascript:addArea();",
                                                           "",
	                                                        array( ),
                                                          ltext('add_area') )             
                                                        );
$loLinkBlock->SetSeparator(" / ");
$loLinkBlock->AppendParentAttributes(array("colspan"=>2, 'align' => 'right'));
$loData->AppendRow($loLinkBlock);

$loData->AppendHidden( new TextDataField( 'save', 'action' ) );

$loData->AppendButton( ltext( 'll_save' ), "javascript:doChange()", 
                     cc_IDOk );

$loData->AppendButton( ltext( 'll_cancel' ),
        							 "javascript:submitForm('action', 'cancel', $listFormIndex)", cc_IDCancel );


$loForm = $loData->GetInputPresentation( array( 'action'=>'httpd_options_change.php',
																						'method'=>'post' ),
																		$lbChangeAction 
                                    ? ltext('httpd_options_change') 
                                    : ltext('httpd_options_add') 
                                   );
$loForm->SetWidths('20%','80%');

$loPage = new MainPageElement( $loForm );


$JSscriptPart  = <<<EOF

function dropArea(){
        if(document.getElementById) {
               var mainTable = document.getElementById('state_data');

               while (mainTable.tagName != 'TABLE') mainTable = mainTable.parentNode;

               thisChilds = mainTable.getElementsByTagName('TR');
               if(thisChilds.length > 5){
                 var lastTr = thisChilds[thisChilds.length - 2];
                 var lastTr2 = thisChilds[thisChilds.length - 3];
                 lastTr.parentNode.removeChild(lastTr);
                 lastTr2.parentNode.removeChild(lastTr2);  
              }           
        }
}
function addArea(){
    if(document.getElementById) {
                var stateLabelTr  = document.getElementById('state_label');          
                var stateDataTr   = document.getElementById('state_data');
                var mainTable     = document.getElementById('state_data');

                while (stateLabelTr.tagName != 'TR') stateLabelTr = stateLabelTr.parentNode;
                while (stateDataTr.tagName != 'TR') stateDataTr = stateDataTr.parentNode;
                while (mainTable.tagName != 'TABLE') mainTable = mainTable.parentNode;
                
                var idSuffix = Math.round(Math.random()*1000);

                thisChilds = mainTable.getElementsByTagName('TR');
                var lastTr = thisChilds[thisChilds.length - 2];
 
                var stateLabelTrClone  = stateLabelTr.cloneNode(true);          
                thisChilds = stateLabelTrClone.getElementsByTagName('INPUT');
                for (var i = 0; i < thisChilds.length; i++){
                       thisChilds[i].value ='';
                       thisChilds[i].name ='new_state_label[]';
                        
                }
          
               var stateDataTrClone   = stateDataTr.cloneNode(true);
               thisChilds = stateDataTrClone.getElementsByTagName('TEXTAREA');
                for (var i = 0; i < thisChilds.length; i++){
                       thisChilds[i].value ='';
                       thisChilds[i].name ='new_state_data[]';
                        
                }
       
                var newTr2 = stateLabelTr.parentNode.insertBefore(stateDataTrClone ,lastTr.nextSibling);
                var newTr  = stateLabelTr.parentNode.insertBefore(stateLabelTrClone,lastTr.nextSibling);
        }
}

EOF;

$loPage->OutputHTML( array( '../../js/paged_form.js' ), $JSscriptPart );

db_close();

?>
