<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );
include_once( "defines.php" );
include_once( "../include/class.SQLString.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/data_source/class.DataValue.php" );
include_once( "../include/elements/html/class.SimpleSearchElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/class.ButtonElement.php" );
include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( '../include/class.PathBar.php' );

db_master_connect();

global $DEBUG;
//$DEBUG = 1;

$id = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE frontpage = 1" );
list( $total_number ) = db_fetch_array( $id );
db_free_query( $id );

if( ! $total_number ){
	$fehlertext = ltext( "kufr_nouser" );
	db_close();

	$url = "kunden_start.php?error_text=kufr_nouser";
	header("Location: $url");
	newLocation( $url );

	$page = new MainPageElement(  );
	$page->AppendToHelp( array( 'kufr_descr1', 'kufr_descr2' ) );
	$page->OutputHTML();

	exit();
}

	$loPathBar   = new PathBar();
	$laFirstItem = array( 'main_menu_page' => 'kunden_frontpage_list.php',
											  'head_id' => 'frontpage',
											  'head_text' => ltext( 'mk_frontpage' ),
											  'menu_node_id' => 'menu_node_frontpage'
											 );
	$loPathBar->pushPathBar( $laFirstItem );

initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search ) );

//Sort settings 
$listFormIndex = 0;
if( !isset( $direction ) ){
  $direction = 'asc';
}
$lcDirIcon = $direction =='desc' ? cc_DescIcon : cc_AscIcon;
$lcNewDir  = $direction =='desc' ? 'asc' : 'desc';

if( !isset( $order ) ){
	$order = 'user';
}

$lcOrder = '';
$laOrders = array( 'user'     => 'k.number',
                   'status'   => 'status',
                   'name'     => 'k.firstname',
                   'reseller' => 'reseller_number',
                   'server'   => 'server'
                 );
                 
if( array_key_exists( $order, $laOrders ) ){
  $lcOrder .= " ORDER BY ".$laOrders[$order];
}else{
  $lcOrder .= " ORDER BY k.number";
}  

$lcOrder .=  $direction == 'desc' ? " DESC" : "";

if( isset($name_to_search ) && strlen( $name_to_search ) ){
	$loName = new SQLValue( $name_to_search, 'S' );
	$lcSQL = "SELECT COUNT(k.kunde) FROM kunden k".
      		 " LEFT JOIN admin a ON k.server_id=a.server_id".
      		 " LEFT JOIN server s ON k.server_id=s.server_id".
	         " WHERE ( k.kunde LIKE '%?%' OR k.name LIKE '%?%' OR k.anbieter LIKE '%?%' ".
	         " OR s.name LIKE '%?%' OR a.confixx_domain LIKE '%?%' )".
	         " AND k.frontpage=1";

	$loQuery = new SQLQuery( $lcSQL, array( $loName, $loName, $loName, $loName , $loName ) );
	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT MIN(k.kunde) as kunde, MIN(k.name) as name,MIN(k.firstname) AS firstname, ".
	         " (f.neu*2+f.loeschen) as status, k.anbieter, SUBSTRING(k.anbieter, 4) AS reseller_number, ".
	         " s.name as server, s.server_id FROM kunden k".
      		 " LEFT JOIN frontpage f ON k.kunde = f.kunde AND k.server_id=f.server_id".
      		 " LEFT JOIN admin a ON k.server_id=a.server_id".
       		 " LEFT JOIN server s ON k.server_id=s.server_id".
      		 " WHERE ( k.kunde LIKE '%?%' OR k.name LIKE '%?%' OR k.anbieter LIKE '%?%' ".
	         " OR s.name LIKE '%?%' OR a.confixx_domain LIKE '%?%' )".
      		 " AND k.frontpage=1 GROUP BY k.number, k.server_id".$lcOrder;

	$loQuery->Query( $lcSQL );

 } else {

	$lcSQL = "SELECT MIN(k.kunde) as kunde, MIN(k.name) as name,MIN(k.firstname)".
	         " AS firstname,(f.neu*2+f.loeschen) as status, s.server_id, s.name as server, ".
	         " k.anbieter, SUBSTRING(k.anbieter, 4) AS reseller_number ".
	         " FROM kunden k LEFT JOIN frontpage f  ON k.kunde = f.kunde AND f.server_id=k.server_id".
      		 " LEFT JOIN admin a ON k.server_id=a.server_id".
      		 " LEFT JOIN server s ON k.server_id=s.server_id".
      		 " WHERE k.frontpage=1 GROUP BY k.number, k.server_id".$lcOrder;
	$loQuery = new SQLQuery( $lcSQL );

 }
$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );


$loTemplate = new CompoundValue(	new CompoundValue( 
                                 new ValueFromArray( 'status' ),
											           new ValueFromArray( 'kunde' ),
											           new ValueFromArray( 'server_id' ),
											           new ValueFromArray( 'anbieter' )
											           ),
									new ValueFromArray( 'kunde' ),
								  new CompoundValue( new ValueFromArray( 'firstname' ),
											           new ValueFromArray( 'name' )
											           ),
                  new CompoundValue( new ValueFromArray( 'kunde' ),
									                  new ValueFromArray( 'server_id' )
									                  ),
            									new ValueFromArray( 'anbieter' ),
									new ValueFromArray( 'server' )
								);

$laContent = array();

$laHeaders = array( 'status'  => array( 'name' => 'kuss_cell_status',    'sort' => 1 ), 
                    'user'    => array( 'name' => 'kufr_cell_user',      'sort' => 1 ),
                    'name'    => array( 'name' => 'kufr_cell_name',      'sort' => 1 ),
                    'domains' => array( 'name' => 'kuaeku_cell_domains', 'sort' => 0 ),
                    'reseller'=> array( 'name' => 'kufr_cell_reseller',  'sort' => 1 ),
                    'server'  => array( 'name' => 'kust_server',         'sort' => 1 )
                  );
                  
foreach( $laHeaders as $lcKey => $laValue ){
  if( $laValue['sort'] ){
    if( $order == $lcKey ){
    	$loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ),
			       														 new IconDataField( $lcDirIcon ) );
	    $loContent->SetSeparator( '' );
    }else{
	    $loContent = new HTMlDataField( ltext( $laValue['name'] ) );
    }
    $laContent[] = new DataValue( $lcKey, NULL, 
																	new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);".
																											"setValue('start_index',1,$listFormIndex);".
																											"submitForm('direction','$lcNewDir',$listFormIndex)",
																											'',
																											array(),
																											$loContent
																										) 
														     );
  }else{
    $laContent[] = new ValueLocale( $laValue['name'] );
  }
}

 
$loTitle = new CompoundValue( $laContent );

$laWidths = array( '5%', '15%', '20%', '30%', '10%', '20%' );

$loDS->Template( $loTemplate );

//=====================================================================
//
// call back functions to make visible objects

$gcOn = ltext("ll_on");
$gcOnOn = ltext("ll_process_on");
$gcOnOff = ltext("ll_process_off");
$gcOff = ltext("ll_off");

function &createStatusLink( $poSrc ){

	global $gcHeadText, $confixx_interface_version, $gcOn, $gcOnOn, $gcOnOff, $gcOff;
	global $gcUserSeparator;
	$lcIconText = "";
	$loNeu =& $poSrc->Value(0);
	$liNeu = $loNeu->Value();
	$loValue =& $poSrc->Value(1);
	$loServer =& $poSrc->Value(2);
	$loReseller =& $poSrc->Value(3);
	$lcUrlUser = urlencode( $loValue->Value());
	$lcQuery  = "kunde=$lcUrlUser&anbieter=".$loReseller->Value()."&server_id=".$loServer->Value();
if (isset($liNeu)) {
	
	if ($liNeu == 0) {
		$lcIcon = cc_OnIcon;
		$lcTitle = ltext("kufr_fpdeact");
    $lcIconText = $gcOn;
	} elseif( $liNeu == 2) { 
		$lcIcon = cc_StateNewIcon;
		$lcTitle = ltext("kufr_fpdeact");
    $lcIconText = $gcOnOn;
	} elseif ($liNeu == 1) {
		$lcIcon = cc_StateDeleteIcon;
		$lcTitle = ltext("kufr_fpact");
    $lcIconText = $gcOnOff;
	}
} else {
	$lcIcon = cc_OffIcon;
	$lcTitle = ltext("kufr_fpact");
  $lcIconText = $gcOff;

}
	$loLink = new LinkDataField( 'kunden_frontpage_upd.php', 
															 $lcQuery, 
															 array(), 
															 ($confixx_interface_version == 'powp')?
                                new IconDataField( $lcIcon ) : $lcIconText );
															 
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'center' ) );
		
	return $loLink;
}
function &createName($poSrc) 
{
	$lo_firstName = & $poSrc->Value(0);
	$lc_firstName = $lo_firstName->Value();
	$lo_lastName  = & $poSrc->Value(1);
	$lc_lastName  = $lo_lastName->Value();

	return new HTMLDataField($lc_firstName.' '. $lc_lastName);
}

$goDomains = new CompoundDBValue( " SELECT domain, richtigedomain ".
                                  " FROM domains WHERE kunde=? AND richtigedomain IN (1,7,3) ".
                                  " AND server_id=? ORDER BY domain" );

function &createDomainList( $poSrc ){
  
  global $goDomains;	

  $loKunde  =& $poSrc->Value(0);
	$lcKunde  = $loKunde->Value();
	$loServer =& $poSrc->Value(1);
	$lcServer = $loServer->Value();
	
	$goDomains->doQuery( array( new SQLValue( $lcKunde,'C' ), new SQLValue( $lcServer,'C' ) ) );
	
	$loColumn =& $goDomains->getColumn(0);
  $loDomainType =& $goDomains->getColumn(1);

	if ( $loColumn->getCount() > 3 ) {
		$loColumn->keepLeft( 3 );
		$loColumn->addValue( new KeyValue( 'domain', '...' ) );
	}

 	$loList = new CompoundDataField();
	$loIter =& $loColumn->getFirstIterator();
  $loIterType =& $loDomainType->getFirstIterator();

  while( $loItem =& $loIter->getNext() && $loItemType =& $loIterType->getNext()){
		$lcDomain = $loItem->Value();
		$liDomainType = $loItemType->Value();
    
    if( $lcDomain == '...' || $liDomainType == 7 ){
			$loList->AppendToContent( new HTMLDataField('<i>'.$lcDomain.'</i>' ) );
		}else{
			/* possibly need to create object before cycle and unset after and of cycle ? */
			$loLinkTmp = new LinkDataField( 'http://'.$lcDomain, '', array(), $lcDomain );
			$loLinkTmp->Attribute( 'target', '_blank');
			$loList->AppendToContent( $loLinkTmp );
		}
	}
	$loList->SetSeparator( ', ' );


  return $loList;
}

// end call back functions
//
//============================================================

$loDS->Conversion( new CompoundValue(	new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			NULL,
									   new ValueFormated( 'name', NULL, 'createName' ),
									   new ValueFormated( 'domains', NULL, 'createDomainList' ),
									   null,
									   null
									   
																			)
									 );
																										
$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if (isset($name_to_search)&&strlen($name_to_search)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_frontpage_list.php#list',
																						 'name' => 'list_fp' ), 
																			ltext( 'kufr_cell_title1' ) 
																			);


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $name_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name_to_search','',$listFormIndex);submitForm('start_index',1,$listFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search ) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();
	
$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

/* -------------------- end HTML -------------------- */
?>
