<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

include_once( '../include/class.PathBar.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "server_add2.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
 }


$loPathBar = new PathBar();
$loPathBar->cloneTop( array( 'cur_page' => 'server_add2.php',
														 'path_text' => ltext('srv_add_confirm') 
														 ) 
											);
if( $target == 'next' ){
	$loPathBar->saveRequest( 'server_add.php' );
 }
$lcDbServer = ($mysqlMasterServer == 'localhost' || 
               $mysqlMasterServer == '127.0.0.1')? $hostname: $mysqlMasterServer;
$chunks = array( '../cgi-bin/soap/check_connect.pl',
								 "-h=$local_host",
								 "-l=$local_admin",
								 "-p=\"$local_paswd\"",
								 "-dbs=$lcDbServer",
								 "-dbn=$dbMasterDB",
								 "-dbu=$dbMasterUser",
								 "-dbp=$dbMasterPw",
								 "--no-logout" );
if( $DEBUG ){
	$chunks[] = "-dbg";
 }
if( $session_id ){
	$chunks[] = "-sid=$session_id";
 }
$chunks[] =  '2>&1';
								 
$cmd = join(' ',$chunks);

if( $DEBUG ){
	echo "run: $cmd<br>\n"; 
 }

$fh = popen( $cmd, 'r' );
$error = array();
while( ! feof( $fh ) ){
	$line = fgets( $fh, 1024 );

	if( $DEBUG ){
		echo "$line<br>\n";
	}
	list($key,$value) = split(':',$line,2);
	$key = trim($key);
	$value = trim($value);

	if( $key == 'host' ){
		$mysql_local_host = $value;

	}elseif( $key == 'session_id'){
		$session_id = $value;

	} elseif( $key == 'server_id' ){
		$server_id = $value;

	} elseif( $key == 'time-diff' ){
		$time_diff = $value;

	}elseif( strpos( $key, 'error-' ) === 0 ){
		$error[$key] = $value;
	}
 }
pclose( $fh );

if( count( $error ) || ! $mysql_local_host || ! $session_id || ! $server_id ){

	$lcErrCode = preg_replace( '/^soap:/', '', $error['error-code'] );

	if( $lcErrCode == 'MySQL.Info' ){
		$fehlertext = ltext( 'srv_add_info_error', 
												 array( $local_host,
																$error['error-string']
																)
												 );

	}else{
		$message = $lcErrCode? ltext( $lcErrCode ).$error['error-string']: $error['error-string'];

		$fehlertext = ltext( 'srv_add_conn_error', 
												 array( $local_host,
																$message
																) 
												 );
	}
	$target = 'back';
	include( 'server_add.php' );
	exit;
 }

db_master_connect();

if( abs( $time_diff ) > 15*60 ){
	$fehlertext = ltext('srv_add_diff_time', array( $local_host, 15 ) );
 }

$id = safe_query( "SELECT confixx_domain FROM admin WHERE server_id=?", 
									new SQLString( $server_id ) );
if( db_num_rows( $id )){
	list($local_hostname) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
	if( $fehlertext ){
		$fehlertext .= '<br>';
	}
	$fehlertext .=	ltext( 'srv_add_sid_error', array($local_hostname,$server_id) );

	include('server_add.php');
	exit;
 }
db_free_query( $id );

$data = new SetOfRowsData();

$id = db_query( "SELECT name,descr FROM server WHERE server_id='$server_id'" );
list( $lcName, $lcDescr ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

list($lcName,$lcDomain) = explode( '.', $local_host, 2);

$data->AppendRow( new HTMLDataField( ltext('srv_add_name')),
									new TextDataField( $lcName, 'server_name')
									);

$data->AppendRow( new HTMLDataField( ltext('srv_add_descr')),
									new LongTextDataField( $lcDescr, 'server_descr')
									);


if( TRUE ){ /* to make */
	$data->AppendHidden( new TextDataField( '0', 'move_users' ) );	
	$data->AppendHidden( new TextDataField( '1', 'go' ) );	

}else{
$data->AppendRow( new HTMLDataField( ltext('srv_add_confirm')),
									new YesNoDataField( array( 1 => ltext( 'g_yes' ) ),
																			array( 0 => ltext( 'g_no' ) ),
																			0,
																			'go',
																			cc_RadioGroupPresentation
																			)
									);

$data->AppendRow( new HTMLDataField( ltext('srv_add_move_users')),
									new YesNoDataField( array( 1 => ltext( 'g_yes' ) ),
																			array( 0 => ltext( 'g_no' ) ),
																			0,
																			'move_users',
																			cc_RadioGroupPresentation
																			)
									);
}

$data->AppendHidden(new TextDataField( 'next', 'target' ) );
$data->AppendHidden(new TextDataField( $session_id, 'session_id' ) );
$data->AppendHidden(new TextDataField( $mysql_local_host, 'mysql_local_host' ) );
$data->AppendHidden(new TextDataField( $local_host, 'local_host' ) );
$data->AppendHidden(new TextDataField( $local_admin, 'local_admin' ) );
$data->AppendHidden(new TextDataField( $local_paswd, 'local_paswd' ) );


$data->AppendButton( ltext('ll_next_2'), 'javascript: doChange()', cc_IDNExt);

$page = new MainPageElement( 
			$data->GetInputPresentation( array( 'method' => 'post',
																					'action' => 'server_add3.php'),
																	 ltext( 'srv_add_start', array($local_host) )
																	 )
			);

$page->OutputHTML();

?>
