<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.ToolsButtons.php' );
include_once( '../include/elements/data/class.ToolsButtonData.php' );
include_once( '../include/elements/data/class.GenericButtonData.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.ButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include("../languages/".$shortlang."/scripts.inc.php");

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "server_list:<br>\n";
 }

db_master_connect();

switch( $action ){
 case 'disconnect':
	 include('server_edit_disconnect.php');
	 exit;
 case 'login':
	 include('server_login.php');
	 exit;
 }


$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'server_list.php',
										 'head_id' => 'overview',
										 'head_text' => ltext('m_overview'),
										 'menu_node_id' => 'menu_node_server_overview'
										 );
$loPathBar->pushPathBar( $laFirstItem );


$gcHeadText = htmlspecialchars( ltext( 'man_editserver' ) );


$gaActions = array( 'personendaten' => array( cc_PersonalIcon, ltext( 'seed_cell_person' )),
										'interval' => array( cc_IntervalIcon, ltext('me_interval')),
										'ips' => array( cc_IPsIcon, ltext( 'seed_cell_ip')),
										'passwort' => array( cc_PasswordIcon, ltext( 'seed_cell_password' )),
										'name' => array( cc_DescriptionIcon, ltext( 'seed_cell_description')),
										'stddomain' => array( cc_StdDomainIcon, ltext( 'eisd_title')),
										'dnstemplate' => array( cc_DnsTemplateIcon, ltext( 'me_dnstemplate' ) ),
										'dnsspecial' => array( cc_DnsSpecialIcon, ltext( 'me_dnsspezial' ) ),
										'quota' => array( cc_QuotaIcon, ltext( 'me_quota' ) ),
										'ssl' => array( cc_SSLIcon, ltext( 'me_ssl' ) ),
										'db' => array( cc_DbIcon, ltext( 'me_db' ) )
										//,
										//										'mysql' => array( cc_MysqlIcon, ltext( 'man_mysql') ),
										//										'dns' => array( cc_DNSIcon, ltext('anae_cell_dns') )
										);

//====================================================================
//
//  Change a server


$loTextInput = new TextDataField( $server, 'server',array( 'size' => '32' ));

$loFirstRow = new CompoundDataField( new HTMLDataField( ltext('seed_cell_server') ) ,
																		 $loTextInput );
$loFirstRow->SetSeparator(' ');

$loServTools = new ToolsButtons( $loFirstRow );

$loButtons = new CompoundDataField();
foreach( $gaActions as $lcKey => $laAttr ){
	$lcID = 'change_'.$lcKey; 
	$loButtons->AppendToContent( new GenericButtonData( '',
																											$lcID, 
																											$laAttr[1], 
																											"javascript:setValue('action','$lcKey');submitForm('menu_node_id','$lcKey')",
																											$lcID
																											)
															 );
}
$loButtons->SetSeparator(' ');
$loServTools->AppendToContent($loButtons);
$loServTools->SetSeparator( '<br>' );
$loServTools->Anchor('change');
$loServTools->Legend(ltext('seed_title1'));
$loServTools->Hiddens( array( 'action' => '', 
															'menu_node_id' => '',
															'cur_page' => 'server_edit.php',
															'head_text' => $gcHeadText,
															'server_id' => '',
															'ret_path' => 'server_list.php'
														 ) 
											);

$loServEdit = $loServTools->GetInputPresentation( array( 'action' => 'server_edit.php',
																												 'name' => 'change_server'));


$loA2 = new ButtonElement(ltext("ll_back"), "javascript:displayDiv('tls_main',1);".
													 "displayDiv('paging',1);displayDiv('back',0)", cc_IDBack  ); 

$loBackLink = new DivElement ( array('name'=>'back',
																		 'id'=>'back',
																		 'style' => 'display:none'),
															 $loA2
															 );

//
//
//===================================================================
//
//
// List of servers

$listFormIndex = 1;

initPagingSettings( $_POST, array( 'name' => $name ) );

$lcSQL = "SELECT COUNT(*) FROM admin WHERE server_id != '$masterServerID'";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );
 
//Sort settings 
if (!isset($direction)) $direction = 'asc';
if (!isset($order)) $order = 'hostname';
$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

switch ( $order ) {
 case 'hostname':
	 $lcOrder = "  ORDER BY a.hostname";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'name':
	 $lcOrder = " ORDER BY s.name";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'status':
	 $lcOrder  = " ORDER BY s.status";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'users':
	 $lcOrder  = " ORDER BY users";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 }

$lcFields = "MIN(s.status) AS status, MIN(a.confixx_domain) AS hostname, ".
	" MIN(s.name) AS name, a.server_id, MIN(s.descr) AS descr, ".
	" COUNT(k.kunde) AS users, MIN(a.login) as login, MIN(r.hinweis) AS hinweis, MIN(r.ablauf) AS ablauf";

// Search
if( isset( $name ) && strlen( $name ) ){
	$loName = new SQLValue( $name, 'S' );
	$lcSQL = "SELECT COUNT(*) FROM admin a, server s WHERE a.server_id=s.server_id ".
		" AND a.server_id != '$masterServerID' AND ( a.hostname LIKE '%?%' OR s.name LIKE '%?%')";
	$loQuery = new SQLQuery( $lcSQL, array( $loName, $loName ) );
	
	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');
	
	$lcSQL = "SELECT $lcFields FROM admin a ".
		" LEFT JOIN server s ON a.server_id=s.server_id ".
		" LEFT JOIN kunden k ON k.server_id=a.server_id ".
		" LEFT JOIN register r ON r.server_id=a.server_id AND r.version NOT LIKE '%add%'".
		" WHERE  a.server_id != '$masterServerID' ".
		" AND ( a.hostname LIKE '%?%' OR s.name LIKE '%?%' ) GROUP BY a.server_id ".$lcOrder;
	$loQuery->Query( $lcSQL );
} else {
	$lcSQL = "SELECT $lcFields FROM admin a ".
		" LEFT JOIN server s ON a.server_id=s.server_id ".
		" LEFT JOIN kunden k ON k.server_id=a.server_id ".
		" LEFT JOIN register r ON r.server_id=a.server_id AND r.version NOT LIKE '%add%'".
		" WHERE a.server_id != '$masterServerID' GROUP BY a.server_id ".
	  $lcOrder;
									
	$loQuery = new SQLQuery( $lcSQL );
}

$laContent = array();

if( $order == 'status' ) {
	$laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_status' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'seed_cell_status' ) );
 }

if( $order == 'hostname' ) {
	$laContent['hostname'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_hostname' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['hostname']->SetSeparator('');
 } else {
	$laContent['hostname'] = new HTMlDataField( ltext( 'seed_cell_hostname' ) );
 }

if( $order == 'name' ) {
	$laContent['name'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_name' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['name']->SetSeparator('');
 } else {
	$laContent['name'] = new HTMlDataField( ltext( 'seed_cell_name' ) );
 }

if( $order == 'domains' ) {
	$laContent['domains'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_domains' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['users']->SetSeparator('');
 } else {
	$laContent['users'] = new HTMlDataField( ltext( 'seed_cell_users' ) );
 }
 

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'status' ), 
																										new ValueFromArray( 'server_id')
																										),
																 new CompoundValue( new ValueFromArray( 'name' ),
																										new ValueFromArray( 'descr'),
																										new ValueFromArray( 'server_id'),
																										new ValueFromArray( 'status' ),
																										new ValueFromArray( 'login' )
																										),
																 new CompoundValue( new ValueFromArray( 'hostname' ),
																										new ValueFromArray( 'server_id' ),
																										new ValueFromArray( 'status' ),
																										new ValueFromArray( 'login' )
																										),
															   new CompoundValue( new ValueFromArray( 'login' ),
															                      new ValueFromArray( 'hinweis' ),
															                      new ValueFromArray( 'ablauf' ),
																                    new ValueFromArray( 'server_id' ),
 																										new ValueFromArray( 'status' )
																										),
																 new CompoundValue( new ValueFromArray( 'users' ),
																										new ValueFromArray( 'status' )
																										),
																 new CompoundValue( new ValueFromArray( 'server_id' ),
																										new ValueFromArray( 'name' )
																										),
																 new ValueFromArray( 'server_id' )
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('server', this.checked, 1)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle = new CompoundValue( new DataValue( 'status', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','status',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['status']
																																)
																						 ),
															new DataValue( 'name', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','name',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['name']
																																)
																						 ),
															new DataValue( 'hostname', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','hostname',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['hostname']
																																)
																						 ),
  														new ValueLocale( 'reg_index_status2' ),
															new DataValue( 'users', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','users',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['users']
																																)
																						 ),
															new ValueLocale( 'll_change' ),
															$loSelValue
															);

$laWidths = array( '5%', '20%', '25%','25%', '10%', '10%','5%' );

$loDS->Template( $loTemplate );

function &createStatusLink( &$poSrc ) {
	list( $liStatus, $lcServerID ) = $poSrc->listValue();
	switch( $liStatus ){
	case 1:
		$lcTitle = ltext('seed_status_to_on');
		$lcIcon = cc_StateConnectIcon;
		$loLink = new IconDataField( $lcIcon );
		break;
	case 2:
		$lcTitle = ltext('seed_status_active');		
		$lcIcon = cc_StateActiveIcon;
		$loLink = new LinkDataField( 'server_edit_disconnect.php',
																 '',
																 array( 'action' => 'disconnect',
																			  'server_id' => $lcServerID,
																				'ret_path' => 'server_list.php'
																				),
																 new IconDataField( $lcIcon )
																 );
		break;
	case 3:
		$lcTitle = ltext('seed_status_to_off');
		$lcIcon = cc_StateDisconnectIcon;
		$loLink = new IconDataField( $lcIcon );
		break;
	default:
		$lcTitle = ltext('seed_status_unknown');
		$lcIcon = cc_UnknownIcon;
		$loLink = new IconDataField( $lcIcon );
		break;
		
	}
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->ParentAttribute( 'align', 'center' );
	return $loLink;
}

function &createName( &$poSrc ){

	list( $lcName, $lcDescr, $lcServerID, $liStatus, $lcLogin ) = $poSrc->listValue();

	if( ! $lcName ){
		$lcName = ltext( 'sl_unknown' );
	}

	if( $liStatus == 2 ){
		$loLink = new LinkDataField( 'adminredirect.php',
																 '',
																 array( 'admin' => $lcLogin,
																				'type' => USERTYPE_ADMIN,
																				'server_id' => $lcServerID
																				),
																 new HTMLDataField( $lcName )
																 );
		$loLink->AppendAttributes( array( 'target' => '_blank' ) );
	}else{
		$loLink = new HTMLDataField( $lcName );
	}

	if( strlen( $lcDescr ) > 40){
		$lcDescr = substr( $lcDescr, 0, 39).'...';
	}

	$loLink->AppendAttributes( array( 'title' => $lcDescr ) );

	return $loLink;
}

function &createPanelLink( &$poSrc ){

	global $DEBUG;
	
	list( $lcHostName, $lcServerID, $liStatus, $lcLogin ) = $poSrc->listValue();

	//	if( $DEBUG ){
	//		echo "createPanelLink: hostname: $lcHostName, server_id: $lcServerID<br>\n";
	//	}

	if( $liStatus == 2 ){
		$loLink = new LinkDataField( 'http://'.$lcHostName,
																 '',
																 array( 'login' => $lcLogin	),
																 new HTMLDataField( $lcHostName )
																 );
		$loLink->AppendAttributes( array( 'target' => '_blank',
																			'title' => ltext('seed_goto_server') ) );
	}else{
		$loLink = new HTMLDataField( $lcHostName );
	}
	return $loLink;
}

function &createDomains( &$poSrc ){
	list($lcDomain,$liStatus) = $poSrc->listValue();
	if( ! ( $liStatus == 2 || $liStatus == 3 || $lcDomain ) ){
		$lcDomain = ' ';
	}
	$loCountData = new TextDataField( $lcDomain, 'domains');
	$loCountData->ParentAttribute('align','right');
	return $loCountData;
}

function &createUsers( &$poSrc ){
	list($liUsers,$liStatus) = $poSrc->listValue();
	if( ! ( $liStatus == 2 || $liStatus == 3 || $liUsers ) ){
		$liUsers = ' ';
	}
	$loCountData = new TextDataField( $liUsers, 'users');
	$loCountData->ParentAttribute('align','right');
	return $loCountData;
}

function &createLicenseStatus( &$poSrc ){
  global $lang_format_datetime_long;
  
	list( $lcLogin, $lcHinweis, $lcAblauf, $lcServerID, $liStatus ) = $poSrc->listValue();
	list ( $lizenzzeit, $lcLizenzstatus ) = explode( "::", $lcHinweis );
  
	$lcLicenseStatus = licence_status ( $lcLizenzstatus, date( $lang_format_datetime_long, $lcAblauf ) );
  
  if( $liStatus == 2 ){
    $loLink = new LinkDataField( 'adminredirect.php',
		  													 '',
			   												 array( 'admin'     => $lcLogin,
																		  	'type'      => USERTYPE_ADMIN,
																		  	'path'      => 'reg',
																		  	'server_id' => $lcServerID
																		  ),
																 new HTMLDataField( $lcLicenseStatus )
													  );
    $loLink->AppendAttributes( array( 'target' => '_blank') );													  
  }else{
		$loLink = new HTMLDataField( $lcLicenseStatus );
	}
	return $loLink;
}

function &createAction( &$poSrc ){
	list( $lcServerID, $lcHostname ) = $poSrc->listValue(); 

	$loActions = new LinkDataField( "javascript:setValue('server_id','$lcServerID');".
																	"setValue('server','$lcHostname');".
																	"displayDiv('tls_main',0);".
																	"displayDiv('paging',0);".
																	"displayDiv('back',1);".
																	"void(document.location='#change')", 
																	'', 
																	array(), 
																	new IconDataField( cc_ChangeIcon )
																	);

	$loActions->Attribute( 'title', ltext('ll_change')  );
	$loActions->ParentAttribute( 'align','center');
	
	return $loActions;
}


$loCheckBox = new CheckDataField( '', 'servers[]');
$loCheckBox->ParentAttribute('align','center');
$loSelValue = new DataValue( 'server', $loCheckBox  );
$loSelValue->setTypeOfPresentation( 'Input' );


$loDS->Conversion( new CompoundValue( new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			new ValueFormated( 'name', NULL, 'createName' ),
																			new ValueFormated( 'hostanme', NULL, 'createPanelLink' ),
																			new ValueFormated( 'license', NULL, 'createLicenseStatus' ),
																			new ValueFormated( 'users', NULL, 'createUsers' ),
																			new ValueFormated( 'action', NULL, 'createAction' ),
																			$loSelValue
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
	
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->setParameter( 'ret_path', 'server_list.php' );

$loPTV->Anchor( 'list' );
$loPTV->FormIndex(1);

if (isset( $name ) && strlen( $name )) {
	$loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
 }	else {
	$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
 }

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'server_list.php#list',
																						 'method' => 'post',
																						 'name' => 'list_res' ), 
																			ltext( 'seed_title2' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'name', $name ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name', 
																																	'size' => '32',
																																	'value' => $name,
																																	'MAXLENGTH'=> '64' )
																													 ) 
																		 );


$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,1)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name','',1);submitForm('start_index',1,1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext( 'sl_disconnect' );
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','disconnect_server',1);".
																								"setValue('cur_page','server_edit_disconnect.php',1);".
																								"setValue('head_text','$head_text',1);".
																								"submitForm('action','disconnect',1)",
																								'bid-disconnect' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'name' => $name ) );

if ((isset($name)&&strlen($name))||$total_number>0) {
	$tbl->setSearchElement( $loSearch );
 }
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
 }


$tbl->updateBodyContent();


$page = new MainPageElement($loServEdit, $loBackLink, $tbl ); 

$page->OutputHTML(array( '../js/paged_form.js' ));


?>
