<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( 'auth.php' );
include_once( '../include/cron_functions.php' );
include_once( '../include/limits/class.AllLimits.php' );
include_once( '../include/class.Traffic.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.ButtonURLData.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG=1;
if($DEBUG){
	echo "statistik_kunde2: _GET<br><pre>\n";
	print_r($_GET);
	echo "</pre><hr>\n";
 }

if( !isset( $server_id ) ){
	$server_id = $ServerID;
 }

db_master_connect();

$loServerID = new SQLString( $server_id );

$id = safe_query2 ( "SELECT * FROM admin WHERE server_id=?", $loServerID );
$admin = db_fetch_array($id);
db_free_query( $id );

## kundendaten holen
$loUser = new SQlString( $kunde );
$id = safe_query2( "SELECT * FROM kunden WHERE kunde=? AND server_id=?",
									 $loUser, $loServerID );

if( db_num_rows( $id ) !=1 ){
  include('statistik_kunden.php');
  exit();
}
									 
$werte = db_fetch_array($id);
db_free_query( $id );

$anbieter = $werte['anbieter'];
$anmeldedatum = $werte['anmeldedatum'];
$anmeldedatum = date($lang_format_date, $anmeldedatum);
$name = $werte['name'];
$firma = $werte['firma'];
$anschrift = $werte['anschrift'];
$plzort = $werte['plzort'];
$telefon = $werte['telefon'];
$fax = $werte['fax'];
$emailadresse = $werte['emailadresse'];
$kundennummer = $werte['kundennummer'];
$freifeldname1 = $werte['freifeldname1'];
$freifeldname2 = $werte['freifeldname2'];
$freifeldname3 = $werte['freifeldname3'];
$freifeldwert1 = $werte['freifeldwert1'];
$freifeldwert2 = $werte['freifeldwert2'];
$freifeldwert3 = $werte['freifeldwert3'];
$maxpop = $werte['maxpop'];
$maxkb = $werte['maxkb'];
$popmaxkb = $werte['popmaxkb'];
$maxmysql = $werte['maxmysql'];
$maxcronjobs = $werte['maxcronjobs'];
$maxemail = $werte['maxemail'];
$maxautoresponder = $werte['maxautoresponder'];
$maxftp = $werte['maxftp'];
$maxtransfer = $werte['maxtransfer'];
$maxsubdomains = $werte['maxsubdomains'];
$ftp = $werte['ftp'];
$php = $werte['php'];
$wildcard = $werte['wildcard'];
$perl = $werte['perl'];
$ssi = $werte['ssi'];
$shell = $werte['shell'];
$liSsl = $werte['cssl'];
$scponly = $werte['scponly'];
$statistik = $werte['statistik'];
$pwschutz = $werte['pwschutz'];
$fehlerseiten = $werte['fehlerseiten'];
$webftp = $werte['webftp'];
$webmail = $werte['webmail'];
$coldfusion = $werte['coldfusion'];
$gesperrt = $werte['gesperrt'];
$spamfilter = $werte['spamfilter'];
$maillist = $werte['maxmaillist'];
## /kundendaten holen

# speicher berechnen
$kbhomedir = $werte['kbhomedir'];
$kbdb = $werte['kbdb'];
$kbpop = $werte['kbpop'];
$kbgesamt = $kbdb + $kbhomedir;

if( $werte['popmaxkb'] == 0 ){
  $kbgesamt += $kbpop;
}

$liMailSpaceUsage = $kbpop;

# /speicher berechnen

# Anbieterreche auslesen
$id = safe_query2("SELECT * FROM anbieter WHERE anbieter='$anbieter' AND server_id=?",
									$loServerID );
$serverkann = db_fetch_array( $id );
db_free_query( $id );

$limits = new AllLimits ( 'UserCanHave', $serverkann );
$limits->SetFromRow ( $werte, 'kunden' );

$skpop = $serverkann['pop'];
$skemail = $serverkann['email'];
$skautoresponder = $serverkann['autoresponder'];
$skftp = $serverkann['ftp'];
$sksubdomains = $serverkann['subdomains'];
$skmysql = $serverkann['mysql'];
$skphp = $serverkann['php'];
$skperl = $serverkann['perl'];
$skssi = $serverkann['ssi'];
$skshell = $serverkann['shell'];
$skscponly = $serverkann['scponly'];
$skstatistik = $serverkann['statistik'];
$skpwschutz = $serverkann['pwschutz'];
$skfehlerseiten = $serverkann['fehlerseiten'];
$skwebftp = $serverkann['webftp'];
$skwebmail = $serverkann['webmail'];
$skcoldfusion = $serverkann['coldfusion'];
$skspamfilter = $serverkann['spamfilter'];
$skmaillist = $serverkann['maxmaillist'];
# /Anbieterrechte auslesen


## transfer berechnen
$monat = date('n');
$jahr = date('Y');
$tag = date('j');

$jahrstr = $jahr;

$deMonths = array( 'Januar','Februar','M&auml;rz',
									 'April','Mai','Juni','Juli','August',
									 'September','Oktober','November','Dezember' );
$monatstr = $deMonths[$monat-1];

$trf=new Traffic();
$trf->setLog( $trafficLog );
$trf->setUser( $kunde, 0 );
$trf->setServerID( $server_id );
$trf->setFields(array( 'web', 'ftp', 'email', 'pop' ) );
$trf->monthlyQuery( $monat, $jahr );

$transferweb = $trf->getTraffic('web');
$transferftp = $trf->getTraffic('ftp');
$transferemail = $trf->getTraffic('email')+$trf->getTraffic('pop');

$transfergesamt = $transferftp + $transferweb + $transferemail;
## /transfer berechnen

$laDomains = array();
$id = safe_query2( "SELECT domain FROM domains WHERE kunde=? AND richtigedomain=1 ".
									 " AND server_id=? ORDER BY domain", $loUser, $loServerID );
while( $werte = db_fetch_array( $id ) ){
	$laDomains[] = $werte['domain'];
 }
db_free_query( $id );
$domains = join( '<br>', $laDomains);

## anzahl kunden, domains, pop3, email, subdomains, dbs, ipadressen
$anzahlkunden = 1;

$id = safe_query2( "SELECT count(domain) AS anzahldomains FROM domains ".
									 " WHERE kunde=? AND server_id=? AND richtigedomain=1",
									 $loUser, $loServerID	 );
list($anzahldomains) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT count(domain) AS anzahlsubdomains FROM domains ".
									 " WHERE kunde=? AND server_id=? AND richtigedomain=0",
									 $loUser, $loServerID
									 );
list($anzahlsubdomains) = db_fetch_array( $id, 'N');;
db_free_query( $id );
/**
 * Shared domains
 */
if( $admin['shareddomains'] && $serverkann['maxshareddomains'] ){
  $lrId = safe_query2( " SELECT domain FROM domains WHERE kunde = ? AND richtigedomain = 7".
                       " AND server_id=? ORDER BY domain",
                       $loUser, $loServerID );
  $laSharedDomains = array();
  while( list( $domain ) = db_fetch_array( $lrId, 'N' ) ){
    $laSharedDomains[] = $domain;
  }
  db_free_query( $lrId );
  $lcSharedDomains = implode( '<br>', $laSharedDomains );
}

$id = safe_query2( "SELECT count(account) AS anzahlpop FROM pop3 ".
									 " WHERE kunde=? AND server_id=?",
									 $loUser, $loServerID );
list($anzahlpop) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT count(account) AS anzahlftp FROM ftp ".
									 " WHERE kunde=? AND server_id=?",
									 $loUser, $loServerID );
list($anzahlftp) = db_fetch_array($id);
db_free_query( $id );

$id = safe_query2( "SELECT count(ident) AS anzahlemail FROM email ".
									 " where kunde=? AND server_id=?",
									 $loUser, $loServerID );
list($anzahlemail) = db_fetch_array($id,'N');
db_free_query( $id );

$id = safe_query2( "SELECT count(ident) AS anzahlautoresponder FROM autoresponder".
									 " WHERE kunde=? AND server_id=?",
									 $loUser, $loServerID );
list($anzahlautoresponder) = db_fetch_array($id);;
db_free_query( $id );

$id = safe_query2( "SELECT ip FROM ipadressen WHERE kunde=? AND server_id=?",
									 $loUser, $loServerID );
list($kundenipstr) = db_fetch_array( $id, 'N' );;
if( istleer($kundenipstr ) ){
	$kundenipstr = ltext('stku2_st_ip_addr'); 
 }
db_free_query( $id );


##anzahl mysqldbs
$id = safe_query2( "SELECT count(datenbank) AS mysql FROM mysql_datenbanken".
									 " WHERE kunde = ? AND server_id=?",
									 $loUser, $loServerID );
list($anzahlmysql) = db_fetch_array( $id, 'N' );
db_free_query( $id );
##anzahl mysqldbs

##
$cronjobs = count_cron_jobs_user($kunde, $server_id );
##

## maillist
if($skmaillist){
	$id = safe_query2( "SELECT COUNT(*) AS cnt FROM maillist m,  domains d ".
										 " WHERE d.kunde=? AND d.id = m.domain_id AND d.server_id=? ".
										 " AND m.server_id=?",$loUser, $loServerID, $loServerID );
	list($maillist_count) = db_fetch_array($id);;
	db_free_query( $id );
}
## //maillist

## idn
//if($skidn)
//{
//	$id = db_query('SELECT COUNT(*) AS cnt FROM idn_aliases INNER JOIN domains ON (domains.id = idn_aliases.domain_id) WHERE domains.kunde=\''.$kunde.'\'');
//	$werte = db_fetch_array($id);
//	$idn_count = $werte['cnt'];
//}
## //idn

## /anzahl kunden, domains, pop3, email, subdomains, dbs,  ipadressen

$page = new MainPageElement();
$data = new SetOfRowsData();

if ($gesperrt > 0) {
	$data->AppendRow(new HTMLDataField(ltext("stku2_descr1")));
}	

$id = safe_query2( "SELECT a.hostname, s.name FROM admin a ".
									 " LEFT JOIN server s ON s.server_id=a.server_id ".
									 " WHERE a.server_id=?", $loServerID );
list($hostname,$name) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$page ->AppendToContent($data->GetOutputPresentation(ltext('stku2_title1',
																													 array( $kunde,
																																	"'$name' ($hostname)"
																																 )
																													 )
																										 )
												);

//-------------------------------------------------------------

//
// <Lavel> <Value> if Value is not empty
//
function makeLV($label,$value){
	global $data;
	if($value){
		$data->AppendRow(new HTMLDataField($label), new HTMLDataField($value));
	}
}

$data->ClearRows();
$data->AppendRow(new HTMLDataField(ltext("stku2_cell_date")), new HTMLDataField($anmeldedatum));

makeLV( ltext( 'stku2_cell_name' ), $name );
makeLV( ltext( 'stku2_cell_firm' ),$firma );
makeLV( ltext( 'stku2_cell_address' ),$anschrift );
makeLV( ltext( 'stku2_cell_city' ),$plzort );
makeLV( ltext( 'stku2_cell_tel' ),$telefon );
makeLV( ltext( 'stku2_cell_fax' ),$fax );
makeLV( ltext( 'stku2_cell_email' ),$emailadresse );
makeLV( ltext( 'stku2_cell_cid' ),$kundennummer );
makeLV( $freifeldname1, $freifeldwert1 );
makeLV( $freifeldname2, $freifeldwert2 );
makeLV( $freifeldname3, $freifeldwert3 );

$table = $data->GetOutputPresentation(ltext("stku2_title2"));
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);
//-------------------------------------------------------------------

$errorColor = array("bgcolor"=>$fehlerfarbe);

//
// <Lable><Colored value> 
//
function makeLC($label,$value,$ifError=false){
	global $data;
	global $errorColor;
	$loValue = new HTMLDataField($value);
	if ($ifError){
		$loValue->SetParentAttributes($errorColor);
	}
	$data->AppendRow(new HTMLDataField($label),$loValue);
}
function makeIskIsk($number,$max){
	return sinnv_intwert($number,ltext("g_nolimit")).' ('.sinnv_intwert($max,ltext("g_nolimit")).')';
}
$data->ClearRows();

$data->AppendRow(new HTMLDataField(ltext("stku2_cell_domains")), new HTMLDataField($domains));

if( $admin['shareddomains'] && $serverkann['maxshareddomains'] ){
  $data->AppendRow( new HTMLDataField( ltext('ldf_limit_shareddomains') ), 
                         new HTMLDataField( $lcSharedDomains ) );
}

makeLC ( ltext("stku2_cell_pop3"),makeIskIsk($anzahlpop,$maxpop),
	(($anzahlpop > $maxpop) && ($maxpop <> -1)));

makeLC ( ltext("stku2_cell_email"),makeIskIsk($anzahlemail,$maxemail),
	(($anzahlemail > $maxemail) && ($maxemail <> -1)));

makeLC ( ltext("stku2_cell_autoresponder"),makeIskIsk($anzahlautoresponder,$maxautoresponder),
	(($anzahlautoresponder > $maxautoresponder) && ($maxautoresponder <> -1)));

makeLC ( ltext("stku2_cell_subdomains"),makeIskIsk($anzahlsubdomains,$maxsubdomains),
	(($anzahlsubdomains > $maxsubdomains) && ($maxsubdomains <> -1)));

makeLC ( ltext("stku2_cell_mysql"),makeIskIsk($anzahlmysql,$maxmysql),
	(($anzahlmysql > $maxmysql) && ($maxmysql <> -1)));

	if ( $admin["cronjobs"] ){
	makeLC ( ltext("stku2_cell_cron"), makeIskIsk($cronjobs,$maxcronjobs),
		(($cronjobs > $maxcronjobs) && ($maxcronjobs <> -1)) );
}

makeLC ( ltext("stku2_cell_ftpusers"), makeIskIsk($anzahlftp,$maxftp),
	(($anzahlftp > $maxftp) && ($maxftp <> -1)));

if( $admin["majordomo"]){
	makeLC ( ltext("stku2_cell_maillist"), makeIskIsk($maillist_count,$maillist),
		(($maillist_count > $maillist) && ($maillist <> -1)));
}

//makeLC ( ltext("stku2_cell_idn"), makeIskIsk($idn_count,$idn),
//	(($idn_count > $idn) && ($idn <> -1)));

$table=$data->GetOutputPresentation(ltext("stku2_title3"));
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);
//-------------------------------------------------------------------------------------

$data->ClearRows();

makeLC ( ltext("stku2_cell_maxspace"),
	sinnv_kbwert($maxkb,ltext("g_nolimit")));	
	
makeLC ( ltext("stku2_cell_vusedspace"),
	sinnv_kbwert($kbgesamt,ltext("g_nolimit")),
	(($kbgesamt > $maxkb) && ($maxkb <> -1)));

makeLC ( ltext("stde_cell_usedspace"),
	sinnv_kbwert($kbgesamt,ltext("g_nolimit")),
	(($kbgesamt > $maxkb) && ($maxkb <> -1)));

makeLC ( ltext("stku2_cell_dufiles"),
	sinnv_kbwert($kbhomedir,ltext("g_nolimit")));
	
makeLC ( ltext("stde_cell_dudb"),
	sinnv_kbwert($kbdb,ltext("g_nolimit")));

   
  
$table=$data->GetOutputPresentation(ltext("stku2_title4"));
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);

/**
 * Mail space usage table
 */
if( $popmaxkb != 0 ){
  $data->ClearRows();

  makeLC( ltext( 'stde_cell_max_mailspace' ), sinnv_kbwert( $popmaxkb,ltext( 'g_nolimit' ) ) ); 
  makeLC( ltext( 'stde_cell_used_mailspace' ),  sinnv_kbwert( $liMailSpaceUsage, ltext( 'g_nolimit' ) ),
    (($liMailSpaceUsage > $popmaxkb) && ($popmaxkb <> -1)));

  $table = $data->GetOutputPresentation( ltext( 'stde_mailspace' ) );
  $table->SetWidths( '50%', '50%' );  
  $page->AppendToContent( $table );
}
  
 
//-------------------------------------------------------------------------------------

$data->ClearRows();

makeLC ( ltext("stku2_cell_maxtraffic"),
	sinnv_kbwert($maxtransfer,ltext("g_nolimit")));

makeLC ( ltext("stku2_cell_usedtraffic"),
	sinnv_kbwert($transfergesamt,ltext("g_nolimit")),
	(($transfergesamt > $maxtransfer) && ($maxtransfer <> -1)));

makeLC ( ltext("stku2_cell_traffichttpd"),
	sinnv_kbwert($transferweb,ltext("g_nolimit")));
	
makeLC ( ltext("stku2_cell_trafficftp"),
	sinnv_kbwert($transferftp,ltext("g_nolimit")));

if ($show_emailtransfer == 1) {
	makeLC ( ltext("stku2_cell_trafficemail"),
	sinnv_kbwert($transferemail,ltext("g_nolimit")));
}

$linkRes = new ButtonURLData( ltext("stde_cell_trafficlink"),
															new LinkDataField( 'statistik_kunde3.php',
																								 '',
																								 array( 'kunde' => $kunde,
																												'server_id' => $server_id )
																								 )
															);
$linkRes->SetColSpan(2);
$data->AppendRow($linkRes);

$table = $data->GetOutputPresentation(ltext("stku2_title5").' '.$monatstr.' '.$jahrstr);
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);
//--------------------------------------------------------------------
$data->ClearRows();

$data->AppendRow(new HTMLDataField(ltext("stku2_cell_ip")),
	new HTMLDataField($kundenipstr));

$table=$data->GetOutputPresentation(ltext("stku2_title6"));
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);
//--------------------------------------------------------------------
function makeLA($label,$value){
	global $data;
	
	$loValue = new HTMLDataField($value?ltext("stde_activated"):ltext("stde_deactivated"));
	
	$data->AppendRow(new HTMLDataField($label),$loValue);
}
$data->ClearRows();

makeLA(ltext("stku2_cell_wildcard"),$wildcard);
if ($admin["ftp"] == 1) {
	makeLA(ltext("stku2_cell_ftp"),$ftp);
}
if ($admin["php"] == 1) {
	makeLA(ltext("stku2_cell_php"),$php);
}
if ($admin["perl"] == 1) {
	makeLA(ltext("stku2_cell_perl"),$perl);
}
if ($admin["ssi"] == 1) { 
	makeLA(ltext("stku2_cell_ssi"),$ssi);
}
if ($admin["shell"] == 1) { 
	makeLA(ltext("stku2_cell_shell"),$shell);
}
if ($admin["cssl"] == 1) { 
	makeLA(ltext("stku2_cell_ssl"),$liSsl);
}
if ($admin["scponly"] == 1) { 
	makeLA(ltext("stku2_cell_scponly"),$scponly);
}
if ($admin["statistik"] == 1) {
	makeLA(ltext("stku2_cell_webalizer"),$statistik);
}
if ($admin["pwschutz"] == 1) {
	makeLA(ltext("stku2_cell_pwdir"),$pwschutz);
}
if ($admin["fehlerseiten"] == 1) {
	makeLA(ltext("stku2_cell_errorfiles"),$fehlerseiten);
}
if ($admin["webftp"] == 1) { 
	makeLA(ltext("stku2_cell_webftp"),$webftp);
}
if ($admin["webmail"] == 1) { 
	makeLA(ltext("stku2_cell_webmail"),$webmail);
}
if ($admin["coldfusion"] == 1) { 
	makeLA(ltext("stku2_cell_coldfusion"),$coldfusion);
}
if ($admin["spamfilter"] == 1) { 
	makeLA(ltext("stku2_cell_spamfilter"),$spamfilter);
}
for ( $limits->FirstService(); $service =& $limits->NextService(); ){
	makeLA ( $service->GetLabel() , ltext( $service->GetValue()));
}
$table=$data->GetOutputPresentation(ltext("stku2_title7"));
$table->SetWidths("50%","50%");	
$page->AppendToContent($table);
//--------------------------------------------------
$page->OutputHTML();

db_close();
?>
  
 
