<?php
########## Confixx(R) 3.2 Professional ###########
###### Copyright SWsoft, Inc. 2004-2006 ##########
#### http://www.swsoft.com - info@swsoft.com ##### 
  
include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/class.Traffic.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValuePreLocaleSuf.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.HookedValue.php' );
include_once( '../include/data_source/class.ConditionalyDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.SelectElement.php' );

global $DEBUG;
//$DEBUG=1;

if( ! $cur_page ){
	$cur_page = 'statistik_kunden.php';
}

if( $DEBUG ){
	echo "Statistik_kunden.php<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
 }

db_master_connect();


$jahr  = date( 'Y' );
$monat = date( 'm' );
$tag   = date( 'd' );

$lmonat = $monat - 1;
if (strlen($lmonat) == 1) { $lmonat = '0'.$lmonat; }
$ljahr = $jahr;
if ($lmonat == 0){
	$lmonat = 12;
	$ljahr--;
}

if(!$overlimit){
	$overlimit = 0;
 }

initPagingSettings( $_POST, array( 'name2find' => $name2find, 
																	 'anbieter' => $anbieter,
																	 'order' => $order,
																	 'direction' => $direction,
																	 'overlimit' => $overlimit ) 
										);


$res = safe_query2( "SELECT COUNT(*) FROM kunden" );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$laArgs = array();
$lcWhere = '';

if( isset( $name2find ) && strlen( $name2find ) ){
	$lcWhere = " AND (k.kunde LIKE '%?%' OR k.name LIKE '%?%' OR k.firma LIKE '%?%' ".
             " OR k.firstname LIKE '%?%' OR s.name LIKE '%?%' OR a.hostname LIKE '%?%' ".
             " OR d.domain LIKE '%?%')";
                          
	$laArgs[] = new SQLValue( $name2find, 'S' ); // user_name
	$laArgs[] = new SQLValue( $name2find, 'S' ); // firma
	$laArgs[] = new SQLValue( $name2find, 'S' ); // user_firstname
	$laArgs[] = new SQLValue( $name2find, 'S' ); // server_name
	$laArgs[] = new SQLValue( $name2find, 'S' ); // hostname
  $laArgs[] = new SQLValue( $name2find, 'S' ); // domain
  
}
 
if( $server2find ){
	$lcWhere .= ' AND k.server_id=?';
	$laArgs[] = new SQLValue( $server2find, 'C' );
 }

$laFields = array( 'k.kunde','k.gesperrt','k.maxkb','k.kbdb','k.kbhomedir','k.maxpop', 
                   'k.popmaxkb', 'k.kbpop', 'k.maxemail','k.maxmysql','k.maxftp',
                   'k.maxtransfer', 'k.maxsubdomains','k.server_id','a.hostname','s.name' );
$lcFields = join(',',$laFields);

if ($lcWhere) {
	$loQuery = new SQLQuery(  "SELECT k.kunde FROM kunden k, admin a ".
														" LEFT JOIN server s ON s.server_id = a.server_id ".
                            " LEFT JOIN domains d on k.kunde = d.kunde AND k.server_id=d.server_id".               
														" WHERE k.server_id=a.server_id $lcWhere GROUP BY k.kunde ", $laArgs );
  $loQuery->doQuery();
  $total_number = $loQuery->getRowCount();
    
  $lcSQL = " SELECT $lcFields FROM kunden k, admin a ".
           " LEFT JOIN server s ON s.server_id = a.server_id ".
           " LEFT JOIN domains d on k.kunde = d.kunde AND k.server_id=d.server_id".          
           " WHERE k.server_id=a.server_id $lcWhere";
                   
  if( ! in_array( $order, array( 'email', 'pop3', 'ctraffic', 'ltraffic' ) ) ){
    $lcSQL .= "  GROUP BY k.kunde";
  } 
  
  $lcSQL .= " ORDER BY k.number";
  $loQuery->Query( $lcSQL );
} else {
	$loQuery = new SQLQuery( "SELECT $lcFields FROM kunden k, admin a ".
													 " LEFT JOIN server s ON s.server_id = a.server_id ".
													 " WHERE k.server_id=a.server_id ORDER BY k.number" );
}


$lcQuery = $loQuery->Query();

$direction = (isset($direction)&&$direction == 'desc') ? 'desc' : 'asc';
$lcNewDirection = ($direction == 'asc' ) ? 'desc' : 'asc';

if( $order == 'status' ) {
	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 'ORDER BY gesperrt',
													 $lcQuery);

}elseif( $order == 'du' ) {

	$lcQuery = str_replace( 'FROM', ',k.kbhomedir+k.kbdb + IF(k.popmaxkb=0,k.kbpop,0) AS sumkb FROM', $lcQuery);

	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 'ORDER BY sumkb',
													 $lcQuery);

 } elseif( $order == 'email' ) {
	$lcQuery = str_replace( 'FROM', ',COUNT(e.kunde) as cntemail FROM', $lcQuery);

	$lcQuery = preg_replace( '/WHERE/i',
													 'LEFT JOIN email e ON e.kunde=k.kunde WHERE',
													 $lcQuery );

	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 'GROUP BY k.kunde ORDER BY cntemail',
													 $lcQuery );

 } elseif( $order == 'pop3' ) {

	$lcQuery = str_replace( 'FROM', ',COUNT(p.kunde) as cntpop FROM', $lcQuery);

	$lcQuery = preg_replace( '/WHERE/i',
													 'LEFT JOIN pop3 p ON p.kunde=k.kunde WHERE',
													 $lcQuery);
	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 'GROUP BY k.kunde ORDER BY cntpop',
													 $lcQuery);

 } elseif( $order == 'ctraffic' ) {
 
	$lcQuery = str_replace( 'FROM', ',sum(t.web)+sum(t.ftp)+sum(t.email) AS traffic FROM', $lcQuery);

	$lcQuery = preg_replace( '/WHERE/i',
													 "LEFT JOIN transfer t ON t.kunde=k.kunde AND ".
													 " t.jahr=$jahr AND (t.monat=$monat) AND ".
													 " (t.log=1) AND (t.geloescht=0) WHERE",
													 $lcQuery);

	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 "GROUP BY k.kunde ORDER BY traffic",
													 $lcQuery);

 } elseif( $order == 'ltraffic' ){

	$lcQuery = str_replace( 'FROM', ',sum(t.web)+sum(t.ftp)+sum(t.email) AS traffic FROM', $lcQuery);

	$lcQuery = preg_replace( '/WHERE/i',
													 "LEFT JOIN transfer t ON t.kunde=k.kunde AND ".
													 " t.jahr=$ljahr AND (t.monat=$lmonat) AND ".
													 " (t.log=1) AND (t.geloescht=0) WHERE",
													 $lcQuery);

	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 "GROUP BY k.kunde ORDER BY traffic",
													 $lcQuery);
 } elseif( $order == 'server' ){
	$lcQuery = preg_replace( '/ORDER\s+BY\s+\S+/i',
													 "ORDER BY k.server_id",
													 $lcQuery);

 } else {
	$order = 'kunde';
 }
$lcQuery.= ($direction == 'desc' ) ? ' DESC' : ' ASC';

$loQuery->Query( $lcQuery );


$goDS = new ConditionalyDBValue( $loQuery, $page_size, $start_index - 1 );
$goDS->TotalNumber( $total_number );


$loTemplate = new CompoundValue( 
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'gesperrt' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxsubdomains' ),
																									 new ValueFromArray( 'maxmysql' ),
																									 new ValueFromArray( 'maxftp' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'name' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxemail' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxpop' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxtransfer' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxtransfer' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'maxkb' ),
																									 new ValueFromArray( 'kbdb' ),
																									 new ValueFromArray( 'kbhomedir' ),
																									 new ValueFromArray( 'server_id' ),
																									 new ValueFromArray( 'popmaxkb' ),
																									 new ValueFromArray( 'kbpop' )
                                                   
																									 )
																);

$laContent = array();
$lcDirIcon = ($direction == 'asc') ? cc_AscIcon : cc_DescIcon;

if( $order == 'du' ){
	$laContent['du'] = new CompoundDataField( new HTMlDataField( ltext( 'stkun2_cell_du' )),
																						new IconDataField( $lcDirIcon )
																						);
	$laContent['du']->SetSeparator('');
 } else {
	$laContent['du'] = new HTMlDataField( ltext( 'stkun2_cell_du' ) );
 }

if( $order == 'server' ){
	$laContent['server'] = new CompoundDataField( new HTMlDataField( ltext( 'stkun2_cell_server' )),
																						new IconDataField( $lcDirIcon )
																						);
	$laContent['server']->SetSeparator('');
 } else {
	$laContent['server'] = new HTMlDataField( ltext( 'stkun2_cell_server' ) );
 }


if( $order == 'status' ){
	$laContent['status'] = new CompoundDataField( new HTMlDataField( ltext( 'anae_cell_status' )),
																						new IconDataField( $lcDirIcon )
																						);
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'anae_cell_status' ) );
 }

if( $order == 'email' ){
	$laContent['email'] = new CompoundDataField( new HTMlDataField( ltext( 'stkun_select2_email' ) ),
																							 new IconDataField( $lcDirIcon )
																							 );
	$laContent['email']->SetSeparator('');

 } else {
	$laContent['email'] = new HTMlDataField( ltext( 'stkun_select2_email' ) );

 }

if( $order == 'pop3' ){
	$laContent['pop3'] = new CompoundDataField( new HTMlDataField( ltext( 'stkun_select2_pop' ) ),
																							new IconDataField( $lcDirIcon )
																							);
	$laContent['pop3']->SetSeparator('');

 } else {
	$laContent['pop3'] = new HTMlDataField( ltext( 'stkun_select2_pop' ) );

 }

if( $order == 'ctraffic' ){
	$laContent['ctraffic'] = new CompoundDataField( new HTMlDataField(	ltext( 'stkun2_cell_traffic' ).' '.$monat.'/'.$jahr ),
																									new IconDataField( $lcDirIcon )
																									);
	$laContent['ctraffic']->SetSeparator('');


 } else {
		$laContent['ctraffic'] = new HTMlDataField(	ltext( 'stkun2_cell_traffic' ).' '.$monat.'/'.$jahr );
 }


if( $order == 'ltraffic' ){
	$laContent['ltraffic'] = new CompoundDataField( new HTMlDataField(	ltext( 'stkun2_cell_traffic' ).' '.$lmonat.'/'.$ljahr ),
																									new IconDataField( $lcDirIcon )
																									);
	$laContent['ltraffic']->SetSeparator('');


 } else {
		$laContent['ltraffic'] = new HTMlDataField(	ltext( 'stkun2_cell_traffic' ).' '.$lmonat.'/'.$ljahr );
 }

if( !$order || $order=='kunde'){
	
	$laContent['kunde'] = new CompoundDataField( new HTMlDataField( ltext( 'stkun2_cell_user' )),
																							 new IconDataField( $lcDirIcon )
																							 );
	$laContent['kunde']->SetSeparator('');


 } else {
	$laContent['kunde'] =  new HTMlDataField( ltext( 'stkun2_cell_user' ));
 }

$loTitle = new CompoundValue(  new DataValue( 'status', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','status');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['status']
																																)
																						 ),
															new DataValue( 'kunde', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','kunde');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['kunde']
																																)
																						 ),
															new DataValue( 'server', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','server');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['server']
																																)
																						 ),

														 new DataValue( 'email', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','email');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['email']
																																)
																						 ),
														 new DataValue( 'pop3', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','pop3');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['pop3']
																																)
																						 ),
														 new DataValue( 'ctraffic', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','ctraffic');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['ctraffic']
																																)
																						 ),
														 new DataValue( 'ltraffic', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order', 'ltraffic');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['ltraffic']
																																)
																						 ),
														 new DataValue( 'du', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','du');".
																																"setValue('start_index',1);".
																																"submitForm('direction','".$lcNewDirection."')",
																																'',
																																array(),
																																$laContent['du']
																																)
																						 )
															);



$laWidths = array(  '5%','10%','15%','10%','10%','10%', '20%', '20%' );

$goDS->Template( $loTemplate );

//=============================================================
//
// call-back functions

$gcLocked = ltext( 'kulc_status_locked' );
$gcUnlocked = ltext( 'kulc_status_active' );

$gcHeadText = htmlspecialchars( ltext( 'kulc_title1' ) );

function &makeStatusLink( &$poSrc ){

	global $gcLocked, $gcUnlocked, $gcHeadText,$confixx_interface_version;

	list($kunde,$locked,$server_id) = $poSrc->listValue();

	$lcTitle = ' ';

	if( $locked ) {
		$lcIcon = cc_LockedIcon;
		$lcTitle = $gcLocked;

	} else {
		$lcIcon = cc_ActiveIcon;
		$lcTitle = $gcUnlocked;

	}
	$text = $locked? ltext('ll_state_locked'): ltext('ll_state_ok');
	$loLink = new LinkDataField( 'user_lock.php', 
															 $lcQuery, 
															 array( 'kunde' => $kunde,
																			'server_id' => $server_id,
																			'action' => 'sperren',
																			'menu_node_id' => 'sperren',
																			'cur_page' => 'user_lock.php',
																			'head_text' => $gcHeadText ), 
															 ($confixx_interface_version == 'powp')?new IconDataField( $lcIcon ):$text);

	$loLink->Attribute( 'title', $lcTitle );
	$loLink->ParentAttribute(  'align', 'center' );

	return $loLink;

}

$gaCounts = array();
$gaCounts['maxftp'] = new SQLQuery( "SELECT COUNT(kunde) FROM ftp WHERE kunde=? AND server_id=?" );
$gaCounts['maxmysql'] = new SQLQuery( "SELECT COUNT(kunde) FROM mysql_datenbanken WHERE kunde=? AND server_id = ?" );
$gaCounts['maxsubdomains'] = new SQLQuery( "SELECT COUNT(kunde) FROM domains WHERE richtigedomain=0 AND kunde=? AND server_id=?" );

$gaServers = array();
$goServerName = new SQLQuery( "SELECT a.hostname, s.name FROM admin a ".
															" LEFT JOIN server s ON s.server_id=a.server_id ".
															" WHERE a.server_id=?" );

function &makeUserLink( &$poSrc ){
	global $gaCounts,$gaServers,$goServerName;
	global $fehlerfarbe;
	global $goDS,$confixx_interface_version;

	$loUser =& $poSrc->Value('kunde');
	$kunde = $loUser->Value();

	$loServerID =& $poSrc->Value('server_id');
	$server_id = $loServerID->Value();


	if( array_key_exists( $server_id, $gaServers ) ){
		$lcServerName = $gaServers[$server_id];
	}else{
		$goServerName->doQuery( array( new SQLValue( $server_id, 'C' ) ));
		list($hostname,$name) = $goServerName->fetchArray( 'N' );
		$goServerName->freeResult();
		$gaServers[$server_id] = $lcServerName = "'$name'";
	}

	$lcUserDetails = ltext('stku3_title1_master',array($kunde,$lcServerName));

	$loLink = new LinkDataField('statistik_kunde2.php',
															'',
															array( 'kunde' => $kunde, 
																		 'server_id' => $server_id,
																		 'menu_node_id' => 'stat_user',
																		 'cur_page' => 'statistik_kunde2.php', 
																		 'head_text' => $lcUserDetails,
																		 ),
															$kunde
															);

	$loLink->Attribute('title',$lcUserDetails);

	$laArgs = array( new SQLValue( $kunde, 'C' ),
									 new SQLValue( $server_id, 'C' )  );

	foreach( array_keys($gaCounts) as $lcKey){ 

# get maximum of limit
		$loItem =& $poSrc->Value($lcKey);
		$max = $loItem->Value();

# get real value
		$gaCounts[$lcKey]->doQuery( $laArgs );
		list($count) = $gaCounts[$lcKey]->fetchArray( 'N' );

		if (($max != -1) && ($max < $count)) {
# overlimit is found
			$loLink->ParentAttribute( 'bgcolor', $fehlerfarbe );
			$goDS->AcceptRow( 1 );
			break;
		}
		$gaCounts[$lcKey]->freeResult();
	}
	return $loLink;
}

function &makeServer( &$poSrc ){
	list($name, $server_id) = $poSrc->listValue();
	return new HTMLDataField( $name );
}

$gaMailCounts = array();
$gaMailCounts['maxpop'] = new SQLQuery( "SELECT COUNT(kunde) FROM pop3 WHERE kunde=? AND server_id=?" );
$gaMailCounts['maxemail'] = new SQLQuery( "SELECT COUNT(kunde) FROM email WHERE kunde=? AND server_id=?" );

function &makeEmailUsage( &$poSrc ){
	global $gaMailCounts;
	global $fehlerfarbe;
	global $goDS;
	

	$laParentAttributes = array( 'align' => 'right' );
	$laText = array();

	$loUser =& $poSrc->Value('kunde');
	$kunde = $loUser->Value();

	$loServerID =& $poSrc->Value('server_id');
	$server_id = $loServerID->Value();

	$laArgs = array( new SQLValue( $kunde, 'C' ),
									 new SQLValue( $server_id, 'C' )
									 );

	$lcKey = 'maxemail';

	$loItem =& $poSrc->Value($lcKey);
	$max = $loItem->Value();

	$gaMailCounts[$lcKey]->doQuery( $laArgs );
	list($count) = $gaMailCounts[$lcKey]->fetchArray( 'N' );

	if (($max != -1) && ($max < $count)) {
# overlimit is found
		$laParentAttributes['bgcolor'] = $fehlerfarbe;
		$goDS->AcceptRow( TRUE );
	}
	$gaMailCounts[$lcKey]->freeResult();

	$loEmailUsage = new HTMLDataField( $count, array(), $laParentAttributes);

	return $loEmailUsage;

}

function &makePopUsage( &$poSrc ){
	global $gaMailCounts;
	global $fehlerfarbe;
	global $goDS;

	$laParentAttributes = array( 'align' => 'right' );
	$laText = array();

	$loUser =& $poSrc->Value('kunde');
	$kunde = $loUser->Value();
	$loServerID =& $poSrc->Value('server_id');
	$server_id = $loServerID->Value();

	$laArgs = array( new SQLValue( $kunde, 'C' ),
									 new SQLValue( $server_id, 'C' )
									 );

	$lcKey = 'maxpop';

	$loItem =& $poSrc->Value($lcKey);
	$max = $loItem->Value();

	$gaMailCounts[$lcKey]->doQuery( $laArgs );
	list($count) = $gaMailCounts[$lcKey]->fetchArray( 'N' );

	if (($max != -1) && ($max < $count)) {
# overlimit is found
		$laParentAttributes['bgcolor'] = $fehlerfarbe;
		$goDS->AcceptRow( 1 );
	}
	$gaMailCounts[$lcKey]->freeResult();

	$loPopUsage = new HTMLDataField( $count, array(), $laParentAttributes);

	return $loPopUsage;

}


$trfk = new Traffic();
$trfk->setLog( $trafficLog );
$trfk->setGroup( array('server_id','kunde') );
$trfk->setBlocked(0);
if( $anbieter && $anbieter != "alle" ){
  $trfk->setReseller( $anbieter );
}
$trfk->setFields(array( 'web', 'ftp', 'email', 'pop' ));
$trfk->monthlyQuery($monat,$jahr);
$arrayakttransfer = $trfk->getGroupTraffic( 'sum' );
//arsort($arrayakttransfer,SORT_NUMERIC);

$trfk->monthlyQuery($lmonat,$ljahr);
$arrayltransfer=$trfk->getGroupTraffic('sum');
//arsort($arrayltransfer,SORT_NUMERIC);

function &makeCurTraffic( &$poSrc ){
	global $arrayakttransfer;
	global $fehlerfarbe;
	global $goDS;

	list($kunde,$max,$server_id) = $poSrc->listValue();

	$count = $arrayakttransfer[$server_id][$kunde];

	$loTraffic = new HTMLDataField( sinnv_kbwert( $count ),
																	array(),
																	array('align' => 'right') );

	if (($max != -1) && ($max < $count)) {
		$loTraffic->ParentAttribute( 'bgcolor', $fehlerfarbe);
		$goDS->AcceptRow( 1 );
	}
	return $loTraffic;

}


function &makeLastTraffic( &$poSrc ){
	global $arrayltransfer;
	global $fehlerfarbe;
	global $goDS;

	list($kunde,$max,$server_id) = $poSrc->listValue();

	$count = $arrayltransfer[$server_id][$kunde];

	$loTraffic = new HTMLDataField( sinnv_kbwert( $count ), 
																	array(), 
																	array('align' => 'right') );

	if (($max != -1) && ($max < $count)) {
		$loTraffic->ParentAttribute( 'bgcolor', $fehlerfarbe );
		$goDS->AcceptRow( 1 );
	}
	return $loTraffic;


}

function &makeDiskUsage( &$poSrc ){

	global $fehlerfarbe;
	global $DEBUG;
	global $goDS;

	/*
	if($DEBUG){
		echo "makeDiskUsage: start<br><pre>\n";
		print_r($poSrc);
		echo "</pre><hr>\n";
	}
	*/

	$loItem =& $poSrc->Value( 'maxkb' );
	$max = $loItem->Value();

	$loItem =& $poSrc->Value( 'kbdb' );
	$count = $loItem->Value();

	$loItem =& $poSrc->Value( 'kbhomedir' );
	$count += $loItem->Value();

  $loItem =& $poSrc->Value( 'popmaxkb' );
	$popmaxkb = $loItem->Value();
  
  if( $popmaxkb == 0 ){
    $loItem =& $poSrc->Value( 'kbpop' );
  	$count += $loItem->Value();
  }

  
	$loDiskUsage = new HTMLDataField( sinnv_kbwert($count), array(),
																		array('align' => 'right') );

	if (($max != -1) && ($max < $count)) {
		$loDiskUsage->ParentAttribute( 'bgcolor', $fehlerfarbe );


		$liAccept = $goDS->AcceptRow( 1 );

		/*
		if($DEBUG){
			echo "makeDiskUsage : max=$max, count=$count, accept=$liAccept<br>\n";
			echo "<pre>\n";
			print_r($goDS);
			echo "</pre><hr>\n";
		}
		*/
		if ( $loItem =& $poSrc->Value( 'skip_row' )  ) {
			$liSkip =& $loItem->Value();
			
			//				echo "makeDiskUsage : skip_row=$liSkip<br>\n";
			$liSkip = 0;
		}
	}



	return $loDiskUsage;
}

// end call-back functions
//
//=============================================================

$loConv = new CompoundValue( new ValueFormated( 'gesperrt', NULL, 'makeStatusLink' ),
														 new ValueFormated( 'kunde', NULL, 'makeUserLink' ),
														 new ValueFormated( 'server', NULL, 'makeServer' ),
														 new ValueFormated( 'email', NULL, 'makeEmailUsage' ),
														 new ValueFormated( 'pop', NULL, 'makePopUsage' ),
														 new ValueFormated( 'ctraffic', NULL, 'makeCurTraffic' ),
														 new ValueFormated( 'ltraffic', NULL, 'makeLastTraffic' ),
														 new ValueFormated( 'disk', NULL, 'makeDiskUsage' )
														 );

$goDS->Conversion( $loConv );
if( $overlimit ){
	$goDS->SkipPolicy( 1 ); // skip all rows by default
 } else {
	$goDS->SkipPolicy( 0 ); // accept all rows by default
 }


$goDS->doQuery();

$loPTV = new PagedTableView( $goDS, $total_number );

$goDS =& $loPTV->DataSource();

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );

$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', "$cur_page" );
$loPTV->setParameter( 'head_text', "$head_text" );

$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if (isset($name2find)&&strlen($name2find)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}


$tbl =& $loPTV->GetOutputPresentation( array( 'action' => 'statistik_kunden.php',
																							'method' => 'post',
																							'name' => 'reslist' ), 
																			 ltext( 'ms_userstats' ) 
																			 );


if( $overlimit ) { // find the next page with overlimit

	while( !$loPTV->getBodySize() ) {

		unset( $goDS );
		$goDS =& $loPTV->DataSource(); // get data source of the view

		unset( $loSQLQuery );
		$loSQLQuery =& $goDS->SQlQuery(); // get sql query of the data source

		$liStart = $loSQLQuery->getNextStart();

		if( $liStart < $total_number ){ // go to the next page

			$start_index = $liStart;
			$loSQLQuery->Start( $start_index );
			
			$goDS->doQuery();
			
			if($DEBUG){
				echo "start_index: $start_index<br>\n";
			/*
			echo "<pre>\n";
			print_r($loDS);
			echo "</pre><hr>\n";
			*/
			}

			$loPTV->StartIndex( $start_index + 1 );
			unset( $tbl );
			$tbl =& $loPTV->GetOutputPresentation( array( 'action' => 'statistik_kunden.php',
																										'method' => 'post',
																										'name' => 'reslist' ), 
																						 ltext( 'ms_userstats' ) 
																					 );
			
		} else { // nothing is found
			break;
		}
	}
 }

//=============================================
//
// search

//$DEBUG=1;

$loRes = new CompoundDBValue( new SQLQUery("SELECT server_id AS server2find ,name FROM server WHERE server_id<>'$masterServerID' ORDER BY name"));
$loRes->doQuery();
$loRes->addValue( new KeyValue( 'server2find', '' ), new ValueLocale('stkun_select3_allservers') );

/*
if($DEBUG){
	echo "servers<br><pre>\n";
	print_r($loRes);
	echo "</pre><hr>\n";
 }
*/

$dsSearch = new CompoundValue( new ValueFromArray( 'name2find', $name2find ),
															 $loRes,
															 new ValueFromArray( 'overlimit', $overlimit ),
															 new ValueLocale( 'stkun_cell_overlimit' ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(),
																		 new InputTextElement( array( 'name' => 'name2find' ) ), 
																		 new SelectElement( array( 'name' => 'server2find' ) ), 
																		 new InputCheckboxElement( array( 'name' => 'overlimit',
																																			'value' => 1 )),
																		 new HTMLElement( '' ),
																		 new PPButtonElement( '',
																													"javascript:submitForm('start_index',1)",
																													'bid-search'
																													),
																		 new PPButtonElement( '',
																													"javascript:setValue('name2find','');".
																													"setValue('server2find', '');".
																													"setValue('overlimit', 0);".
																													"submitForm('start_index',1)",
																													'bid-show-all'
																													)
																		 );

$loSearch->setDataSource( $dsSearch, 
													array( 'name2find' => $name2find, 
																 'server2find' => $server2find, 
																 'overlimit' => $overlimit 
																 ) 
													);

$tbl->SearchElement( $loSearch );
$tbl->updateBodyContent();


// end search
//
//======================================================

$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../js/paged_form.js' ) );


//
//
//===================================================================

db_close();
?>
