<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

if( ! function_exists( 'iconv' ) ){
  $fehlertext = ltext( 'wmail_noiconv' );
  function iconv( $pcInputCharset, $pcOutputCharset, $pcStr ){
    return $pcStr;
  } 
}

if (!function_exists("str_split")) {
   function str_split($string, $length = 1) {
       if ($length <= 0) {
           trigger_error(__FUNCTION__."(): The the length of each segment must be greater then zero:", E_USER_WARNING);
           return false;
       }
       $splitted  = array();
       $str_length = strlen($string);
       $i = 0;
       if ($length == 1) {
           while ($str_length--) {
               $splitted[$i] = $string[$i++];
           }
       } else {
           $j = $i;
           while ($str_length > 0) {
               $splitted[$j++] = substr($string, $i, $length);
               $str_length -= $length;
               $i += $length;
           }
       }
       return $splitted;
   }
}

function dateFormat($timeStamp,$format) {
  if($format == "datetime") {
    return date("d.m.Y H:i", $timeStamp);
  }
  if($format == "date") {
    return date("d.m.Y", $timeStamp);
  }
  if($format == "time") {
    return date("H:i", $timeStamp);
  }
  if($format == "sortdate") {
    return date("YmdHi", $timeStamp);
  }
}

function sizeFormat($size) {
  if($size < 99999) {
    $size = round(($size/1024),2)."k";
  } else {
    $size = round(($size/1024)/1024,2)."M";
  }
  return $size;
}

function getLine() {
  global $fp;
  //return fgets($fp, 1024);
  return substr(fgets($fp, 1024), 0, -2);
}
 
function getLine2() {
  global $fp;
  while (!feof($fp)) {
    $buffer = fgets($fp, 4096);
  }
}

function removeLineBreaks($string) {
  return strtr($string, "\r\n", "  ");
}

function get_options()
{
  global $ServerID;
	$id = db_query("SELECT imap_options FROM admin WHERE server_id='$ServerID'");	
	$laData = db_fetch_array($id);
	$laTmp = explode( '|', $laData['imap_options'] );
	return $laTmp[0];
}

function set_options($options)
{
  global $ServerID;
	db_query('UPDATE admin SET imap_options=\''.addslashes($options).'\' WHERE server_id=\''.$ServerID.'\'');
}

function server_connect($options = '', $pcCurrentFolder = "INBOX")
{
	global $PHP_AUTH_USER;
	global $PHP_AUTH_PW;
	global $incomingMailServer;
	global $incomingMailPort;
	global $incomingMailProtocol;

	if (!isset($incomingMailServer)) {
		$incomingMailServer = 'localhost';
	}
	
	$strConn ='{'.$incomingMailServer.':'.$incomingMailPort.'/'.$incomingMailProtocol.$options.'}'.$pcCurrentFolder;

	if($mbox = @imap_open ($strConn, $PHP_AUTH_USER, $PHP_AUTH_PW)) {
		delUserParam($PHP_AUTH_USER, 'old_password');
	}	elseif ($pass = getUserParam($PHP_AUTH_USER, 'old_password'))	{
		$mbox = @imap_open ($strConn, $PHP_AUTH_USER, $pass);
	} else return false;
	
	return $mbox;
}

function e_connect($pcCurrentFolder = "INBOX")
{
	global $mbox; 
	global $ServerID; 
	global $incomingMailServer; 
	global $incomingMailPort;
	global $PHP_AUTH_USER;
	global $PHP_AUTH_PW;
	$ret = false;
	
	if($mbox = server_connect(get_options(), $pcCurrentFolder))
	{
		$ret = true;	
	} 
	
	if(!$ret)
	{
		$opts = array('', '/notls/novalidate-cert', '/notls', '/novalidate-cert');
		
		foreach ($opts as $op)
		{
			if($mbox = server_connect($op))	
			{
				$ret = true;
				set_options($op);
				break;	
			}
		}
	}
	return $ret;
}


function getHeaders($headerArray) {
  for ($i = 0; $i < sizeof($headerArray); $i++) {
    $parts = explode(": ", $headerArray[$i], 2);
    $headers[strtolower($parts[0])] = $parts[1];
  }
  return $headers;
}

function mimeHeaderDecode($string)
{
	return decode_subject($string);
}

function showBody($body) {
  $body = htmlspecialchars($body);
  
  // Making bold text out of *text*:
  $body = eregi_replace(" \*([a-z0-9]+[^*]*[a-z0-9]+)\*", " <b>\\1</b>", $body);
  
  // Making italic text out of /text/:
  $body = eregi_replace(" /([a-z0-9]+[^/]*[a-z0-9]+)/", " <i>\\1</i>", $body);
  
  // Making underlined text out of _text_:
  $body = eregi_replace(" _([a-z0-9]+[^_]*[a-z0-9]+)_", " <u>\\1</u>", $body);
  
  // Replace all links 
  $body = eregi_replace("([a-z0-9._-]+@[a-z0-9.-]+\.[a-z]{2,6})", "<a href='email_neu.php?copy_to=\\1'>\\1</a>", $body);
  $body = eregi_replace("((f|ht)tps?://[^ \r]*[^ \r,.:!?)])", "<a href='\\1' target='_blank'>\\1</a>", $body);
  $body = preg_replace('/((?<!\/\/)www\.[^ \r]*[^ \r,.:!?)])/i', '<a href=\'http://\\1\' target=\'_blank\'>\\1</a>', $body);
  
  $body = nl2br($body);
  
  return $body;
}

/**
 * Parses an address string such as "Testname <test@example.com>" and
 * returns the name as well as the email address.
 *
 * @param string $sender
 */
function getSender($sender) {
  $senderParts["name"] = $sender;

  if (($pos = strrpos($sender, "<")) && substr($sender, -1) == ">") {
    $senderParts["name"] = substr($sender, 0, $pos - 1);
    $senderParts["email"] = substr($sender, $pos);
  }

  $firstChar = substr($senderParts["name"], 0, 1);
  $lastChar = substr($senderParts["name"], -1);
  if ($firstChar == "\"" || $firstChar == "'") $senderParts["name"] = substr($senderParts["name"], 0);
  if ($lastChar == "\"" || $lastChar == "'") $senderParts["name"] = substr($senderParts["name"], 0, -1);

  return $senderParts;
}

function headerInfo($string) {
 $string = str_replace("filename = ", "filename=", $string);
 $lookingFor = array("contentType" => "Content-Type: ", "boundary" => "boundary=", "charSet" => "charset=", "name" => "name=", "contentTransferEncoding" => "Content-Transfer-Encoding: ", "contentDisposition" => "Content-Disposition: ", "fileName" => "filename=");
  $getValue = "[\"']?([^\"';\r]+)";
  reset($lookingFor);
  while (list($key, $value) = each($lookingFor)) {
    ereg("$value$getValue", $string, $matches);
    $info[$key] = $matches[1];
    unset($matches);
  }
  return $info;
}


function showInLine($contentType, $showImagesInLine = true) {
  $returnValue = false;
  $category = substr($contentType, 0, strpos($contentType, "/"));
  if ($category == "text" || $category == "message") $returnValue = true;
  if ($showImagesInLine) {
    $inLineImages = array("image/png", "image/jpeg", "image/gif");
    if (in_array($contentType, $inLineImages)) $returnValue = true;
  }
  return $returnValue;
}

function headerArray($header)
{
	$types = array(TYPETEXT => 'text', TYPEMULTIPART => 'multipart', TYPEMESSAGE => 'message',
			TYPEAPPLICATION => 'application', TYPEAUDIO => 'audio',TYPEIMAGE => 'image',
			TYPEVIDEO => 'video', TYPEOTHER => 'other',
			);
	$encodings = array(ENC7BIT => '7bit', ENC8BIT => '8bit', ENCBINARY => 'binary', ENCBASE64 => 'base64', 
			ENCQUOTEDPRINTABLE => 'quoted-printable', ENCOTHER => 'other',
			);
			
	$params = array('parameters', 'dparameters');
	$out = false;
	
	if(is_object($header))
	{
		$out = array();
		$out['type'] = $types[$header->type];
		if($header->ifsubtype)
		{
			$out['type'] .= '/' . strtolower($header->subtype);
		}
		$out['encoding'] = $encodings[$header->encoding];
		if($header->ifdisposition)
		{
			$out['disposition'] = strtolower($header->disposition);
		}
		$out['lines'] = $header->lines;
		$out['bytes'] = $header->bytes;
		
		foreach($params as $par)
		{
			$ifpar = "if" . $par;	
			if($header->$ifpar)
			{
				if( is_array($header->$par) )
				{
					$out[$par] = array();
					foreach($header->$par as $p)
					{
						$out[$par][strtolower($p->attribute)] = $p->value;
					}
				}
			}
		}
	}
	
	return $out;
}

/**
 * Decodes string (base64 & quoted_printable) 
 * + convert to current charset
 *
 * @param string $pcSubject
 * @return string 
 */
function decode_subject( $pcSubject )
{
  global  $lang_html_charset;
  global  $DEBUG;
  $lcReturnSubject = '';
  $laSubject       = array();
  $pcSubject       = str_replace(" =?",'#!#=?', $pcSubject);
  $laSubject       = explode('#!#', $pcSubject);

  foreach ($laSubject as $lcSubject) {
    
    if( preg_match_all( '/=\?(.*)\?(.)\?(.*)\?=/U', $lcSubject, $f ) ){
      
			if( strtolower( $f[2][0] ) == "b" ){
				$lcTmpSubject = base64_decode( $f[3][0] );
			} 
			
			if( strtolower($f[2][0]) == "q" ){
				$lcTmpSubject = quoted_printable_decode( $f[3][0] );
			}
    }
    
    $lcSubject = str_replace( $f[0][0], $lcTmpSubject, $lcSubject );
  	
    if( ( ! empty( $f[1][0] ) && ! empty( $lang_html_charset ) ) 
      && ( strtolower( $f[1][0] ) != strtolower( $lang_html_charset ) ) ){
        if( $DEBUG ){
          $lcTmp = iconv( $f[1][0], $lang_html_charset, $lcSubject ); 
        }else{
          $lcTmp = @iconv( $f[1][0], $lang_html_charset, $lcSubject ); 
        }
        if( ! empty( $lcTmp ) ){
          $lcReturnSubject.= $lcTmp;
        }else{
           $lcReturnSubject.= $lcSubject;
        }
  	} else {
        $lcReturnSubject.= $lcSubject;
  	}
  }
	return trim( $lcReturnSubject );
}

/**
 * Decodes mail body and process it
 *
 * @param string $body
 * @param string $type
 * @param string $encoding
 * @param string $pcEncoding
 */
function show_mail( $pcBody = '', $pcType = 'plain/text', $pcEncoding = '' , 
                    $pbReplaceLinks = true, $pbHtmlAlternative = false )
{
	global $lang_text, $id, $pid, $lang_html_charset, $page_size, $start_index;
  global $gcCurrentFolder;

	if( strpos( $pcEncoding, 'ascii' ) !== false ){
		$pcEncoding = $lang_html_charset; 
	}
		    
	if( ( ! empty( $pcEncoding ) && ! empty( $lang_html_charset ) ) && 
	     ( strtolower( $pcEncoding ) != strtolower( $lang_html_charset ) ) ){
      if( $lcTmpBody = @iconv( $pcEncoding, $lang_html_charset, $pcBody ) ){
        $pcBody = &$lcTmpBody;
      }
  	}
  
	if( $pcType != 'text/html' && $pcBody ){
		  $pcBody = wordwrap( $pcBody, 80 );
		  
		  if( $pbReplaceLinks ){
  			$pcBody = showBody( $pcBody, $pbReplaceLinks );
  			$pcBody = str_replace( "<br />", "<br>", $pcBody );
  			$pcBody .=  "\n";
		  }else{
		    $pcBody =  spec_htmlspecialchars( $pcBody );
		  }
	}
	if ( $pbHtmlAlternative ){
	      if( $pcBody ){
   			  $pcBody .=  '<hr noshade size=1>';
	      }
  			$pcBody .=  $lang_text["wbm_msg_htmlalert"].'<br />';
        $pcBody .=  "<a class=data href=email_message.php?id=$id".
                    "&pid=$pid&showHtml=1&folder=$gcCurrentFolder&start_index=$start_index&page_size=$page_size >".
                    "<b>&raquo; ".$lang_text["wbm_msg_htmlshow"]."</b></a>";
		}
	return $pcBody;
}
function show_part($body, $type, $pcEncoding = '')
{
  
	global $lang_text, $showHtml, $PHP_SELF, $id, $lang_html_charset,$liNewPid,$pid,$lcMailUniq, $mid,$gcCurrentFolder;

	if( strpos( $pcEncoding, 'ascii' ) !== false ){
		$pcEncoding = $lang_html_charset; 
	}
		    
	if ( ( ! empty( $pcEncoding ) && ! empty( $lang_html_charset ) ) && 
	     ( strtolower( $pcEncoding )!= strtolower( $lang_html_charset ) ) ) {
      if ($lcTmpBody = @iconv( $pcEncoding, $lang_html_charset, $body ) ) {
        $body = &$lcTmpBody;
      }
  	}
  	
 $body = wordwrap($body,80);
		$body = showBody($body, $pbReplaceLinks);
	$body_text = str_replace("<br />","<br>",$body);
			$echo_val =  "$body_text\n";
			
	return $echo_val;
}

/**
 * br2nl for use with HTML forms, etc.
 *
 * @param string $text
 * @return string
 */
function br2nl($text) {
    /* Remove XHTML linebreak tags. */
    $text = str_replace("<br />","",$text);
    /* Remove HTML 4.01 linebreak tags. */
    $text = str_replace("<br>","",$text);
    return $text;
}

/**
 * Convert special characters to HTML entities except '&' and "'"
 *
 * @param string $pcString
 * @return string
 */
function spec_htmlspecialchars( $pcString ) {
 return str_replace ( array ( '"', '<', '>' ), array ( '&quot;', '&lt;' , '&gt;' ), $pcString );
}

/**
 * Sorts array of messages by order and direction
 *
 * @param array $palist
 * @param string $pcOrder
 * @param string $pcdirection
 */
function &sortOfMessages(&$paArray, $pcOrder = 'subject', $pcDirection = 'asc') {
	if (is_array($paArray)) {
	$laTmp = array();
	$laOutPut = array();
	foreach ($paArray as $key => $value)
		$laTmp["".$key] = $value[$pcOrder];
	 	if (strtolower($pcDirection) == 'asc') {
			asort($laTmp);
	 	} else arsort($laTmp);
	 	$i = 0;
	foreach ($laTmp as $key => $value) {
		$laOutPut[$i] = $paArray[intval($key)];
		$i++;
	}
   return $laOutPut;
	}
}

/**
 * Message Functions
 *
 */
function Mail_IMAPv2_do_address_line( &$msg, &$mid, $line, $pbArrReturn = false ){
  $laReturn = array();
     
  if( ! empty( $msg->header[$mid][$line] ) ){
    foreach( $msg->header[$mid][$line] as $i => $address ){
      if( isset( $msg->header[$mid][$line.'_personal'][$i]) 
          && ! empty( $msg->header[$mid][$line.'_personal'][$i] ) )
      {
        $laReturn[$i] = $msg->header[$mid][$line.'_personal'][$i].
                       ' <'.$msg->header[$mid][$line][$i].'>';
      }else{
        $laReturn[$i] = $msg->header[$mid][$line][$i];
      }
    }
  }
  return $pbArrReturn ? $laReturn : implode( ', ', $laReturn );
}

function Mail_IMAPv2_do_parts( &$msg, &$mid, $disp ){
    global $giTmpId;
    global $lbStep;
    global $gaTmpId;
    global $loAttachData;
    global $lcMailUniq;
    global $gcCurrentFolder;

    $rtn = (string) '';
    
    $liAmount = 0;
    if( isset($msg->msg[$mid][$disp]['pid']) && count($msg->msg[$mid][$disp]['pid']) > 0 ){
        
      foreach( $msg->msg[$mid][$disp]['pid'] as $i => $inid ){
        
        $lcFName = decode_subject($msg->msg[$mid][$disp]['fname'][$i]);
        
        if( strpos($msg->msg[$mid][$disp]['ftype'][$i],"message") !== FALSE ){
          $lcType   = 'message';
          $lcFName .= '.eml';
        } 
        
    		$loAttachLink = $loAttachLink =  new CompoundDataField(
                    new FileIconDataField( $lcFName ),new HTMLDataField( $lcFName));
        $loAttachLink->SetSeparator(' ');
        $inline = 1;
        if( $lcType == 'message' ){
          $lcUrl = "email_message.php?id=".$mid."&amp;pid=".$msg->msg[$mid][$disp]['pid'][$i]
                                           ."&amp;folder=".$gcCurrentFolder;
        }else{
          $lcUrl = "email_attach.php?mid=".$mid."&amp;pid=".$msg->msg[$mid][$disp]['pid'][$i]
                   ."&amp;uniq=".$lcMailUniq."&amp;inline=".$inline."&amp;folder=".$gcCurrentFolder;          
        }
        $attach_link = new LinkDataField(  $lcUrl
                                           , ""
                                           , array()
                                           , $loAttachLink);
    		if ($inline) { 
    		  $attach_link->SetAttributes(array("target"=>"_blank"));
    		}
    		
    		$attach_link->AppendParentAttributes(array('width'=>'100%'));
    		$attach_field = new CompoundDataField();
    		$attach_field->SetSeparator(" ");
    		$attach_field->AppendToContent($attach_link);
    		$attach_field->AppendToContent(new HTMLDataField("(".sizeFormat($msg->msg[$mid][$disp]['fsize'][$i]).")"));
        $loAttachData->AppendToContent($attach_field);
        $liAmount++;
       }
    }
    return $liAmount;
}


function Mail_IMAPv2_do_parts2(&$msg, &$mid, $disp)
{
    global $giTmpid;
    global $gaTmpPid;
    global $loAttachData;
    global $lcMailUniq;
    global $pid;
    global $gcCurrentFolder;
    $i = $pid - 1;
    $rtn = (string) '';
    $laTmpPart = & $msg->structure[$mid]['obj']->parts[$i];

 		$loAttachLink =  new CompoundDataField(  new FileIconDataField( 
 		                     $laTmpPart->dparameters[0]->value ), new HTMLDataField( decode_subject($laTmpPart->dparameters[0]->value)));
    $loAttachLink->SetSeparator(' ');
    $inline = 1;
    $attach_link = new LinkDataField("email_attach.php?mid=".$mid."&amp;pid=".$pid
                                           ."&amp;uniq=".$lcMailUniq."&amp;inline=".$inline."&amp;folder=".$gcCurrentFolder
                                           , ""
                                           , array()
                                           , $loAttachLink);
    		
 		if ($inline) { 
   		  $attach_link->SetAttributes(array("target"=>"_blank"));
 		}
    		
 		$attach_link->AppendParentAttributes(array('width'=>'100%'));
 		$attach_field = new CompoundDataField();
 		$attach_field->SetSeparator(" ");
 		$attach_field->AppendToContent($attach_link);
 		$attach_field->AppendToContent(new HTMLDataField("(".sizeFormat($laTmpPart->bytes).")"));
    $loAttachData->AppendToContent($attach_field);
    return $liAmount;
}

/**
 * Recursiv function for determine size of multipart messages
 *
 * @param array $paParts
 * @param integer $piLevel 
 * @return integer
 */
function getMessageSize( $paParts, $piLevel ){
  
  $liCount = 0;

  if($piLevel <= 0 ){
    return;
  }

  foreach( $paParts as $loPart ){
    if( isset( $loPart->bytes ) ){
      $liCount += $loPart->bytes; 
    }elseif( is_array( $loPart->parts ) ){
      $liCount += getMessageSize( $loPart->parts, $piLevel - 1 );
    }
  }
  return $liCount;
}


?>
