<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.ReadOnlyDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.InputTextElement.php' );


global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "kunden_ssl.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><br>\n";
}


function chngActiveStatus( $pcKunde, $piActivate ){
	global $fehlertext;
	global $PHP_AUTH_USER, $ServerID;

	$liNeu = $piActivate?4:3;

	$loKunde = new SQLString($pcKunde);

	safe_query2( "UPDATE cssl SET neu=$liNeu WHERE kunde=? AND anbieter=? AND server_id='$ServerID'",
							 $loKunde, new SQLString($PHP_AUTH_USER) );

	safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loKunde );

	safe_query2( "UPDATE allgemein SET httpd=1, cssl=1 WHERE server_id='$ServerID'" );

}

switch($action){

 case 'create':
	 $action = '';
 case 'change':
	 include( 'kunden_ssl_erstellen.php' );
	 exit;
	 break;

 case 'activate':
	 $action = '';
	 chngActiveStatus( $kunde, 1);
	 break;

 case 'deactivate':
	 $action = '';
	 chngActiveStatus( $kunde, 0);
	 break;

 case 'gactivate':
 case 'gdeactivate':
 case 'delete':
	 if(is_array($users)){
		 include('kunden_ssl_group.php');
	 } else {
		 $fehlertext = ltext('ll_nothing');
	 }
	 break;
 }
## mysql verbindung aufbauen
db_connect($db_host, $db_user, $db_pass);
## /mysql verbindung aufbauen

$loUser = new SQLString( $PHP_AUTH_USER );
$id = safe_query2( "SELECT cssl FROM anbieter WHERE anbieter = ? AND server_id='$ServerID'", $loUser );
list($skssl) = db_fetch_array($id);
db_free_query( $id );

if( $skssl < 1 ){
	$fehlertext = ltext("kuss_error1");
	db_close();

	$page = new MainPageElement();
	$page->AppendToHelp( array( 'kuss_descr1', 'kuss_descr2' ) );
	$page->OutputHTML();

	exit();
 }

initPagingSettings( $_POST, array( 'to_find' => $to_find ) );

$id = safe_query2( "SELECT COUNT(kunde) FROM ipadressen WHERE anbieter = ? AND kunde != '' AND status=1 AND server_id='$ServerID'",
									 $loUser );
list($total_number) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( ! $total_number ){

	$fehlertext = ltext("kuss_nouserwithip");
	db_close();
	if( $confixx_interface_version == 'powp' ) {
		$url = "kunden_start.php?error_text=kuss_nouserwithip";
		header("Location: $url");
		newLocation( $url );

	} else {
		$page = new MainPageElement(  );
		$page->AppendToHelp( array( 'kuss_descr1', 'kuss_descr2' ) );
		$page->OutputHTML();
	}
	exit;
 }


$laParams = array( new SQLValue( $PHP_AUTH_USER, 'C' ) );

$lcFrom = " FROM ipadressen i ".
			" LEFT JOIN kunden k ON i.kunde=k.kunde  AND k.server_id=i.server_id".
			" LEFT JOIN domains d ON d.kunde=i.kunde  AND d.server_id=i.server_id".
			" LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id";
			
$lcFields = "SELECT i.ip, MIN(k.kunde) as kunde, MIN(k.name) AS name,MIN(k.firstname) AS firstname,".
			" MAX(k.number) AS number, ".
			" MAX(c.neu*4 + c.aendern*2 + c.loeschen) AS status ";
			
 if( isset( $to_find ) && strlen( $to_find ) ){
	if( $db_type == 'Pg' ){
		$lcSQL = "SELECT COUNT(i.ip) ".
			" FROM ipadressen i INNER JOIN kunden k ON i.kunde=k.kunde".
			" INNER JOIN domains d ON i.kunde = d.kunde AND d.richtigedomain=1 AND d.server_id=i.server_id".
			" LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id".
			" WHERE i.anbieter=? AND i.status=1 AND i.kunde!='' ".
			" AND (i.ip LIKE '%?%' OR k.name LIKE '%?%' OR k.kunde LIKE '%?%'".
			" OR d.domain LIKE '%?%') AND i.server_id='$ServerID' GROUP BY i.ip";
	}else{
			$lcSQL = "SELECT COUNT(i.ip) ".
			$lcFrom.
			" WHERE d.richtigedomain=1 ".
			" AND i.anbieter=? AND i.status=1 AND i.kunde!='' ".
			" AND (i.ip LIKE '%?%' OR k.name LIKE '%?%' OR k.kunde LIKE '%?%'".
			" OR d.domain LIKE '%?%')  AND i.server_id='$ServerID' GROUP BY i.ip";
	}

	array_push( $laParams, 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S')
						 );
		$loQuery = new SQLQuery( $lcSQL, $laParams );
  	
  	$loQuery->doQuery();
  	list( $total_number ) = $loQuery->fetchArray('N');
  	
  	if( $db_type == 'Pg' ){
  		$lcSQL = "SELECT i.ip, MIN(k.kunde) as kunde, MIN(k.name) AS name,MIN(k.firstname) AS firstname,".
  			" MAX(k.number) AS number, ".
  			" MAX(c.neu*4 + c.aendern*2 + c.loeschen) AS status ".
  			" FROM ipadressen i INNER JOIN kunden k ON i.kunde=k.kunde".
  			" INNER JOIN domains d ON i.kunde = d.kunde AND d.richtigedomain=1 AND d.server_id=i.server_id".
  			" LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id".
  			" WHERE i.anbieter=? AND i.status=1 AND i.kunde!='' ".
  			" AND (i.ip LIKE '%?%' OR k.name LIKE '%?%' OR k.kunde LIKE '%?%'".
  			" OR d.domain LIKE '%?%') AND i.server_id='$ServerID' GROUP BY i.ip";
	 }else{
			$lcSQL = $lcFields.$lcFrom.
			" WHERE d.richtigedomain=1 ".
			" AND i.anbieter=? AND i.status=1 AND i.kunde!='' ".
			" AND (i.ip LIKE '%?%' OR k.name LIKE '%?%' OR k.kunde LIKE '%?%'".
			" OR d.domain LIKE '%?%')  AND i.server_id='$ServerID' GROUP BY i.ip";
	}

 }else{
	if( $db_type == 'Pg' ){
		$lcSQL = "SELECT i.ip, k.kunde, k.name AS name,k.firstname AS firstname, k.number AS number, ".
			" c.neu*4 + c.aendern*2 + c.loeschen AS status ".
			" FROM ipadressen i INNER JOIN kunden k ON i.kunde=k.kunde AND k.server_id=i.server_id".
			" LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id".
			" WHERE i.anbieter=? AND i.kunde!='' AND i.server_id='$ServerID'";

	} else {
			$lcSQL = $lcFields.$lcFrom.
			" WHERE i.anbieter=? AND i.status=1 AND i.kunde!='' AND i.server_id='$ServerID' GROUP BY i.ip";
	}
 }
 
 
if( ! $order ){
	$order = 'user';
 }

if( $order ){
	switch($order){
	case 'name':
		$lcSQL .= " ORDER BY firstname";
		break;
	case 'ip':
		$lcSQL .= " ORDER BY ip";
		break;
	case 'status':
		$lcSQL .= " ORDER BY status";
		break;
	default:
		$lcSQL .= " ORDER BY number";
		$order = 'user';
		break;
	}
	if( $direction == 'desc' ) {
		$lcSQL .= ' DESC';
	}
 }
 
$loQuery = new SQLQuery( $lcSQL, $laParams );

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );

$loTemplate = new CompoundValue( new CompoundValue(new ValueFromArray('status'),
												   new ValueFromArray('kunde'),
												   new ValueFromArray('ip')),
								 new ValueFromArray('ip'),
								 new ValueFromArray('kunde'),
								 new CompoundValue(new ValueFromArray('firstname'),
												   new ValueFromArray('name')),
								 new ValueFromArray('kunde'), 
							     new CompoundValue(new ValueFromArray('status'),
												   new ValueFromArray('kunde'),
												   new ValueFromArray('ip' )),
								  new ValueFromArray( 'kunde' ));

$laContent = array();

if( $direction == 'desc' ){
	$lcDirIcon = cc_DescIcon;
	$lcNewDir = 'asc';
 } else {
	$lcDirIcon =  cc_AscIcon;
	$lcNewDir = 'desc';
 }

if( $order == 'status' ){
	$laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'kuss_cell_status' )),
																								new IconDataField( $lcDirIcon )
																								);
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'kuss_cell_status' ) );
 }

if( $order == 'user' ){
	$laContent['user'] = new CompoundDataField( new HTMLDataField( ltext( 'kuss_cell_user' )),
																								new IconDataField( $lcDirIcon )
																								);
	$laContent['user']->SetSeparator('');
 } else {
	$laContent['user'] = new HTMlDataField( ltext( 'kuss_cell_user' ) );
 }

if( $order == 'name' ){
	$laContent['name'] = new CompoundDataField( new HTMLDataField( ltext( 'kuss_cell_name' )),
																							new IconDataField( $lcDirIcon )
																							);
	$laContent['name']->SetSeparator('');
 } else {
	$laContent['name'] = new HTMlDataField( ltext( 'kuss_cell_name' ) );
 }


$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('users', this.checked)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle = new CompoundValue( new DataValue( 'status', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','status');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['status']
																																)
																						 ),
															new ValueLocale( 'kussdo_cell_ip' ),
															new DataValue( 'user', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','user');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['user']
																																)
																						 ),
															new DataValue( 'name', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','name');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['name']
																																)
																						 ),
															new ValueLocale( 'uss_cell_domains', 'Domains'),
															new ValueLocale( 'll_change' ),
															$loSelValue
															);


$laWidths = array( '5%','20%', '10%', '20%', '40%', '5%', '5%' );

$loDS->Template( $loTemplate );


//=====================================================================
//
// call back functions to make visible objects

function &createStatusIcon( $poSrc ) {

	global $DEBUG, $confixx_interface_version;

	$loValue =& $poSrc->Value(0);
	$liStatus = $loValue->Value();
	$loValue =& $poSrc->Value(1);
	$lcKunde = $loValue->Value();

	if(is_null($liStatus)){
		return new HTMLDataField('&nbsp;');
	}

	$lcBin = decbin( $liStatus );

	$liDel = substr( $lcBin, -1, 1);
	$liEdt = substr( $lcBin, -2, 1);
	$liNeu = bindec( substr( $lcBin, 0, -2 ) );

	if( $liDel == 1){
		$lcIcon = cc_StateDeleteIcon;
		$lcTitle = ltext('kuss_to_delete');
		$lcText = ltext('kuss_to_delete');

	}elseif( $liEdt == 1) {
		$lcIcon = cc_StateActivateIcon;
		$lcTitle = ltext('kuss_to_create');
		$lcText = ltext('kuss_to_create');

	}elseif( $liNeu == 2 ) {
		$lcIcon = cc_SSLDeactiveIcon;
		$lcTitle = ltext('kuss_crt_activate');
		$lcText = ltext('kuss_crt_activate');
		$lcAction = 'activate';

	}elseif( $liNeu == 3 ) {
		$lcIcon = cc_SSLStateDeactivateIcon;
		$lcTitle = ltext('kuss_to_deactivate');
		$lcText = ltext('kuss_to_deactivate');
		$lcAction = 'activate';

	}elseif( $liNeu == 4 ) {
		$lcIcon = cc_SSLStateActivateIcon;
		$lcTitle = ltext('kuss_to_activate');
		$lcText = ltext('kuss_to_activate');
		$lcAction = 'deactivate';

	}else{
		$lcIcon = cc_SSLActiveIcon;
		$lcTitle = ltext('kuss_crt_deactivate');
		$lcText = ltext('kuss_crt_deactivate');
		$lcAction = 'deactivate';
	}

	if ($confixx_interface_version == 'powp') {
		$loIcon = new IconDataField($lcIcon, array( 'alt' => $lcTitle, 'title' => $lcTitle));
	} else {
		$loIcon = new HTMLDataField($lcText);
	}
	if($lcAction){
		$loAction = new LinkDataField( "javascript:setValue('kunde','$lcKunde');".
																	 "submitForm('action','$lcAction')", 
																	 '', 
																	 array(), 
																	 $loIcon);
		$loAction->ParentAttribute( 'align', 'center' );
		$loAction->ParentAttribute( 'valign', 'middle' );
		return $loAction;
	} else {
		$loIcon->ParentAttribute( 'align', 'center' );
		$loIcon->ParentAttribute( 'valign', 'middle' );
		return $loIcon;
	}
}

$goDomains = new CompoundDBValue( " SELECT domain, richtigedomain FROM domains ".
                                  " WHERE richtigedomain IN (1,7) AND kunde=? ".
                                  " AND server_id='$ServerID' ORDER BY domain" );

$goFindDomains = new CompoundDBValue( " SELECT domain, richtigedomain FROM domains ".
                                      " WHERE richtigedomain IN (1,7) AND kunde=? ".
                                      " AND domain LIKE '%?%' AND server_id='$ServerID' ORDER BY domain" );

function &createDomainList( $pcKunde ) {
	global $goDomains, $goFindDomains;
	global $to_find;

	if( isset( $to_find ) && strlen( $to_find ) ){
		$goFindDomains->doQuery( array(new SQLValue( $pcKunde,'C' ),new SQLValue($to_find,'S')));
		$liCount = $goFindDomains->getCount();
		$loDS =& $goFindDomains;
	} else { 
		$liCount = 0;
	}
	if(!$liCount){
		$goDomains->doQuery( array( new SQLValue( $pcKunde,'C' ) ) );
		$loDS =& $goDomains;
	}

	$loColumn =& $loDS->getColumn(0);
  $loType =& $loDS->getColumn(1);

	if ( $loColumn->getCount() > 4 ) {
		$loColumn->keepLeft( 4 );
		$loColumn->addValue( new KeyValue( 'domain', '...' ) );
	}
	$loList = new CompoundDataField();
	$loIter =& $loColumn->getFirstIterator();
	$loTypeIter =& $loType->getFirstIterator();

  while(  $loItem =& $loIter->getNext() 
          && $loTypeItem =& $loTypeIter->getNext() ){
    if( $loTypeItem->Value() == 7 ){
      $loList->AppendToContent( new HTMLDataField( '<i>'.$loItem->Value().'</i>')); 
    }else{
		  $loList->AppendToContent( new HTMLDataField( $loItem->Value())); 
    }
	}
	$loList->SetSeparator( ', ' );

	return $loList;
}

function &createAction( $poSrc ) {
	global $confixx_interface_version;
	$loValue =& $poSrc->Value(0);
	$liStatus = $loValue->Value();
	$loValue =& $poSrc->Value(1);
	$lcKunde = $loValue->Value();


	if(is_null($liStatus)){
		$lcActionIcon = cc_CreateIcon;
		$lcTitle = ltext('kuss_link_new');
		$lcText = ltext('kuss_link_new');
		$lcAction = 'create';
	}else{
		$lcActionIcon = cc_ChangeIcon;
		$lcTitle = ltext('kuss_link_edit');
		$lcText = ltext('kuss_link_edit');
		$lcAction = 'change';
	}

	$loActions = new LinkDataField( "javascript:setValue('kunde','$lcKunde');".
																	"submitForm('action','$lcAction')", 
																	'', 
																	array(), 
																	($confixx_interface_version == 'powp')?new IconDataField( $lcActionIcon ):$lcText );
	$loActions->Attribute( 'title', $lcTitle );
	$loActions->ParentAttribute( 'align', 'center' );
	$loActions->ParentAttribute( 'valign', 'middle' );

	return $loActions;


}
function &createName($poSrc) 
{
	$lo_firstName = & $poSrc->Value(0);
	$lc_firstName = $lo_firstName->Value();
	$lo_lastName  = & $poSrc->Value(1);
	$lc_lastName  = $lo_lastName->Value();

	return new HTMLDataField($lc_firstName.' '. $lc_lastName);
}
// end call back functions
//
//============================================================


$loCheckBox = new CheckDataField( '', 'users[]');
$loCheckBox->ParentAttribute('align','center');
$loSelValue = new DataValue( 'kunde', $loCheckBox  );
$loSelValue->setTypeOfPresentation( 'Input' );

$loDS->Conversion( new CompoundValue( new ValueFormated( 'status', NULL, 'createStatusIcon' ),
																			NULL, ## IP
																			NULL, ## user
																	new ValueFormated( 'name', NULL, 'createName' ),
																			new ValueFormated( 'domains', NULL, 'createDomainList' ),
																			new ValueFormated( 'action', NULL, 'createAction' ),
																			$loSelValue
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'kunde', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if (isset($to_find)&&strlen($to_find)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}
$loPTV->Anchor( 'list' );
$loPTV->FormIndex(0);

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_ssl.php#list',
																						 'name' => 'list_ssl' ), 
																			ltext( "mk_ssl" ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'to_find', $to_find ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_find', 
																																	'size' => '16',
																																	'value' => $to_find,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );


$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1)", 
																							 'bid-search' 
																							 )
														);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_find','');".
																							 "submitForm('start_index',1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('ll_activate');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','gactivate')",
																								'bid-ssl-activate'
																								)
													 );
$head_text = ltext('ll_deactivate');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','gdeactivate')",
																								'bid-ssl-deactivate'
																								)
													 );

$head_text = ltext('ll_delete');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','delete')",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'to_find' => $to_find ) );


if ((isset($to_find)&&strlen($to_find))||$total_number>0) {
		$tbl->setSearchElement( $loSearch );
}
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();

$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );


/* -------------------- end HTML -------------------- */
?>
