<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );/*{{{*/
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/class.HOStates.php' );
include_once( 'defines.php' );
/*}}}*/

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_httpd_domain.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

$db =& get_db_connection();

$loServerID = new SQLString( $ServerID );
$loReseller = new SQLString( $anbieter );
$loUser     = new SQLString( $PHP_AUTH_USER );

if( $confixx_interface_version == 'powp' ) {
	$loPathBar = new PathBar();
	$laFirstItem = array('main_menu_page' => 'einstellungen_httpd_domain.php',
											 'head_id' => 'httpd_spec_domain',
											 'head_text' => ltext('eihtdo_cell_domain'),
											 'menu_node_id' => 'menu_node_httpd_spec_domain'
											 );
	$loPathBar->pushPathBar( $laFirstItem );
 }

initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search ) );

$lcSQL = " SELECT COUNT(*) FROM domains WHERE richtigedomain ".
         " NOT IN (5,7) AND anbieter = ? AND kunde=? AND server_id=?";

$res = safe_query2( $lcSQL, $loReseller, $loUser,  $loServerID );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

/**
 * Search
 */
if( isset( $name_to_search ) && strlen( $name_to_search ) ) {

  $loName = new SQLValue( $name_to_search, 'S' );

  $lcSQL = " SELECT COUNT(*) FROM domains WHERE server_id=?".
           " AND richtigedomain NOT IN (5, 7) AND anbieter =? AND kunde=? AND ".
      	   " ( domain LIKE '%?%' )";
	$loQuery = new SQLQuery( $lcSQL, array( $loServerID, $loReseller, $loUser, $loName  ) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');
	$loQuery->finish();

  $lcSQL = " SELECT domain, anbieter, kunde, id ".
           " FROM domains WHERE server_id=? AND anbieter=? AND kunde=? AND richtigedomain NOT IN( 5,7) AND".
       	   " ( domain LIKE '%?%' ) ORDER BY kunde,id";
	$loQuery->Query( $lcSQL );

}else{
  /**
   * Usual list
   */
	$lcSQL = " SELECT domain, anbieter, kunde, id FROM domains ".
	         " WHERE richtigedomain NOT IN (5,7)  AND server_id=? AND anbieter =? AND kunde=? ORDER BY kunde,id";

	$loQuery = new SQLQuery( $lcSQL, array( $loServerID, $loReseller, $loUser ) );
 }

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'domain' ),
                                 new ValueFromArray( 'id' ),
                                 new ValueFromArray( 'domain' )
                                );

$loTitle = new CompoundValue( new ValueLocale( 'eihtdosu_cell_domain' ),
															new ValueLocale( 'httpd_options' ),
															new ValueLocale( 'll_change' )
															);

$laWidths = array( '50%', '40%', '10%' );

$loDS->Template( $loTemplate );

/**
 * Functions to make visible objects
 */

$gcView = ltext( 'eihtdosu_preview' );

function &makeDomainLink( $pcDomain ){/*{{{*/
	global $gcView;
	$loLink = new LinkDataField( 'http://'.$pcDomain, '', array(), new HTMLDataField( $pcDomain ) );
	$loLink->Attribute( 'target', 'view_domain' );
	//	$loLink->Attribute( 'title',  $gcView );

	return $loLink;
}/*}}}*/

function &makeOptions( $piId ){/*{{{*/
  global $ServerID;
  global $anbieter;
  global $PHP_AUTH_USER;

  $laOptions = array();
  $laOptions2 = array();
  $laOptionsFull = array();
  $liMax = 50;
  $lbFlag = true;
  $loHOptions = new HOStates( $ServerID, $anbieter, $PHP_AUTH_USER );
  $laOptions = $loHOptions->getOptionsForDomain( $piId );
  
  foreach( $laOptions as $liId => $laOption ){
    $lcTmp = $laOption['label'].'('.$laOption['state']['label'].')';
    $laOptionsFull[] = $lcTmp;
    if( strlen( $lcTmp ) < $liMax && $lbFlag ){
      $laOptions2[] = $lcTmp;
      $liMax -= strlen( $lcTmp );
    }elseif( $lbFlag ){
      $laOptions2[] = '...';
      $lbFlag = false;
    }
  }
	$loRet = new HTMLDataField( implode( ', ', $laOptions2 ), 
                              false, 
                              array(), 
                              array( 'title'=> implode(", \n",$laOptionsFull ) ) );
	return $loRet;
}/*}}}*/

$gcChange = ltext( 'eiht_cell_domain' );
$gcOn = ltext( 'll_on' );
$gcOff = ltext( 'll_off' );

function &makeStatusLink( $pcDomain ){/*{{{*/
	global $gcChange, $gcOn, $gcOff;
	global $confixx_interface_version;

	if( $confixx_interface_version == 'powp' ) {
		$loCnt = new IconDataField( cc_ChangeIcon );
	} else {
		$loCnt = new HTMLDataField( $gcOff );
	}


	$loLink = new LinkDataField( 'einstellungen_httpd_domain_aendern.php',
															 '',
															 array('domain' => $pcDomain),
															 $loCnt
															 );
	$loLink->Attribute( 'title', $gcChange );
	$loLink->ParentAttribute( 'align', 'center' );

	return $loLink;
}/*}}}*/

function &makeSpecialView( $pcSpecial ){/*{{{*/
	if($pcSpecial){
		$laLines = explode( "\n", $pcSpecial );
		if(count($laLines) > 2){
			array_splice($laLines,2);
			array_push($laLines,'...');
		}
		$loSpec = new CompoundDataField();
		$loSpec->SetSeparator("<br>\n");
		foreach($laLines as $lcLine){
			$loSpec->AppendToContent( new HTMLDataField( $lcLine ) );
		}
		return $loSpec;
	} else {
		return new HTMLDataField('');
	}
}/*}}}*/



$loDS->Conversion( new CompoundValue( new ValueFormated( 'domain', NULL, 'makeDomainLink' ),
																			new ValueFormated( 'httpd_options', NULL, 'makeOptions' ),
																			new ValueFormated( 'chnage', NULL, 'makeStatusLink' )
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );

$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex(0);

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'einstellungen_httpd_domain.php#list',
																						 'name' => 'list_res' ), 
																			ltext( 'eiht_cell_domain' ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
																 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $name_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,0)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name_to_search','',0);submitForm('start_index',1,0)", 
																							 'bid-show-all'
																							 ) 
													);

$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search ) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();
	
$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );


?>
