<?
include_once( "../ftplogin/ftp_config.php" );
include_once( "../ftplogin/ftp_functions.php" );
include_once( "../ftplogin/ftp_class.php" );

function checkURL( $pcURL ){
	$laItems = split( ':', $pcURL, 2);
	$lcProt = 'ftp';

	if( count( $laItems ) > 1 ){
		$lcProt = $laItems[0];

		if( preg_match( '/^ftp$/i', $lcProt ) ) {
			$pcURL = $laItems[1];
			
		} elseif( $lcProt) {
			return NULL;
		}
	}

	if( preg_match( '/^\/+/', $pcURL, $laMatchs ) ) {

		if( $laMatchs[0] == '//' ) {
			$pcURL = substr( $pcURL, 2 );

		}else{
			return NULL;
		}
	}

	$laItems = split( '@', $pcURL, 2);

	if(	count($laItems) == 2 ){
		$lcUserPass = $laItems[0];
		$pcURL = $laItems[1];
		$laItems = split( ':', $lcUserPass );
		if( count( $laItems ) > 2  ){
			return NULL;
		}
	}

	$lcRet = $lcProt.'://';
	if( $lcUserPass ){
		$lcRet .= $lcUserPass.'@';
	}
	
	$lcRet .= $pcURL;

	return $lcRet;
}

function checkFtpConnection() {
	global $DEBUG;
	global $check_url, $backup_url, $backup_paswd;
	global $fehlertext;
	global $PHP_AUTH_USER;
	global $ftp_host;
	global $ServerID;

	$loUser = new SQLString( $PHP_AUTH_USER );

	if( $check_url ) {
	
		if( $backup_url ){

			if ( $lcURL = checkURL( $backup_url ) ) {

				$laURL = parse_url( $lcURL );

			/*
			echo "URL-parsing: <br><pre>\n";
			print_r($laURL);
			echo "</pre><hr>\n";
			*/
				if( array_key_exists( 'pass', $laURL ) ){
					$backup_paswd = $laURL['pass'];
				}

				if( ( $laURL['host'] == $ftp_host ) && ! $backup_paswd ){
					// password is chenged or user is not fully created
					$fehlertext = ltext('tobk_err_no_paswd');
					return;
				}

				$ftp = new ftp( $DEBUG );
		
				if($ftp->ftp_connect( $laURL['host'] ) ) {

					if($ftp->ftp_login($laURL['user'], $backup_paswd)){
						safe_query2("UPDATE kunden SET backup_url=?, backup_paswd=? WHERE kunde=? AND server_id='$ServerID'",
												new SQLString($backup_url), new SQLString($backup_paswd), $loUser );
						$fehlertext = ltext('tobk_login_success',$laURL['user'], $laURL['host']).
							'<br>'.ltext("alfr2_error7");
						
						if($laURL['path']){
							if(strstr($laURL['path'],'~')){
								$laChunks = explode( '~/', $laURL['path'], 2);
								$path = "$laChunks[1]";
							}else{
								$path = $laURL['path'];
							}
							if($path){
								if(!$ftp->ftp_chdir( $path ) ){
								$fehlertext .= '<br>'.ltext('tobk_err_chdir',$laURL['path']);
								}
							}
						}
					} else {
						$fehlertext = ltext('tobk_err_login',$laURL['user'], $backup_paswd);
					}
			
					$ftp->ftp_quit();

				}else{
					$fehlertext = ltext('tobk_err_connect',$laURL['host']);
				}
			} else {
				$fehlertext = ltext('tobk_err_url',$backup_url);
			}
		} else {
			$fehlertext = ltext('tobk_err_url',$backup_url);
		}

	} else {
		safe_query2("UPDATE kunden SET backup_url=?, backup_paswd=? WHERE kunde=? AND server_id='$ServerID'",
								new SQLString($backup_url), new SQLString($backup_paswd), $loUser );
		$fehlertext = ltext("alfr2_error7");
	}
}

function prepareSource( $src, $dst, &$laSources, &$laURL ){

	global $ftp_host;
	global $DEBUG;
	global $PHP_AUTH_USER;
	global $options;
	global $ServerID;

	/*
	if($DEBUG){
		echo "prepareSource: user: $PHP_AUTH_USER<br><pre>\n";
		print_r($_SESSION);
		echo "</pre><hr>\n";
	}
	*/

	$id = safe_query2( "SELECT pw,neu FROm kunden WHERE kunde=? AND server_id='$ServerID'", 
										 new SQLString( $PHP_AUTH_USER ) );
	list($pw,$neu) = db_fetch_array($id,'N');
	if( $pw || $neu ){
		$lcPass = ''; // password is changed or user is not fully created
	} else {
		$lcPass = $_SESSION['_users'][$ServerID][$PHP_AUTH_USER]['password'];
	}
	db_free_query( $id );

	switch($src){
	case 'backup':
	case '/backup':
		if(array_key_exists($ftp_host, $laSources)){
			$laSources[$ftp_host][1][] = 'backup';
			$laSources[$ftp_host][2][] = $dst;

		}else{
			$laSources[$ftp_host] = array( array( $PHP_AUTH_USER, $lcPass ),
																		 array('backup'),
																		 array($dst) );
		}

		break;
	case 'restore':
	case '/restore':
	case '':
		if(array_key_exists($ftp_host, $laSources)){
			$laSources[$ftp_host][1][] = 'restore';
			$laSources[$ftp_host][2][] = $dst;

		} else {
			$laSources[$ftp_host] = array( array( $PHP_AUTH_USER, $lcPass ),
																		 array( 'restore'),
																		 array( $dst ) );
		}

		break;
	default:
		if(is_array($laURL)){
			if(array_key_exists('path',$laURL)){
				$laURL['path'] = prepareTildaPath($laURL['path']);
			}else{
				$laURL['path'] = '';
			}

			if(array_key_exists( $laURL['host'], $laSources ) ) {
				$laSources[$laURL['host']][1][] = prepareTildaPath($laURL['path']);
				$laSources[$laURL['host']][2][] = $dst;

			}else{
				$laSources[$laURL['host']] = array( array( $laURL['user'], 
																									 array_key_exists('pass',$laURL)?$laURL['pass']:$options['backup_paswd']),
																						array( prepareTildaPath($laURL['path'] )),
																						array( $dst ) );
			}
		}else{
			if(array_key_exists($ftp_host, $laSources)){
				$laSources[$ftp_host][1][] = 'restore';
				$laSources[$ftp_host][2][] = $dst;

			} else {
				$laSources[$ftp_host] = array( array( $PHP_AUTH_USER, $lcPass ),
																			 array( 'restore'),
																			 array( $dst ) );
			}
		}
	}
	/*	
	echo "prepareSource: return <br><pre>\n";
	print_r($laSources);
	echo "</pre><hr>\n";
	*/
}

function &getFileDates( &$laSources ){
	global $DEBUG;
	global $fehlertext;
	global $ftp_host;

	$laRet = array();
	
	$ftp = new ftp( $DEBUG );

	$no_paswd = 1;
	foreach ( $laSources as $host => $laParams ){ // loop by hosts

		list($user,$pass) = $laParams[0];

		if( ( $host == $ftp_host ) && ! $pass ){ 
			// password is changed or user is not fully created
			if( $no_paswd ){
				$no_paswd = 0;
				$fehlertext .= ltext('tobk_err_no_paswd');
			}
			continue;
		}

		if(!$ftp->ftp_connect( $host ) ) { // connect
			$fehlertext .= ltext('ftp_no_connect',array($host))."<br>\n";
			continue;
		}

		if($DEBUG){
			echo "getFileDates: <br><pre>\n";
			print_r($laParams);
			echo "</pre><hr>\n";
		}

		if( !$ftp->ftp_login( $user, $pass ) ) { // login
			$fehlertext .= ltext('ftp_no_login',array( $host, $user ) )."<br>\n";
			$ftp->ftp_quit();
			continue;
		}

		if(!array_key_exists( $host, $laRet ) ){
			$laRet[$host] = array();
		}

		$laPath = $laParams[1];
		$laName = $laParams[2];

		$cnt = count( $laPath );

		$laCache = array();
				
		for( $ind = 0; $ind<$cnt; $ind++ ){ 
// loop by dir

			$lcPath = prepareTildaPath($laPath[$ind]); // current dir
			if(strstr($lcPath,'~')){
				list($lcSkip,$lcPath) = explode('~/',$lcPath);	 
			}
			$lcName = $laName[$ind];

					/*
					if($DEBUG){
						echo "getFileDates: $ind: path: $lcPath, name: $lcName<br>\n";
					}
					*/

			if(array_key_exists($lcPath, $laCache)){
				$laDir = $laCache[$lcPath];
			}else{
				$laLS = $ftp->ftp_rawlist( $lcPath );
				$laDir = parse_ftp_rawlist( $laLS ); 
				$laCache[$lcPath] = $laDir;
			}

			if( !array_key_exists($lcPath,$laRet[$host])){
				$laRet[$host][$lcPath] = array();
			}

			$liCnt = count($laDir);

			// get file's info

			if( $lcName == '*' ){ // get list of all backups
				foreach ( array('html','files','mysql') as $lcName ){
					for($j=1; $j<=$liCnt; $j++){
						if( $laDir[$j]['name'] == $lcName.'.tar.gz' ||
								$laDir[$j]['name'] == $lcName.'.tgz' ){

									
							$laRet[$host][$lcPath][$lcName] = array( $laDir[$j]['date'], 
																											 $laDir[$j]['name'],
																											 $laDir[$j]['size']
																											 );
						}
					}
				}
			}else{
				for($j=1; $j<=$liCnt; $j++){
					$lcDirName = $laDir[$j]['name'];
					/*
					 if($DEBUG){
					 echo "j: $j, dir name: $lcDirName, name: $lcName<br>\n";
					 }
							*/
					if( $lcDirName == $lcName.'.tar.gz' ||
							$lcDirName == $lcName.'.tgz' ){
						
 
								
						$laRet[$host][$lcPath][$lcName] = array( $laDir[$j]['date'], 
																										 $laDir[$j]['name'],
																										 $laDir[$j]['size']
																										 );
					}
				}
			}
		}

		$ftp->ftp_quit();
		
	}

	/*
	if($DEBUG){
		echo "getFileDates: return<br><pre>\n";
		print_r($laRet);
		echo "</pre><hr>\n"; 
	}
	*/

	return $laRet;
}

function prepareTildaPath( $pcSrc ){
	if(strstr($pcSrc,'~')){
		list($lcSkip,$pcSrc) = preg_split( '/~\/?/', $pcSrc, 2);
	}
	return $pcSrc;
}

function prepareDestination( $dst, $src, &$laSources, &$laURL ){

	global $ftp_host;
	global $DEBUG;
	global $PHP_AUTH_USER;
	global $options;
	global $ServerID;

	/*
	if($DEBUG){
		echo "prepareSource:src: $src, dst: $dst<br>\n";
	}
	*/

	$id = safe_query2( "SELECT pw,neu FROM kunden WHERE kunde=? AND server_id='$ServerID'", 
										 new SQLString( $PHP_AUTH_USER ) );
	list($pw,$neu) = db_fetch_array($id,'N');
	if( $pw || $neu ){
		$lcPass = ''; // password is changed or user is not fully created
	} else {
		$lcPass = $_SESSION['_users'][$ServerID][$PHP_AUTH_USER]['password'];
	}
	db_free_query( $id );

	switch($dst){
	case 'backup':
	case '/backup':
	case '':
		if(array_key_exists($ftp_host, $laSources)){
			$laSources[$ftp_host][1][] = 'backup';
			$laSources[$ftp_host][2][] = $src;

		}else{
			$laSources[$ftp_host] = array( array( $PHP_AUTH_USER, $lcPass ),
																		 array('backup'),
																		 array($src) );
		}

		break;
	default:
		if(is_array($laURL)){
			if(!array_key_exists('path',$laURL)){
				$laURL['path'] = '/';
			}
			if(array_key_exists( $laURL['host'], $laSources ) ) {
				$laSources[$laURL['host']][1][] = prepareTildaPath( $laURL['path'] );
				$laSources[$laURL['host']][2][] = $src;
				
			}else{
				$laSources[$laURL['host']] = array( array( $laURL['user'], 
																									 array_key_exists('pass',$laURL)?$laURL['pass']:$options['backup_paswd']),
																						array( prepareTildaPath( $laURL['path'] )),
																						array( $src ) );
			}
		}else{
			if(array_key_exists($ftp_host, $laSources)){
				$laSources[$ftp_host][1][] = 'backup';
				$laSources[$ftp_host][2][] = $src;

			}else{
				$laSources[$ftp_host] = array( array( $PHP_AUTH_USER, $lcPass ),
																			 array('backup'),
																			 array($src) );
			}
		}
	}

	/*		
	echo "prepareDestination: return <br><pre>\n";
	print_r($laSources);
	echo "</pre><hr>\n";
	*/

}

function prepSize( $piSize, $pcSep="'" ){
	$lcRet = '';
	while( strlen($piSize)>3 ){
		$lcSuf = substr( $piSize, -3, 3 );
		$piSize = substr( $piSize, 0, -3 );
		if( $lcRet ){
			$lcRet = $lcSuf.$pcSep.$lcRet;
		} else {
			$lcRet = $lcSuf;
		}
	}
	if( $lcRet ){
		$lcRet = $piSize.$pcSep.$lcRet;
	} else {
		$lcRet = $piSize;
	}
	
	return $lcRet;
}

?>