<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLInteger.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/class.SQLFieldSet.php' );
include_once( '../include/event_functions.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/class.HOStates.php' );

global $DEBUG;
//$DEBUG=1;

db_connect($db_host, $db_user, $db_pass);

if( $DEBUG ){
	echo "tools_domains_neu.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}


$timestamp = time();

$prefix = strtolower($prefix);
$domain = strtolower($domain);
$neuedomain = $prefix . '.' . $domain;

if( is_int( strpos( $neuedomain, '*' ) ) ){
	$cssl = 0;
	$cssl_redirect = 0;
}


if( isset( $create_dir ) && ! $create_dir  ){
	$fehlertext = ltext( 'todone_domain_skip', $neuedomain );
	db_close();
	include( 'tools_domains.php' );
	exit();
 }


$loUser = new SQLString( $PHP_AUTH_USER );

$id = safe_query2( " SELECT maxsubdomains, anbieter, wildcard, httpdspezial ".
                   " FROM kunden WHERE kunde = ? AND server_id='$ServerID'",
                  $loUser);
$werte = db_fetch_array($id);
$maxsubdomains = $werte["maxsubdomains"];
$anbieter = $werte["anbieter"];
$wildcard = $werte["wildcard"];
$httpdspezial = $werte["httpdspezial"];

$id = safe_query2( " SELECT COUNT(domain) FROM domains WHERE richtigedomain=0 ".
                   " AND kunde = ? AND server_id='$ServerID'",
                 $loUser );
list($genutztesubdomains) = db_fetch_array( $id );
if ($maxsubdomains != -1) { 
	$freiesubdomains = $maxsubdomains - $genutztesubdomains; 
} else { 
	$freiesubdomains = -1; 
}

if( $wildcard > 0 ){
  $id = safe_query2( " SELECT COUNT(domain) FROM domains WHERE domain LIKE '*.%' ".
                     " AND kunde = ? AND server_id='$ServerID'",
	                    $loUser );
	list($wildcards) = db_fetch_array( $id );
}

if( ( $freiesubdomains < 1 ) && ( $freiesubdomains != -1 ) ){
	$fehlertext = ltext( 'todone_error1' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if ( ( ( istleer( $prefix ) ) || 
			 ( ereg( '[.-]$',  $prefix ) ) || 
			 ( ereg( '^[.-]', $prefix ) ) || 
			 ( ereg( '[.]{2}', $prefix ) ) || 
			 ( ereg( '[^a-zA-Z0-9.-]', $prefix ) )
			 ) && ($prefix != '*') )	{
	$fehlertext = ltext( 'todone_error2' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if( ( $prefix == '*' ) 
    && ( ( $wildcard == 0 ) || ( $wildcards >= $wildcard ) ) 
    && ( $wildcard != -1 ) ){
	$fehlertext = ltext( 'todone_error3' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}


if( istleer( $domain ) ){
	$fehlertext = ltext( 'todone_error4' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if( ( ereg( ' ', $domain ) ) || ( ereg( ' ', $pfad ) ) ){
	$fehlertext = ltext( 'todone_error5' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if( istleer( $pfad ) ){
	$fehlertext = ltext( 'todone_error6' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}
	
if( ereg( "[\n\t\r]", $pfad ) ){
	$fehlertext = ltext( 'todone_error8' );
	db_close();
	include( 'tools_domains.php' );
	 exit();
}
		
if( ( ( ! ereg( '^/', $pfad ) ) &&
			( ! ereg( '^http[s]?://', $pfad ) ) 
			) ||
		( ereg( "/\.\.", $pfad ) ) ){
	$fehlertext = ltext( 'todone_error7' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if( ( ( preg_match( '/[.]{2}/', $pfad ) ) ||
			( preg_match( '/[^a-zA-Z0-9\.\/~\-\?=&_]/', $pfad ) )
			)	&&
		( ! preg_match( '/^http[s]?:\/\//', $pfad ) ) ){
	$fehlertext = ltext( 'todone_error8' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

if( ereg( '[\\]', $pfad ) ){
	$fehlertext = ltext( 'todone_error9' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

$loDomain = new SQLString( $domain );
# existiert die domain
$id = safe_query2( " SELECT grp, richtigedomain FROM domains WHERE domain = ? ".
                   " AND kunde = ?  AND server_id='$ServerID'",  
									 $loDomain, $loUser );
if( db_num_rows( $id ) < 1 ){
	db_free_query( $id );
	$fehlertext = ltext( 'todone_error10', array( $domain ) );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

list( $liGrp, $liDomType ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( $liDomType == 7 && $prefix == '*' ){
	$fehlertext = ltext( 'todone_error14' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}

# sub-domain schon da?
$loNewDomain = new SQLString( $neuedomain );
$id = safe_query2( "SELECT COUNT(domain) FROM domains WHERE domain = ?",
									 $loNewDomain );
list($count) = db_fetch_array($id);
db_free_query( $id );

if( $count > 0 ){
	$fehlertext = ltext( 'todone_error11' );
	db_close();
	include( 'tools_domains.php' );
	exit();
}
# /sub-domain schon da?

## //

if( ( ereg( '/$', $pfad ) ) && 
		( $pfad != '/') && 
		( ereg( '^/', $pfad ) ) ){ 
	$pfad = substr( $pfad, 0, -1 ); 
}

if( ereg( '^/', $pfad ) &&
		( $pfad != '/')	){ /* a dir */

	$exec = $bindir."/lsdir.pl $PHP_AUTH_USER/html/$pfad -cd";
	system( $exec, $return );
	
	if( $return == 2 ){
		$fehlertext = ltext( 'todone_err_not_dir', array( $pfad ) );
		db_close();
		include( 'tools_domains.php' );
		exit();
	}
	if( $return == 1 && ! isset( $create_dir ) ){
		$data = new SetOfRowsData();

		$data->AppendRow( new HTMLDataField( ltext( 'todone_dir_create', array($pfad)) 
																			 ), 
											new YesNoDataField( array( 1 => ltext('g_yes')), 
																					array( 0 => ltext('g_no')), 
																					'1', 
																					'create_dir',
																					cc_RadioGroupPresentation 
																					)
											);
		$data->AppendButton( ltext( 'll_apply' ),
												 "javascript:doChange()",
												 cc_IDOk );
		$data->AppendHidden( new TextDataField( $pfad, 'pfad' ) );
		$data->AppendHidden( new TextDataField( $prefix, 'prefix' ) );
		$data->AppendHidden( new TextDataField( $domain, 'domain' ) );
		if( isset( $cssl ) ){
			$data->AppendHidden( new TextDataField( $cssl, 'cssl' ) );
		}
		if( isset( $cssl_redirect ) ){
			$data->AppendHidden( new TextDataField( $cssl_redirect, 'cssl_redirect' ) );
		}

		$form = $data->GetInputPresentation( array( 'action' => 'tools_domains_neu.php',
																								'method' => 'post', 
																								'name' => 'form1'  ) 
																				 );

		$page = new MainPageElement( $form );
		$page->OutputHTML();
		
		exit();
	}
	
 }

$loFields = new SQLFieldSet( array( 'domain' => array( $neuedomain, 'C' ),
																		'kunde' => array( $PHP_AUTH_USER, 'C' ),
																		'anbieter' => array( $anbieter, 'C' ),
																		'pfad' => array( $pfad, 'C' ),
																		'richtigedomain' => 0,
																		'zusatz' => array( $httpdspezial, 'C' ),
																		'server_id' => array( $ServerID, 'C' ),
																		'grp' => $liGrp,
																		'cssl' => ($cssl_redirect? 2: $cssl)
																		)
														 );
list($lcFlds,$lcVals) = $loFields->getSQLInsert();
db_query( "INSERT INTO domains ( $lcFlds ) VALUES ( $lcVals )" );  

$loHOStates = new HOStates( $ServerID, $anbieter, $PHP_AUTH_USER );
$loHOStates->setDefaultsForDomain( $neuedomain );

## lastchange fuer hauptdomain aendern
$timestamp = time();
safe_query2( "UPDATE domains SET lastchange = ? WHERE domain = ?  AND richtigedomain=1 AND kunde = ?  AND server_id='$ServerID'", 
						 new SQLInteger( $timestamp ), $loDomain, $loUser );
## // lastchange fuer hauptdomain aendern

domain_aendern( $neuedomain, 'anlegen', $PHP_AUTH_USER );
fpalias_aendern( $neuedomain, 'anlegen', $PHP_AUTH_USER );

safe_query2( "UPDATE allgemein SET httpd=1,webalizer=1 WHERE server_id='$ServerID'" );
safe_query2( "UPDATE kunden SET changedomains=1, httpd=1 WHERE kunde = ? AND server_id='$ServerID'", $loUser );

set_countdomains( $PHP_AUTH_USER );

$id = safe_query2( "SELECT COUNT(*) FROM webalizer WHERE neu=1 ".
									 " AND server_id='$ServerID' AND kunde=? ",
									 $loUser
									 );
list( $cnt ) = db_fetch_array( $id, 'N' );
db_free_query( $id );
if( ! $cnt ){
	safe_query2( "INSERT INTO webalizer( loeschen, neu, server_id ,kunde, anbieter)".
							 " VALUES( 0, 1, '$ServerID', ?, ? )",
							 $loUser, new SQLString( $anbieter ) );
 }



/**
 * Add event to AWstats
 */
$id = safe_query2("SELECT awstats FROM kunden WHERE kunde=? AND server_id='$ServerID'",
									$loUser);
list($liIsSetAwstats) = db_fetch_array( $id );
db_free_query( $id );		

if ($liIsSetAwstats == 1) {
  eventAdd($OBJECT_STAT, $EVENT_CHANGE, $PHP_AUTH_USER);
}

$pfad = ''; ##reset fuer tools_domain.php
$prefix = '';

$fehlertext = ltext( 'todone_error12', array( $neuedomain ) );
$fehlertitel = ltext( 'todone_error13' );
db_close();


include( 'tools_domains.php' );

?>
