<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );
include_once( '../include/class.User.php' );

global $DEBUG;
//$DEBUG=1;

db_connect($db_host, $db_user, $db_pass);

$loConfixxUser = new User( $PHP_AUTH_USER, $ServerID );

if( ! $loConfixxUser->isServiceEnabled( 'password_protect' ) ){
  $fehlertext = ltext( 'service_is_disabled' );
  include 'allgemein_start.php';
  exit;
}

if( istleer( $pfad ) )	{
	$fehlertext = ltext("topwne2_error1");
	include("tools_pwschutz_neu.php");
	exit();
 }

$pfad = preg_replace( '/\/+$/', '', $pfad );
$pfad = preg_replace( '/^\/+/', '', $pfad );
$pfad = preg_replace( '/\/+/', '/', $pfad );

if( substr($pfad, 0, 1) != "/") {
	$pfad = "/".$pfad;
 }
$dir = "/$PHP_AUTH_USER/html".$pfad;

exec($bindir."/lsdir.pl ".escapeshellarg( $dir ), $devnull, $status);

if( ( $status != 0 ) || 
		preg_match("/\.\.(\/|$)/", $pfad ) 
		){
	$fehlertext = ltext("topwne2_error2", array( $pfad ));
	include("tools_pwschutz_neu.php");
	exit();
 }

if ((ereg("[^A-Za-z0-9 ]", $bereich)) || (strlen($bereich) > 20))	{
	$fehlertext = ltext("topwne2_error3");
	include("tools_pwschutz_neu.php");
	exit();
									}

if( $bereich == '' ) { // to prevent error500
	$bereich = "secure";
}

if( ( ereg("[^A-Za-z0-9 ]", $login)) || 
		( strlen( $login ) > 35 ) )	{
	$fehlertext = ltext("topwne2_error4");
	include("tools_pwschutz_neu.php");
	exit();
 }

if( ! valid_pw( $pass1 ) ){
  $liMaxPwdLength = defined( 'MaxPwdLength' ) ? MaxPwdLength : 12;
  $fehlertext = ltext("short_pass_error", $liMaxPwdLength );
	include("tools_pwschutz_neu.php");
	exit();
 }

if( $pass1 != $pass2 )	{
	$fehlertext = ltext("topwne2_error6");
	include("tools_pwschutz_neu.php");
	exit();
 }


db_connect($db_host, $db_user, $db_pass);

## pruefen, ob verzeichnis schon mit pw geschtzt
if( $db_type == 'mysql' ) {
	$sql = "select * from pwschutz where kunde = ? and BINARY pfad = ? AND server_id='$ServerID'";
} else {
	$sql = "select * from pwschutz where kunde = ? and pfad = ? AND server_id='$ServerID'";
}

$loUser = new SQLString( $PHP_AUTH_USER );
$loPath = new SQLString( $pfad ); 

$id = safe_query2( $sql, $loUser, $loPath );
if( db_num_rows( $id ) > 0 ){
	$fehlertext = ltext("topwne2_error7");
	db_close();
	include("tools_pwschutz_neu.php");
	exit();
 }
## //

## anbieter ermitteln
$id = safe_query2( "select anbieter from kunden where kunde = ?  AND server_id='$ServerID'", 
									 $loUser 
									 );
$werte = db_fetch_array($id);
$anbieter = $werte["anbieter"];

$id = safe_query2( "insert into pwschutz (pfad, bereich, kunde, anbieter, server_id)".
									 " VALUES (  ? ,  ? ,  ? ,  ? ,  '$ServerID' )", 
									 $loPath, 
									 new SQLString( $bereich ), 
									 $loUser, 
									 new SQLString( $anbieter ) 
									 );

$ident = db_insert_id( 'pwschutz', 'ident' );
$pass = crypt_pw($pass1);

safe_query2( "insert into users (login, pass, longpw, parent, kunde, server_id)".
						 " VALUES (  ? ,  '',  ? ,  ? ,  ? ,  '$ServerID' )", 
						 new SQLString( $login ), 
						 new SQLString( $pass ), 
						 new SQLInteger( $ident ), 
						 $loUser );

$id = safe_query2( "select * from htaccess where pfad = ? and kunde = ? AND server_id='$ServerID'",
									 $loPath, 
									 $loUser );
if( db_num_rows($id) < 1)	{

	safe_query2( "insert into htaccess (pfad, kunde, server_id) VALUES (  ? ,  ? , '$ServerID' )", 
							 $loPath, 
							 $loUser );
 }

safe_query2( "update allgemein set htaccess=1 WHERE server_id='$ServerID'" );
db_close();

$fehlertitel = ltext("topwne2_errortitle");
$fehlertext = ltext("topwne2_error8");
$pfad = "";
$bereich = "";
$login = "";
$pass = "";
include("tools_pwschutz.php");
exit();
?>
