package Modules::Backup::TableOperators;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

# The module provides a set of routines to handle data dumping
#
# Each handler(operator) may add some fields and so on. If no handler specified 
# for the table, defalt handler would be used.

# Typical usage:
# 	use Modules::Restore::TableOperators;
# 	my $operator = &get_operator("my_table");
# 	&$operator($xml, "my_table", \%row_attr, $obj_tab);

# Handler arguments:
# 	$xml = object of XML::DOM::Document. The document
# 	$table name = string. Name of the table to dump;
# 	$href = ref to hash of row values. ('column' => 'value', ...)
# 	$obj_conf_tab = object of Modules::Restore::Table. Parameters of dumping the table.

use MIME::Base64;
use XML::DOM;

use Modules::Backup::TableOperators;

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw(&get_operator);
}

#
# public interface
#

# get table operator(handler)
# $table_name = string. name of the table for whose handler is needed.
# return = reference to method
sub get_operator($) {
  my ($table_name) = @_;
  return (exists $operators{$table_name})
    ? $operators{$table_name}
      : \&Modules::Backup::TableOperators::mnp_hash2xmlnode;
}

sub setTableHandler {
  my (%handlers) = @_;
  foreach my $table (keys %handlers) {
    $operators{$table} = $handlers{$table};
  }
}

#
# implementation
#

# the specified operator should be called for each table.
# if no operator specified for the table, default operator should be called
my %operators = (
		 'anbieter'	=> \&Modules::Backup::TableOperators::mnp_anbieter,
		 'kunden'	=> \&Modules::Backup::TableOperators::mnp_kunden,
		);

# default manipulator for dumping object.  no extra functionality
sub mnp_hash2xmlnode($$$$) {
  my ($xml, $name, $href, $obj_conf_tab) = @_;
	
  my $node = $xml->createElement( $name );
  my ($val,$safe,$type,$field,$srcType);
  foreach my $key ( keys %$href ){

    unless ($field = $xml->createElement('field')){
      next;
    }
    
    $val = $href->{$key};
    if( ! defined( $val ) && 
				( $obj_conf_tab->getFieldAttr( $key, 'null' ) ||
				 $obj_conf_tab->getFieldAttr( $key, 'srcnull' ) )
       ){
      $field->setAttribute( 'null', '1' );
    }

#   old style
#   $safe= $obj_conf_tab->isPropSafe($key)
    $safe = $obj_conf_tab->getFieldAttr( $key, 'safe' );
    $srcType = $obj_conf_tab->getFieldAttr( $key, 'srctype' );

    if( $type = $obj_conf_tab->getFieldAttr( $key, 'type' ) ){
      $field->setAttribute('type',$type);
    }
    unless( $safe ||
						( $type && ( $type =~ /^[IT]/ ) ) ||
						( $srcType && $srcType =~ /^[IT]/ ) ){
      if( $val ){
				$val = encode_base64( $val, '' );
				$field->setAttribute( 'encode', 'base64' );
      }
    }
    $field->setAttribute( 'name', $key );
    $field->setAttribute( 'value', $val );

    $node->appendChild($field);
  }
  return $node;
}

sub mnp_anbieter($$$$) {
  my ($xml, $name, $href, $obj_conf_tab) = @_;
	
	# extract id-property
  unless ($$href{'anbieter'} =~ m/^res(\d+)$/) {
    die("Reseller name '$$href{'anbieter'}' does not match 'resNN..N' mask, \
where N is a digit\n");
  }
  $$href{'id'} = $1;
  return &mnp_hash2xmlnode($xml, $name, $href, $obj_conf_tab);
}

my ($reUserPrefix,$workPrefix);

sub mnp_kunden($$$$) {
  my ($xml, $name, $href, $obj_conf_tab) = @_;

	unless( $reUserPrefix ){
		$workPrefix = $::admin{'userprefix'} || $::user_prefix;
		$reUserPrefix = qr/^\Q$workPrefix\E(\d+)$/;
	}

	# extract id-property
  unless( $href->{'kunde'} =~ m/$reUserPrefix/) {
    die( "User name '".$href->{'kunde'}."' does not match '".$workPrefix."NNN' mask, where N is a digit\n");
  }
  $href->{'id'} = $1;

  return &mnp_hash2xmlnode($xml, $name, $href, $obj_conf_tab);
}


1;
