package Modules::Restore::Tables::Table_anbieter;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####


use XML::DOM;
use XML::DOM::NodeList;

use strict;
#no strict "vars";

use Modules::Restore::Map;
use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_admin;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::DumpDoc qw/&decode_row/;

my $href_admin;

sub pre_restore_tab($$$$) {

  my ($tblName,$ptrConfXML,$clean,$xmlTable)=@_;
  unless( $tblName && ref($ptrConfXML) =~ /DumpConfXML/ ){
    print STDERR "Modules::Restore::Tables::Table_anbieter::pre_restore_tab : wrong arguments ($tblName,..)\n";
    return 1;
  }
  my $tblRes = $ptrConfXML->getTable( 'anbieter' );
  unless( ref( $tblRes) =~ /Table/ ){
    print STDERR "Table_anbieter::pre_restore_tab : table 'anbietre' not found\n";
    return 1;
  }

#  print STDERR "pre restore table 'anbieter'\n" if $::DEBUG;

  $href_admin = $Modules::Restore::Tables::Table_admin::ptrAdmin; 

  my $sth;

  unless( ref( $href_admin ) =~ /HASH/ ){
    $sth = $main::dbh->prepare("SELECT dnstemplate, ip_pns, ip_sns FROM admin WHERE server_id='$::ServerID'");
    $sth->execute
      or die("Error #0201: Can not restore 'anbieter' table: $DBI::errstr\n");
    $href_admin = $sth->fetchrow_hashref;
    $sth->finish;
  }

  return 0 if($clean);
  
  return 1 unless (ref($xmlTable)=~/XML/); ## check argument

  my $sql = "SELECT MAX(number), COUNT(anbieter) FROM anbieter ".
		" WHERE server_id='$::ServerID'";
  $sth = $main::dbh->prepare($sql);
  $sth->execute
    or die("Error #0201: Can not calc max ID from 'anbieter' table: $DBI::errstr\n");
  my( $maxID, $cnt ) = $sth->fetchrow;
  $sth->finish;

  return 0 unless($cnt); ## empty

  $maxID = 0 unless( $maxID );

  my ($kid,$ptrRow,$oldName,$oldID,$newname,$table,$key,$newName);

  foreach $kid( $xmlTable->getChildNodes() ){

    next unless( $kid->getNodeType == ELEMENT_NODE );
    next unless( $kid->getNodeName() eq 'row');

    $ptrRow = &decode_row( $kid );
    next unless( ref( $ptrRow ) =~ /HASH/ );

    $oldName = $ptrRow->{'anbieter'};
    $oldID = $ptrRow->{'id'};
    unless( $oldID =~ /\d+/ ){
      if( $oldName =~ /res(\d+)/ ){
				$oldID = $1;
      }else{
				$oldID = $ptrRow->{'number'};
      }
    }
    if( ( $oldID > 0 ) && $oldName ){
      $key = "reseller($oldName).name";
      unless( $main::map->get_attr( $key ) ){
				$maxID++;
				$newName = "res$maxID";
				$main::map->add_attr( $key, $newName );
				$main::map->add_attr( "reseller($oldName).id", $maxID );
				$tblRes->addToMap( 'reseller', $oldName, $newName );
      }
    }
  }
	
  foreach my $tblName ($ptrConfXML->getTablesList){
    $table=$ptrConfXML->getTable($tblName);
    next unless (ref($table)=~/Table/);
    if ((!$table->Attribute('insert')) && $table->getLinks('anbieter')){
      $table->Attribute('anbieter',1); ## link to 'anbieter'
      $main::map->add_rule("$tblName(*).default",$APPEND_DUMPED);
      $table->Attribute('insert',1);
    }
  }
      
  return 0;
}

sub restore_row($$$) {
  my ($table_name, $ptrRow,$ptrTable) = @_;

	# restored fields
  my %db_row = %{$ptrRow};
  delete $db_row{'id'};

  my $id = $ptrRow->{'id'};
  my $name = $ptrRow->{'anbieter'};
  unless( $id =~ /\d+/ ){
    if( $name =~ /res(\d+)/ ){
      $id = $1;
    }
  }

  unless( $id>0 ){

    my $where = "(anbieter='res0')";
    my $sql = "SELECT anbieter FROM anbieter WHERE server_id='$::ServerID' AND $where";
    my $sth = $main::dbh->prepare( $sql );
    $sth->execute or
			die("Error #0201: Can not calc max ID from 'anbieter' table: $DBI::errstr\n");
    if( $sth->rows ){
      if( $main::map->get_rule('reseller(0).default') == $RESTORE_DUMPED) {
				for my $key ('ip','kunde','anbieter','uid','neu','pw','scponly','longpw',
										 'gesperrt','password'){
					delete $db_row{$key};
				}
				$main::map->add_attr( "reseller($name).name", $name );
				&Modules::Restore::Tables::Common::update_query('anbieter', \%db_row, $where);
      }
      return 0;
    }
    $sth->finish;
  }
	# map network

  if( $main::map->get_rule('reseller(*).dnstemplate') == $ASSIGN_CURRENT) {
    if( exists( $href_admin->{'dnstemplate'} ) ){
      $db_row{'dnsspezial'} = $href_admin->{'dnstemplate'};
    }
  }
  if ($main::map->get_rule('reseller(*).pns') == $ASSIGN_CURRENT) {
    if( exists( $href_admin->{'ip_pns'} ) ){
      $db_row{'pns'} = $href_admin->{'ip_pns'};
    }
  }
  if ($main::map->get_rule('reseller(*).sns') == $ASSIGN_CURRENT) {
    if (exists( $href_admin->{'ip_sns'})){
      $db_row{'sns'} = $href_admin->{'ip_sns'};
    }
  }
  
  $db_row{'standardip'} = $main::objDumpDoc->replaceIP( $db_row{'standardip'});


  # map names
  # ...

  my $key = "reseller($name).name";
  if( my $newName = $main::map->get_attr( $key ) ){
    $db_row{'anbieter'} = $newName;
    if( $newName =~ /res(\d+)/ ){
      $db_row{'number'} = $1;
    }
  }else{
    $main::map->add_attr( $key, $name );
  }

  &Modules::Restore::Tables::Common::insert_query( 'anbieter', \%db_row );

  return 0;
}

1;
