package Modules::Restore::Tables::Table_domainlog;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw( &post_restore_tab($$$$) );	
}

use XML::DOM;
use XML::DOM::NodeList;

use strict;

use Modules::Restore::Map;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;

sub post_restore_tab($$$$) {
  my ($tblName,$ptrConfXML,$clean,$xmlTable)=@_;

  print "post restore table '$tblName'\n" if $::DEBUG;

  unless ($tblName && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_domainlog::post_restore_tab : wrong arguments ($tblName,..)\n";
    return 1;
  }

  my ($table,$sth,$sql,$user,$res,$sqlInsert,$sthInsert,$domain);
  unless (($table=$ptrConfXML->getTable($tblName)) && (ref($table)=~/Table/)){
    if($::DEBUG){
      print STDERR "Warning: Table_domainlog::post_restore_row: Table '$tblName' not found\n";
    }
    return 1;
  }

  $sql = "SELECT domain,kunde,anbieter FROM domains ".
		" WHERE server_id='$::ServerID' AND richtigedomain != 5";
  $sth = $::dbh->prepare($sql);
  if( $sth->execute ){
    $sqlInsert = "INSERT INTO domainlog (domain,kunde,anbieter,neu,server_id) ".
			" VALUES(?,?,?,1,'$::ServerID')";
    if( $sthInsert = $::dbh->prepare( $sqlInsert ) ){
      while( ( $domain, $user, $res ) = $sth->fetchrow ){
				$sthInsert->execute( $domain, $user, $res );
      }
    }else{
      print STDERR "Error: Table_domainlog: Can't prepare request: '$sqlInsert' - $DBI::errstr\n";
    }
    $sth->finish;
  }
  return 1;
}


1;
