package Modules::SQL::SQLField;

use DBI;
use strict;

sub new {
	my $class = shift;
	my $sth = shift;
	my $this = {};

	bless $this, $class;

	if( ref( $sth ) ){
		$this->getSQLInfo( $sth, @_ );

	}else{
		unshift @_, $sth;
		my %args = (@_);
		$this = { 'name' => $args{'name'},
							'type' => $args{'type'},
							'db_type' => $args{'db_type'}
						};
	}

	return $this;
}

#
# members
#
sub Name {
	my $this = shift;
	if( @_ ){
		$this->{'name'} = shift;
	}
	return $this->{'name'};
}

sub Type {
	my $this = shift;
	if(@_){
		$this->{'type'} = shift;
	}
	return $this->{'type'};
}

sub Null {
	my $this = shift;
	if( @_ ){
		$this->{'null'} = shift;
	}
	return $this->{'null'};
}

sub DbType {
	my $this = shift;
	if( @_ ){
		$this->{'db_type'} = shift;
	}
	return $this->{'db_type'};
}

sub Index {
	my $this = shift;
	if( @_ ){
		$this->{'index'} = shift;
	}
	return $this->{'index'};
}

#
# /members
#

#
# methods
#
sub getSQLInfo {
	my ( $this, $sth, $index, $db_type ) = @_;
	unless( ref( $sth ) && $index =~ /^\d+$/ ){
		return undef;
	}
	$this->clean();

	$this->{'db_type'} = ( $db_type =~ /Pg/i )? 'Pg': 'mysql';
	$this->{'index'} = $index;

	$this->{'NAME'} = $sth->{'NAME'}->[$index];
	$this->{'name'} = ($this->{'db_type'} eq 'Pg')? 
		lc( $this->{'NAME'} ): $this->{'NAME'};

	$this->{'TYPE'} = $sth->{'TYPE'}->[$index];
	$this->{'NULLABLE'} = $sth->{'NULLABLE'}->[$index];
	if( $this->{'NULLABLE'} ){
		$this->{'null'}  = $this->{'NULLABLE'} unless $this->{'NULLABLE'} == 2;
	}

	if( $this->{'db_type'} eq 'Pg' ){
		if( $this->{'TYPE'} == 5 || ## smallint
				$this->{'TYPE'} == 4 || ## int
				$this->{'TYPE'} == 8 || ## bigint
				$this->{'TYPE'} == 2 || ## real
				$this->{'TYPE'} == 7 || ## double
				$this->{'TYPE'} == 1700 ## decimal
			){
			$this->{'type'} = 'I';

		}elsif( $this->{'TYPE'} == 1114 ){ ## timestamp
			$this->{'type'} =' T';

		}elsif( $this->{'TYPE'} == 9 ){
			$this->{'type'} = 'D';
		}

	}else{
		if ( $this->{'TYPE'} == -6 || ## tinyint
				 $this->{'TYPE'} == 4  || ## int
				 $this->{'TYPE'} == 5  || ## smallint
				 $this->{'TYPE'} == -5    ## bigint
			 ){
			$this->{'type'} = 'I';

		}elsif( $this->{'TYPE'} == 11 ){ ## timestamp
			$this->{'type'} = 'T';
		}
	}

	return $this->{'type'};
}


sub clean {
	my $this = shift;
	map { delete $this->{$_} } grep{ ! /^db_type|index$/ } keys %{$this};
}

#
#
#

1;
