#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use DBI;
use DBD::mysql;

use lib_module_common;
use lib_module_db;

use vars qw( $dbh );

sub installMySQLLogin {
  print &ltext('install_install_group', 'MySQL-Login Script');
  print &ltext('install_do_file_create', '/bin/confixxmysql.sh');
	unless ( $bin{'mysql'} && -x $bin{'mysql'} ) {
		$bin{'mysql'} = $bin_mysql || &getBin('mysql');
	}
  my $userpromt = &ltext('install_mysql_shell_username'); 
  my $accessdenied = &ltext('install_mysql_shell_accessdenied'); 
  open(FILE, ">/bin/confixxmysql.sh");

  print FILE << "SCRIPT";
#!/bin/sh
##
# Confixx-MySQL-Shell-Login
##

PREFIX="$user_prefix";
export EDITOR="/bin/false";

clear;
echo "";
echo "Confixx-MySQL-Login";
echo -n "$userpromt";
read -r user;

if ( echo -E "X\$user" | $bin{'grep'} "^X\$PREFIX[0-9]\\+\$" >/dev/null )  ; then
  $bin{'mysql'} -p -u\$user;
 else
  echo "$accessdenied";
fi
exit;
SCRIPT

  close(FILE);
  chmod(0755, "/bin/confixxmysql.sh");
}

sub uninstallMySQLLogin {

  my ( $server, $user, $paswd, $port, $user, $db );
	if ( @_ ) {
		( $server, $user, $paswd, $port ) = @_;
	} else {
		( $server, $user, $passwd, $port ) = 
			( $mysqlUserServer, $mysqlUserUser, $mysqlUserPw);
	}
	
  if ( $server && $user ) {
		my $DSN = &makeDSN('mysql', $server, 'mysql', $port );
    my $dbh2 = DBI->connect($DSN, $user, $paswd );
		unless ( $dbh2 ) {
      ("Konnte Datenbank nicht oeffnen\n$DBI::errstr\n");
			return 0;
		}

    my $sth = $dbh->prepare( "SELECT kunde FROM mysql_datenbanken WHERE server_id='$ServerID' GROUP BY kunde");
    $sth->execute or &soft_error("$DBI::errstr");
    while ( ( $user ) = $sth->fetchrow_array ) {
      $dbh2->do("DELETE FROM user WHERE User='$user'") or
				&soft_error("$DBI::errstr");
      $dbh2->do("DELETE FROM db WHERE User='$user'") or
				&soft_error("$DBI::errstr");
    }
    $sth->finish;
    $sth = $dbh->prepare("SELECT dbname FROM mysql_datenbanken WHERE server_id='$ServerID'");
    $sth->execute or
			&soft_error("$DBI::errstr");

    while ( ( $db ) = $sth->fetchrow_array ) {
      $dbh2->do("DROP DATABASE $db") or 
				&soft_error("$DBI::errstr");
    }
    $sth->finish;
    $dbh2->disconnect;
  }
}

return 1;

