#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib "$FindBin::Bin";
  use lib "$FindBin::Bin/../scripts";
}

## Pre-Main
use File::Basename;
use DBI;

use lib_module_db;
use lib_module_common;

$wDir = dirname($0);
$subs_include_questions = "$wDir/subs_include_questions.pl";
unless(-f $subs_include_questions){
  $wDir =~ s/\/[^\/]+$/\/subs/;
  $subs_include_questions = "$wDir/subs_include_questions.pl";
	unless ( -f $subs_include_questions ) {
		if ( -d $installDir ) {
			$wDir = "$installDir/admin/subs";
			$subs_include_questions = "$wDir/subs_include_questions.pl";
		}
	}
}

safe_do $subs_include_questions;
safe_do "$wDir/subs_include_writeConfig.pl";
safe_do "$wDir/subs_include_files.pl";
$cgiDir = "/../cgis";

if ( $0 =~ /(?:^|\/)cgis_install\.pl$/) {

  &initConfig();

  &installAllCGIs();

}

sub installAllCGIs {
	my $dbh = shift || $::dbh;

	&ReadMainConfigFile;

	&header2( &ltext('install_header_cgis') );

## Pre-Main
	my ($dbh3);
	if ( ref($dbh)=~/DBI/ ) {
		$dbh3 = $dbh;
	} else {
		$dbh3 = DBI->connect($db_address, $dbUser, $dbPw)
			or die( &ltext('db_connect', '#XXX', $DBI::errstr) );
	}
## Main
	&cleanPre15;

	&configureCgis( $dbh3 );

	&WriteMainConfigFile;
## /Main

	unless ( ref( $dbh ) =~ /DBI/ ) {
		$dbh3->disconnect;
	}

}

## UNTERPROGRAMME

sub installCgi {
  my ($name) = @_;

	$bin_cp ||= $bin{'cp'} || 'cp';
	$bin_chmod ||= $bin{'chmpd'} || 'chmod';
	$bin_chown ||= $bin{'chown'} || 'chown';

  unless(-d "$confixx_cgiDir/$name"){
    mkdir("$confixx_cgiDir/$name", 0755);
  }
  system("$bin_cp -rv $wDir$cgiDir/$name/cgis/* $confixx_cgiDir/$name/");
  system("$bin_chmod 755 $confixx_cgiDir/$name/*.cgi");
  unless(-d "$confixx_htmlDir/webmail"){
    mkdir("$confixx_htmlDir/webmail", 0755);
  }
  system("$bin_chown -R $confixx_uid:$confixx_gid $confixx_cgiDir");
}


sub configureCgis{
	my $dbh = shift || $::dbh;

  my($safeDir);

  if($use_webftp){

    &RecCreateDir($confixx_cgiDir, 0755);
    chmod(0755, $confixx_cgiDir);

    &installCgi('webftp');

    print "\n";
    $dbh->do("UPDATE admin SET webftp=1 WHERE server_id='$ServerID'");
  }

  if($use_webmail){

    &RecCreateDir($confixx_cgiDir, 0755);
    chmod(0755, $confixx_cgiDir);

    &installCgi('webmail');

    print "\n";
    $dbh->do("UPDATE admin SET webmail=1 WHERE server_id='$ServerID'");
  }
}

sub cleanPre15{
  &delOld("$confixx_cgiDir/webmail.cgi");
  &delOld("$confixx_cgiDir/smtp.cgi");
  &delOld("$confixx_cgiDir/webftp.cgi");
  &delOld("$confixx_htmlDir/smtp.conf");
  &delOld("$confixx_htmlDir/webmail.conf");
  &delOld("$confixx_htmlDir/webftp.conf");
}


sub delOld{
  my ($file) = @_;
  if((-e "$file") || (-l "$file")){
    print &ltext('install_do_file_del', "$file");
    unlink("$file");
  }
}


sub header2{
  my ($header) = @_;
  my ($length, $count, $fix, $space);
  $fix = 35;
  $length = length($header);
  if($length > $fix){
    $fix = $length + 2;
  }
  $space = int(( $fix - $length ) / 2);
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n";
  for($count=1; $count <= $space; $count++){
    print " ";
  }
  print "$header    \n";
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n\n";
}
## /UNTERPROGRAMME
