#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib $FindBin::Bin;
  use lib $FindBin::Bin.'/../scripts';
	use lib $FindBin::Bin.'/subs';
}

use File::Basename;

use lib_module_common;
use lib_module_db;

use vars qw/$wDir/;

use strict;

## einige Variablen
my @need_binaries_postfix = ('postmap', 'postfix', 'newaliases', 'sendmail');
## /einige Variablen

&initConfig;



## Pre-Main
my ( $installMode );

if ( $confixxState=~/install/ ) {
	$installMode = 1;
}


$wDir ||= &getCanonPath( dirname($0) );

if ( $0 =~ /postfix_install/ ) { ## call a single script

	safe_do "$wDir/subs_include_questions.pl";
	safe_do "$wDir/subs_include_files.pl";
	safe_do "$wDir/subs_include_writeConfig.pl";
	safe_do "$wDir/mta_config.pl";

	$installMode ||= (-T "$wDir/../.config")? 1: 0;

} else {
	
	if ( -d "$wDir/subs" ){ ## configure & install
		safe_do "$wDir/subs/subs_include_questions.pl";
		safe_do "$wDir/subs/mta_config.pl";

	} elsif ( -d "$wDir/../subs" ) { ## update
		safe_do "$wDir/../subs/subs_include_questions.pl";
		safe_do "$wDir/../subs/mta_config.pl";
	}

	$installMode ||= (-T "$wDir/.config")? 1: 0;
}

&header2( &ltext('install_header_email', 'Postfix') );
foreach my $binary (@need_binaries_postfix){
  $bin{$binary} ||= &getBin($binary);
}
## /Pre-Main

## Main
&configureMta( 'postfix' );



if( $aliases ) {
  &BackUpFile($aliases, "$installDir/backup/postfix/aliases");
  &BackUpFile($aliases, "$installDir/safe/aliases_header");
}
if ( $MailConfigFile ) {
  &BackUpFile($MailConfigFile, "$installDir/backup/postfix/main.cf");
}

&ChangeConfigFile;
&UpdateMainConfig;
&createEmptyConfig;

## Main

#
#
#====================================================
#
#

## UNTERPROGRAMME



sub ChangeConfigFile {
  &BackUpFile($MailConfigFile, "$installDir/backup/postfix/main.cf");
  my (@PostfixConfig, $i);
  my $Anhang = 1;
  open (FILE, "$MailConfigFile");
  print &ltext('install_do_file_edit', $MailConfigFile); 
  $i = 0;
  while (<FILE>){
    if (($_ =~ /^virtual_maps/i)){
      if ($_ !~ /hash:$virtUserTableDB, hash:$localDomainsFile/){
        chop($_);
        my $var = $_;
        $_ .=", hash:$virtUserTableDB, hash:$localDomainsFile\n";
        print( &ltext('install_do_file_line_change', $var, $_) );
      }
      $Anhang = 0;
    }
    $PostfixConfig[$i++] = $_;
  }
  close (FILE);
  if ($Anhang){
    $PostfixConfig[$i++] = "\n### CONFIXX POSTFIX ENTRY ###\n\n";
    $PostfixConfig[$i++] = "virtual_maps = hash:$virtUserTableDB, hash:$localDomainsFile\n";
    print( "\n" . &ltext('install_do_file_line_add', "virtual_maps = hash:$virtUserTableDB, hash:$localDomainsFile", $MailConfigFile) . "\n" );
    $PostfixConfig[$i++] = "\n### /CONFIXX POSTFIX ENTRY ###\n";
    open ( LOCAL, ">", $localDomainsFile );
    close (LOCAL);
  }
  open (FILE, ">$MailConfigFile");
  print FILE (@PostfixConfig);
  close (FILE);
}


# creates empty Confixx config
# files for postfix.
# So postfix will not complain about
# missing files
sub createEmptyConfig{
  open(FILE, ">>$localDomainsFile");
  close(FILE);
  system("$bin{'postmap'} hash:$localDomainsFile >/dev/null");

  open(FILE, ">>$virtUserTableDB");
  close(FILE);
  system("$bin{'postmap'} hash:$virtUserTableDB >/dev/null");
}
## /UNTERPROGRAMME
