#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib $FindBin::Bin;
  use lib $FindBin::Bin.'/../scripts';
	use lib $FindBin::Bin.'/subs';
}

use File::Basename;

use lib_module_common;
use lib_module_db;
use lib_module_password;

use vars qw/$wDir/;

use strict;

## einige Variablen
my @need_binaries_qmail = ('sendmail');
## /einige Variablen

&initConfig;

## Pre-Main
$wDir ||= &getCanonPath( dirname($0) );

my 	( $installMode );

if ( $confixxState=~/install/ ) {
	$installMode = 1;
}


if ( $0 =~ /qmail_install/ ) { ## call a single script

	safe_do "$wDir/subs_include_files.pl";
	safe_do "$wDir/subs_include_questions.pl";
	safe_do "$wDir/subs_include_writeConfig.pl";
	safe_do "$wDir/mta_config.pl";

	$installMode ||= (-T "$wDir/../.config")? 1: 0;

} else {
	if ( -d "$wDir/subs" ){ ## configure & install
		safe_do "$wDir/subs/subs_include_questions.pl";
		safe_do "$wDir/subs/mta_config.pl";

	} elsif ( -d "$wDir/../subs" ) { ## update
		safe_do "$wDir/../subs/subs_include_questions.pl";
		safe_do "$wDir/../subs/mta_config.pl";
	}

	$installMode ||= (-T "$wDir/.config")? 1: 0;

}

&header2( &ltext('install_header_email', 'Qmail') );
foreach my $binary (@need_binaries_qmail){
  $bin{$binary} ||= &getBin($binary);
}
## /Pre-Main

## Main
&createFwUsers;

&configureMta( 'qmail' );

if($virtUserTableDB ne ""){
  &BackUpFile($virtUserTableDB, "$installDir/safe/virtualdomains_header");
  &BackUpFile($virtUserTableDB, "$installDir/backup/qmail/virtualdomains");
}
if($localDomainsFile ne ""){
  &BackUpFile($localDomainsFile, "$installDir/safe/rcpthosts_header");
  &BackUpFile($localDomainsFile, "$installDir/backup/qmail/rcpthosts");
}
&UpdateMainConfig;
## /Main

## UNTERPROGRAMME




sub createFwUsers{
  $groupDir = '/etc/group';
  my $mtaGroup = 'mtafw';
  if(getgrnam($mtaGroup)){
    $mta_gid = getgrnam($mtaGroup);
  }
  else{
    $mta_gid = &AddGroup($mtaGroup);
  }
  my $days_since_1970 = int(time() / 86400); #/
  my %hash = ( "a" => ($min_uid - 35),
               "b" => ($min_uid - 34),
               "c" => ($min_uid - 33),
               "d" => ($min_uid - 32),
               "e" => ($min_uid - 31),
               "f" => ($min_uid - 30),
               "g" => ($min_uid - 29),
               "h" => ($min_uid - 28),
               "i" => ($min_uid - 27),
               "j" => ($min_uid - 26),
               "k" => ($min_uid - 25),
               "l" => ($min_uid - 24),
               "m" => ($min_uid - 23),
               "n" => ($min_uid - 22),
               "o" => ($min_uid - 21),
               "p" => ($min_uid - 20),
               "q" => ($min_uid - 19),
               "r" => ($min_uid - 18),
               "s" => ($min_uid - 17),
               "t" => ($min_uid - 16),
               "u" => ($min_uid - 15),
               "v" => ($min_uid - 14),
               "w" => ($min_uid - 13),
               "x" => ($min_uid - 12),
               "y" => ($min_uid - 11),
               "z" => ($min_uid - 10),
             "any" => ($min_uid - 9));
#
# forwards for mail lists
#
 
	for (my $i=0; $i<10; $i++){
		$hash{$i} = $min_uid-45+$i;
	}
 
#
#
#
  unless(-d "$user_homeDir/forward"){
    mkdir("$user_homeDir/forward", 0755);
  }

	my( $endung, $uid );
  open(PASSWD, ">>/etc/passwd");
  open(SHADOW, ">>/etc/shadow");
  foreach $endung (sort keys %hash){
		$uid = $hash{$endung};
		next if (getpwnam("confixxfw_$endung"));
		print SHADOW "confixxfw_$endung:!:$days_since_1970:0:99999::::\n";
		print PASSWD "confixxfw_$endung:x:$uid\:$mta_gid\::$user_homeDir/forward/confixxfw_$endung:/bin/false\n";
		mkdir("$user_homeDir/forward/confixxfw_$endung", 0755);
		chown($uid, $mta_gid, "$user_homeDir/forward/confixxfw_$endung");
  }
  close(PASSWD);
  close(SHADOW);
}


## /UNTERPROGRAMME
