#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use vars qw/ $dns_server $dns_serverid $use_dns $ip_pns $ip_sns $use_dnr
						 $dns_conf $dns_configure $dns_dir $dns_chroot $dns_copyconf
						 $pm_bind_user $pm_bind_reload $pm_bind_start
						 $stdIP /;

use strict;
use File::Copy;

sub installDns {

	my $addChroot = 0;
	if ( $dns_chroot && -d $dns_chroot ) {
		unless ( $dns_copyconf ) {
			$addChroot = 1;
		}
	} else {
		$dns_chroot = '';
	}

#
# configure the main named config
#
	my	$real_path = $addChroot? $dns_chroot.$dns_conf: $dns_conf;

	if ( -T $real_path ) {
		print( &ltext( 'install_do_file_edit', $real_path ) );
		my $go=1;

		if(open(FILE,"< $real_path")){
			my $pat=qr/^Include\s+"\Q$dns_configure\E";/;
			while (<FILE>){
				chomp;
				next unless $_; ## skip epmty line
				next if /^#/; ## skip comment
				if ( /$pat/ ) { ## found !!!
					$go = 0;
					last;
				}
			}
			close (FILE);
		}
		if ( $go ) {
			open(FILE, ">>$real_path");
			print FILE "\n## CONFIXX\n";
			print FILE "Include \"$dns_configure\";\n" .
				"## /CONFIXX\n";
			close(FILE);
		}
	} else {
		warn "error: the named config file: '$real_path' is not found\n";
		return 0;
	}
#
# end configure the main named config
#

#
# create file $dns_configure
#

	$real_path = $dns_chroot? $dns_chroot.$dns_configure: $dns_configure;
		
	if ( open ( FILE, '>', $real_path ) ) {
		close (FILE);
	} else {
		warn "error: can not create file '$real_path': $!\n";
		return 0;
	}

	if ( -f $dns_configure && ( $dns_configure ne $real_path ) ) {
		copy ($real_path,$dns_configure);
	}

#
# end create file $dns_configure
#

	$real_path = $dns_chroot? $dns_chroot.$dns_dir: $dns_dir;

	unless ( -d $real_path ) {
		unless ( system("mkdir -p $real_path") == 0 ) {
			warn "error: can not create dir: '$real_path': $!\n";
			return 0;
		}
	}

	return 1;
}

sub configureDns {

	my $dist = shift || &getDistrib();

  my $default_dns_conf = "/etc/named.conf";
	foreach my $path ('/etc/bind/named.conf',
										'/etc/rndc.conf' ) {
		if( -f $path ) {
			$default_dns_conf = $path;
			last;
		}
  }


	if ( &YesNoQuestion( &ltext('install_question_dnsmaster'), 'j' )){

		if ( &YesNoQuestion( &ltext('install_question_serverid') ) ) {
			$dns_serverid = 1;
		} else {
			$dns_serverid = 0;
		}
		
	} else {
		$dns_serverid = 2;
	}

	my $defaultBindScript = '/etc/init.d/named';
	my $defaultZoneDir = '/var/named';
	if ( $dist =~ /debian/ ) {
                if ( -e '/etc/init.d/bind9' ) {
                    $defaultBindScript = '/etc/init.d/bind9';
                } elsif ( -e '/etc/init.d/bind' ) {
                    $defaultBindScript = '/etc/init.d/bind';
                }	
		$defaultZoneDir = '/var/cache/bind';
	}
	my $default_dns_dir = $defaultZoneDir.'/confixxdns';


	my $bindScript = &FileQuestion( &ltext( 'install_question_dns_script' ), $defaultBindScript );


	$dns_chroot = &getDnsChroot( $bindScript,$dist );

	unless( defined( $dns_chroot ) ){
		if ( &YesNoQuestion( &ltext('install_dns_chroot'), 'n' )){
			$dns_chroot = &DirQuestion( &ltext('install_dns_rootdir'),$defaultZoneDir  );
		} else {
			$dns_chroot = '';
		}
	}
	$dns_chroot =~ s/\/$//; ## remove the last slash

	my (@restarts);

	if ( $dns_chroot && -d $dns_chroot ) {
		if ( $dist =~ /suse/i ) {
			$dns_copyconf = 1;
		} elsif ( $dist =~ /redhat/i ) {
			$dns_copyconf = 0;
		} else {
			if ( &YesNoQuestion( &ltext('install_dns_copyconf'),$dist=~/suse/i?'j':'n'  ) ) {
				$dns_copyconf = 1;
			} else {
				$dns_copyconf = 0;
			}
		}
		@restarts = ('restart','reload');
	} else {
		@restarts = ('reload','restart');
	}

	my $restart = &getReloadKey($bindScript,@restarts) || $restarts[0];

	$pm_bind_reload = "$bindScript $restart";
	$pm_bind_start  = "$bindScript start";

	$dns_conf = &FileQuestion( &ltext('install_question_dnsconf') , $default_dns_conf);
	my $default_dns_confdir = dirname($dns_conf);
	my $default_dns_ext = "$default_dns_confdir/named.confixx";
	$dns_configure = &Question( &ltext('install_question_dnsconfdir'),$default_dns_ext);
	$dns_dir = &Question( &ltext('install_question_dnsdir'),$default_dns_dir);
	$use_dns = 1;

	if ( $dns_chroot && ( -d $dns_chroot ) ) {
		my $re = qr/^\Q$dns_chroot\E(?=\/)/;  ## translate '<$dns_chroot>/...' -> '/...'
		if ( $dns_copyconf ) {
			$dns_conf =~ s/$re//;
			$dns_configure =~ s/$re//;
		}
		$dns_dir =~ s/$re//;
	}


	
	my @ns = &getNameServers();

	my $default_pns = '';
	my $default_sns = '';
	if ($dns_serverid == 0 || $dns_serverid == 1) {
		# the host is primary name server
		$default_pns = $stdIP;
		$default_sns = (scalar(@ns) > 0) ? $ns[0] : '';
	}
	$ip_pns = &Question( &ltext('install_question_ip_pns'), $default_pns);
	$ip_sns = &Question( &ltext('install_question_ip_sns'), $default_sns);
	$use_dnr = &YesNoQuestion( &ltext('install_question_dnr') );



}

sub getDnsChroot {
	my ($initdScript,$dist) = @_;
	my ($dnsRoot,$dnsUser,$args);
	if ( open (PS,"ps -Af|") ){
		while ( <PS> ) {
			if ( /named/ ) {
				unless ( /\[named\]/ ){
					if ( /named\s+(.*-u.+)/ ){
						$args = $1;
					}
				}
				last;
			}
		}
		close PS;
	}
	if ( $args ) {
		if ( $args =~ /-u\s*(\S+)/ ) {
			$dnsUser = $1;
			if ( $args =~ /-t\s*(\S+)/ ) {
				$dnsRoot = $1;
			} else {
				$dnsRoot = '';
			}
		}
	} else {
		my ($file);

		if ( $dist =~ /redhat/i ) {
			foreach $file ('/etc/sysconfig/network','/etc/sysconfig/named') {
				$dnsRoot ||= &getShellValue( $file, 'ROOTDIR' );
			}

		} elsif ( $dist =~ /suse/i ) {
			$file = '/etc/sysconfig/named';
			my $chrooted = &getShellValue('/etc/sysconfig/named','NAMED_RUN_CHROOTED');
			
			if ( $chrooted =~ /yes/ ) {
				$dnsRoot = &getShellValue( $initdScript,'CHROOT_PREFIX' );
			} else {
				$dnsRoot = '';
			}
		}
	}
	return $dnsRoot;
}


sub getShellValue {
	my ($file,$name) = @_;
	my $pat = qr/\Q$name\E=(.*)/;
	my $value;
	if ( -T $file && open(CONF,"<$file") ) {
		while (<CONF>) {
			chomp;
			next unless $_; ## skip empty
			next if /^#/; ## skip comment
			if ( /$pat/ ) {
				$value ||= &allTrim( $1 );
				last if $value;
			}
		}
		close CONF;
	}
	return $value;
}

sub allTrim {
	my $val = shift;
	if ( $val ) {
		$val =~ s/^\s+//; ## ltrim
		$val =~ s/\s+$//; ## rtrim
		if ( $val =~ /('|")(.+)\1/ ){ ## remove quotes
			$val = $2;
		}
	}
	return $val;
}

# The routine tries to detect nameservers of the machine
sub getNameServers() {
	my @servers = ();
	my $resolv_file = "/etc/resolv.conf";
	unless (-e $resolv_file) {
		warn "Warning: File $resolv_file does not exist\n";
		return ();
	}
	unless (open(FILE, "<$resolv_file")) {
		warn "Warning: Can not open $resolv_file: $!\n";
		return ();
	}
	while (<FILE>) {
		chomp;
		if ($_ =~ /^\s*nameserver\s+(\S+)\s*$/) {
			push @servers, $1;
		}
	}
	close(FILE);		
	return @servers;
}

sub getDistrib {
	my ($dist);

  if ( -e "/etc/redhat-release" ) {
    $dist = 'redhat';
 
  } elsif ( -e "/etc/mandrake-release" ) {
    $dist = 'mandrake';

  } elsif ( -e "/etc/SuSE-release" ) {
    $dist = 'suse';

  } elsif ( -e "/etc/debian_version" ) {
    $dist = 'debian';
  }

	return $dist;
}

1;

