#!/usr/bin/perl

my $bin_sudo = '/usr/bin/sudo';
my $shell = '/bin/sh';

my ($cmd, $user);

my $state = 0;
my $ret = 0;

unless ( -x $bin_sudo ) {
        die "'$bin_sudo' is not executable\n";
}

foreach my $arg ( @ARGV ) {
        if ( $state == 0 ) {
                if ( $arg =~ /^(-s|--shell)=?(.*)/ ) {
                        unless ( $shell = $2 ) {
                                $state = 1;
                        }
                } elsif ( $arg =~ /^(-c|--command)=?(.*)/ ) {
                        unless ( $cmd = $2 ) {
                                $state = 2;
                        }
                } elsif ( $arg =~ /^(-|-l|--login)/ ) {

                } elsif ( $arg =~ /^(-m|-p|--preserve-environment)/) {

                } else {
                        $user = $arg;
                }
        } elsif ( $state == 1 ) {
                $shell = $arg;
                $state = 0;
        } elsif ( $state == 2 ) {
                $cmd = $arg;
                $state = 0;
        }
}

if ( $cmd && $user ) {
        my $system = "$bin_sudo -u $user $cmd";
#       print $system,"\n";
        exec  $system;
        die "Can't execute '$system': $!\n";
} else {
        die "user or command are not found in arguments\n",join(' ',@ARGV),"\n";
}

exit ( $ret );