#!/usr/bin/perl

BEGIN {
	use FindBin;
	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib $FindBin::Bin.'/modules';

}

use SOAP::Lite;
use Getopt::Long;

use lib_module_db;
use lib_module_events;

use strict;

my @config_opts = (
									 'host|h=s',
									 'login|l=s',
									 'pass|p=s',

									 'sid=s',

									 'user|u=s',
									 'unlock',

									 'logout!',

									 'debug|dbg:i'
									);

my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

unless( exists( $args{'unlock'})){
	$args{'unlock'} = 0;
}

unless( exists( $args{'logout'})){
	$args{'logout'} = 1;
}
if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

unless( $args{'host'} ){
	warn "Error: hostname is not set\n";
	&print_help();
	exit 1;
}

my $soap_host = $args{'host'};
$soap_host =~ s/^('|")(.*)\1/$2/;

unless( $args{'sid'} || ( $args{'login'} && $args{'pass'} ) ){
	warn "Error: missing parameters off connection\n";
	&print_help();
	exit 1;
}

my $soap_session = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Session')
		-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
			-> on_fault( \&on_error );


my $soap_mysql = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/UsersMySQL')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );


my ($session_id);
if( $args{'sid'} ){
	$session_id = $args{'sid'};
}else{
	$session_id = $soap_session->login( $args{'login'}, $args{'pass'} )->result;
	print "session_id: $session_id\n";

}

my $unlocked = $soap_mysql->lock_user( $session_id,
																			 $args{'user'},
																			 $args{'unlock'}?'Y':'N'
																		 )->result;

print "unlocked: $unlocked";

if( $args{'logout'} ){
	$soap_session->logout( $session_id );
}

exit 0;

#
#
#============================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

lock_user.pl - lock / unlock database user

command line options:

  --host |-h = < hostname of the Confixx's server >
  --login|-l = < login name of the Confixx's administrator >
  --pass |-p = < password of the Confixx's administrator >

  --user |-u = < name of database user >

  --unlock     -  unlock the databse user

  --no-logout  -  don't logout after checking
  --sid = < session's ID >

  --debug|-dbg = < debug level >

HELP

}
