#!/usr/bin/perl

BEGIN {
	use FindBin;
	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib $FindBin::Bin.'/modules';

}

use SOAP::Lite;
use Getopt::Long;

use strict;

my @config_opts = (
									 'host|h=s',
									 'login|l=s',
									 'pass|p=s',

									 'sid=s',

									 'action|a=s',

									 'db-name|dbn=s',
									 'db-user|dbu=s',
									 'db-pass|dbp=s',
									
									 'logout!',

									 'debug|dbg:i'
									);
									 
my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

unless( exists( $args{'logout'})){
	$args{'logout'} = 1;
}
if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

unless( $args{'host'} ){
	warn "Error: hostname is not set\n";
	&print_help();
	exit 1;
}

my $soap_host = $args{'host'};
$soap_host =~ s/^('|")(.*)\1/$2/;

unless( $args{'sid'} || ( $args{'login'} && $args{'pass'} ) ){
	warn "Error: missing parameters of connection\n";
	&print_help();
	exit 1;
}

unless( $args{'action'} =~ /^(create|drop|passwd|ext|local|lock|unlock)$/i ){
	warn "Error: bad action\n";
	&print_help();
	exit 1;
}

unless( $args{'db-user'}){
	warn "Error: missing name of the database user\n";
	&print_help();
	exit 1;
}


my $soap_session = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Session')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my $soap_mysql = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/UsersMySQL')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my ($session_id);
if( $args{'sid'} ){
	$session_id = $args{'sid'};
}else{
	$session_id = $soap_session->login( $args{'login'}, $args{'pass'} )->result;
	print "session_id: $session_id\n";
}

#
# can do it
#
$soap_session->check_rights( $session_id, $args{'db-user'} );
	
#
# actions
#

#
# craete a new database ( and a databases's user if needed )
#
if( $args{'action'} =~ /^create$/i ){
	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('db_name')->value( $args{'db-name'} ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} ),
																SOAP::Data->name('db_paswd')->value( $args{'db-pass'} )
														);
	my $result = $soap_mysql->create( $args );
	my( $db_name, $db_user, $db_pass );

#
# can return list of 3 values or one single
#
	$db_name = $result->result();
	( $db_user, $db_pass ) = $result->paramsout();

	print "db-name: $db_name\n";
	if( $db_user ){
		print "db-user: $db_user\n";
		print "db-passwd: $db_pass\n";
	}

#
# drop the database
#
}elsif( $args{'action'} =~ /^drop$/i ){
	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('db_name')->value( $args{'db-name'} ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} )
														);
	my $dbname = $soap_mysql->drop( $args )->result;
	print "db-name: $dbname\n";

}elsif( $args{'action'} =~ /^passwd$/i ){
	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} ),
																SOAP::Data->name('db_paswd')->value( $args{'db-pass'} )
														);
	my $dbpass = $soap_mysql->passwd( $args )->result;
	print "db-passwd: $dbpass\n";

#
# allow external access to the database 
#
}elsif( $args{'action'} =~ /^ext$/i ){
	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('access')->value( 'ext' ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} ),
																SOAP::Data->name('db_name')->value( $args{'db-name'} )
														);
	my $dbname = $soap_mysql->access( $args )->result;
	print "db-name: ".$args{'db-name'}."\n";

#
# disallow external access to the database
#
}elsif( $args{'action'} =~ /^local$/i ){
	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('access')->value( 'local' ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} ),
																SOAP::Data->name('db_name')->value( $args{'db-name'} )
														);
	my $dbname = $soap_mysql->access( $args )->result;
	print "db-name: ".$args{'db-name'}."\n";

#
# lock the database's user
#
}elsif( $args{'action'} =~ /^lock$/i ){
	my $unlocked = $soap_mysql->lock_user( $session_id,
																				 $args{'db-user'} )->result;
	print "unlocked: $unlocked\n";

#
# unlock the database's user
#
}elsif( $args{'action'} =~ /^unlock$/i ){
	my $unlocked = $soap_mysql->unlock_user( $session_id,
																					 $args{'db-user'} )->result;
	print "unlocked: $unlocked\n";

}


if( $args{'logout'} ){
	$soap_session->logout( $session_id );
}

exit 0;

#
#
#============================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

start_cluster.pl - start process of connection to cluster

command line options:

  --host |-h = < hostname of the Confixx's server >
  --login|-l = < login name of the Confixx's administrator >
  --pass |-p = < password of the Confixx's administrator >

  --action|-a = <create|drop|passwd|ext|local|lock|unlock>

  --db-name|-dbn = < name of the user's database >
  --db-user|-dbu = < name of the databases's user >
  --db-pass|-dbp = < password to the databases's user >

  --no-logout  -  don't logout after action
  --sid = < session's ID >

  --debug|-dbg = < debug level >

HELP

}

