<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'page_functions.php' );

if (!isset($functionschonmal))  {
	$functionschonmal = 1;


	$laVer = explode('.',phpversion());
	if( $laVer[0] >= 5 ) {
		include_once('module.clone.v5.php');
	}else{
		include_once('module.clone.v4.php');
	}

	if( !function_exists( 'is_a' ) ) {
	 ## there is 'is_a'-function since ver. 4.2.0
		function is_a( $loSrc, $lcClass ){  
			if(is_object($loSrc)){
				if ( strtolower( get_class( $loSrc ) ) == strtolower( $lcClass ) ) {
				 return TRUE;
			 	}
			 	return is_subclass_of( $loSrc, $lcClass ); 
		 	}
		 	return FALSE;
	 	}
 	}


function checkLimit(&$number,$max=8388607,$min=-1){
	global $DEBUG;
	$ret=1;
	if(isset($number) && $number){
		if(is_numeric($number) ){
			if(($number<$min) || 
				(($min<=$max) && ($number>$max))){  // if $max < $min then skip check max-limit
				$ret=0;	
			}		
		}else{
			$ret=0;	
		}
	}else{
		$number=0;
		$ret=1;	
	}		
	if($DEBUG){
		echo "checkLimit: nuber: '$number', return $ret<br>\n";	
	}
	return $ret;
}

function istleer($var)	  {
  if (!isset($var)) 
    return true; 
  else    {
    if ($var == "") 
      return true; 
    else 
      return false;
  }
}

function ltext ( $key ){
	global $DEBUG, $show_locale_error;
	global $lang_text;

	if( $DEBUG ){
		$show_locale_error = $DEBUG;
	}

	if( strlen( $key ) > 40 ){ // check length
		$key = $show_locale_error? "($key)": '';
		return "<b><font color=\"red\">The locale key is to long $key</font></b>";
	}

	if( ! preg_match('/[-_.a-z0-9]+/i', $key ) ){ // check bad chars
		$key = $show_locale_error? "($key)": '';
		return "<b><font color=\"red\">The locale key has a bad char $key</font></b>";
	}

	$arguments = func_get_args();
	array_shift( $arguments );

	if( ! ( is_array( $lang_text ) && array_key_exists( $key, $lang_text ) ) ){ // check if the key exists
		if( $show_locale_error ){
			$key = '('.$key.': '.join( ', ', $arguments );
		}else{
			$key  = '';
		}
		$string = "<b><font color=\"red\">The locale key is unknown $key</font></b>";
		return $string;
	}

	$string = $lang_text[$key];

	$liCnt = count($arguments);
	if( $liCnt > 0 ){
		for( $i = $j = 0; $i < $liCnt; $i++, $j++ ){
			if( is_array( $arguments[$i] ) ){
				$liCnt2 = count($arguments[$i]);
				for( $k=0; $k < $liCnt2; $k++, $j++ ){
					$string = str_replace ( '$VAR['.$j.']', htmlspecialchars($arguments[$i][$k]), $string );
				}
			} else {
				$string = str_replace ( '$VAR['.$j.']', htmlspecialchars($arguments[$i]), $string );
			}
		}
	}

	return $string;
}

function get_langs($pfad = "../languages/"){
  global $langfileversion;
  $handle = opendir($pfad);
  while ($ldir = readdir($handle))
    {
      if (!eregi("\.",$ldir)) ##filters '.' and '..'
      if ( !eregi("\.",$ldir) && file_exists($pfad.$ldir."/misc.inc.php") ) ##filters '.' and '..'
	{
	  include($pfad.$ldir."/misc.inc.php");
	  if ($lang_version == $langfileversion)
	    {
	      $languages["short"][] = $lang_short;
	      $languages["nat"][] = $lang_name_nat;
	      $languages["int"][] = $lang_name_int;
				}
	}
    }
  closedir($handle);
  return $languages;
}

function licence_status ( $text, $date )
{
	$parts = explode("||", $text);
	if ( $parts[0] == "mlf" && $parts[1] == "scripts_licence_valid" )
		return ltext ( "ls_valid", array( $date ) );
	return mlf_text($text);
}

function mlf_text($text)
	{
	 $parts = explode("||", $text);
	 if ($parts[0] == "mlf")
		{
		 $varlist = "";
		 for ($i = 2; $i < count($parts); $i++)
			{
			 $varlist[] = htmlspecialchars( $parts[$i] );
			}
		 return ltext($parts[1], $varlist);
		} else
		{
		 return $text;
		}
	}

function char_crunch($text)
	{
	 $tok = strtok($text, " ");
	 while ($tok)
		{
		 $newtext .= chunk_split($tok, 15, " ");
		 $tok = strtok(" ");
		}
	 return $newtext;
	}

 function set_countdomains($kunde, $server_id = NULL){
	global $ServerID;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}
	$loUser = new SQLString( $kunde );
	$loServerID = new SQLString( $server_id );
	$id = safe_query2( "SELECT COUNT(domain) AS countdomains FROM domains ".
										 " WHERE kunde= ? AND server_id = ? ",
										 $loUser, $loServerID );
	$werte = db_fetch_array( $id );
	$countdomains = $werte[ 'countdomains' ];
	db_free_query( $id );

	if( ! $countdomains ){
		$countdomains = 0;
	}

	safe_query2( "UPDATE kunden SET countdomains = $countdomains ".
							 " WHERE kunde= ? AND server_id = ?",
							 $loUser, $loServerID );
}

function noMagic( &$string ){
	$string = str_replace("\'", "'", $string);
	$string = str_replace("\\\"", "\"", $string);
	$string = str_replace("\\\\", "\\", $string);
}

function getuid(){
	global $ServerID;
	return 0;	
	 #db_connect($GLOBALS["db_host"], $GLOBALS["db_user"], $GLOBALS["db_pass"]);
	$id = db_query("SELECT minuid, maxuid, flock FROM admin WHERE server_id='$ServerID'");
	$werte = db_fetch_array($id);
	$minuid = $werte["minuid"];
	$maxuid = $werte["maxuid"];
	$flock = $werte["flock"];
	db_free_query( $id );
	$flock2 = $flock;
	$wait = 10;
	while($flock2 != 0){
		$wait--;
		sleep(1);
		$id = db_query("SELECT flock FROM admin WHERE server_id='$ServerID'");
		$werte = db_fetch_array($id);
		db_free_query( $id );
		$flock2 = $werte["flock"];
		if ($flock2 != $flock) $wait = 10;
		if ($wait < 0){
			db_query("UPDATE admin SET flock = 0 WHERE server_id='$ServerID'");
		}
	}
	$flock = time();
	db_query( "UPDATE admin SET flock = '$flock' WHERE server_id='$ServerID'");
	$uidstring = "";
	$anzahl = 1;
	
	$id = db_query( "SELECT uid FROM pop3 WHERE server_id='$ServerID'" );
	while ($daten = db_fetch_array($id)){
		$uidstring .= "[".$daten["uid"]."]";
		$anzahl++;
	}

	$id = db_query("select uid from ftp WHERE server_id='$ServerID'");
	while ($daten = db_fetch_array($id)){
		$uidstring .= "[".$daten["uid"]."]";
		$anzahl++;
	}

	$id = db_query("select uid from kunden WHERE server_id='$ServerID'");
	while ($daten = db_fetch_array($id)){
		$uidstring .= "[".$daten["uid"]."]";
		$anzahl++;
	}

	while ($anzahl > 0){
		$newtmpuid = $anzahl + $minuid;
		$ereg = "\[".$newtmpuid."\]";
		if (! ereg($ereg, $uidstring)){ 
			$newuid = $newtmpuid;
		}
		$anzahl--;
	}
	if (($newuid > $maxuid) || ($newuid < $minuid)){
		echo "<p><b>System error:</b> no free available UIDs found</p>";
		exit();
	}
	return $newuid;
}

function freeuid(){
	global $ServerID;
#	 db_connect($GLOBALS["db_host"], $GLOBALS["db_user"], $GLOBALS["db_pass"]);
	 db_query("update admin set flock = 0 WHERE server_id='$ServerID'");
	}

function mkpasswd($pwlength) {
	srand((double)microtime()*1000000);
	$Zeichen = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	$pawd = "";
	while (strlen($pawd) < $pwlength){
		$pawd .= substr($Zeichen,(rand()%(strlen($Zeichen))),1);
	}
	return $pawd;
}

function mksalt($pwlength) {
	srand((double)microtime()*1000000);
	$Zeichen = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	$pawd = "";
	while (strlen($pawd) < $pwlength){
		$pawd .= substr($Zeichen,(rand()%(strlen($Zeichen))),1);
	}
	return $pawd;
}

function crypt_pw($plainpw) {
	global $disable_md5;
	$salt = mksalt(8);
	if ((CRYPT_MD5)					// CRYPT_MD5 = php_global_const
		&& ($disable_md5 == 0)) {	// $disable_md5 = confixx_global in settings.inc.php
		$salt = "\$1\$$salt\$";
	} else { // use STD_DES
		$salt = substr($salt,0,2);
	}
	return crypt($plainpw, $salt);
}

function valid_pw($plainpw) {
	$li_maxPwdLength = (defined('MaxPwdLength')) ? MaxPwdLength : 12;
	if ((strlen($plainpw) < 6) || (strlen($plainpw) > $li_maxPwdLength)) {
		return 0;
	} else {
		return 1;
	}
}

function sinnv_kbwert($wert, $unbegrenzt = "-1") {
	global $DEBUG;
	$kb_expr = $GLOBALS["lang_format_kb_expr"]; // misc.inc.php must to be included 102400
	$mb_expr = $GLOBALS["lang_format_mb_expr"];
	$gb_expr = $GLOBALS["lang_format_gb_expr"];
	$sep_dec = $GLOBALS["lang_format_sep_dec"];
	$sep_kilo = $GLOBALS["lang_format_sep_kilo"];
	if(  is_numeric( $wert ) ){
		if( $wert <> -1 ){
			if( ( $wert < 999 ) && ( $wert <> 0 ) ){
				$wert .= " ".$kb_expr;
			}	elseif( $wert > 999 ){
				$wert = $wert / 1024;
				if( $wert > 999 ){
					$wert = $wert / 1024;
					$gb = "yes";
				}
				if (ereg("\.",$wert)){
					$wert = number_format($wert,2,$sep_dec,$sep_kilo);
				}	else{
					$wert = number_format($wert,0,$sep_dec,$sep_kilo);
				}
				$sufix = preg_quote($sep_dec)."00";
				if (ereg($sufix,$wert))	{
					$wert = substr($wert,0,strlen($wert) - 3);
				}
				if ($gb == "yes"){
					$wert .= " ".$gb_expr;
				}	else{
					$wert .= " ".$mb_expr;
				}
			}else	{
				$wert = "0 ".$kb_expr;
			}
		}else{
			$wert = $unbegrenzt;
		}
	}else{
		if($DEBUG){
			echo "sinnv_kbwert:<br><pre>\n";
			print_r($wert);
			echo "<\pre><hr>\n";
		}
	}
	return $wert;
}

function sinnv_intwert($wert, $unbegrenzt = "-1") {
$sep_dec = $GLOBALS["lang_format_sep_dec"]; // misc.inc.php must be included
$sep_kilo = $GLOBALS["lang_format_sep_kilo"];
if ($wert <> -1)
	{
	 return number_format($wert,0,$sep_dec,$sep_kilo);
	}
else
	{
	 return $unbegrenzt;
	}
}

function get_comment($pop3) {
	$ret = '';
	if (!ereg("\@",$pop3)) {
		global $PHP_AUTH_USER;
		$id = db_query("SELECT kommentar FROM pop3 WHERE account='$pop3' and kunde='$PHP_AUTH_USER' AND server_id='$ServerID'");
		if (db_num_rows($id) > 0) {
			$werte = db_fetch_array( $id );
			$ret = $werte["kommentar"];
		}
		db_free_query( $id );
	}
	return $ret;
}

function sub_comment($comment, $maxlength) {
	if ($comment != "") {
		if (strlen($comment) > $maxlength) {
			$comment = substr($comment,0,($maxlength-3));
			$comment = trim($comment);
			return " (".$comment."..)";
		} else {
			return " (".$comment.")";
		}
	} else {
	    return "";
	}
}

function db_master_connect(){
	global $dbMasterUser, $mysqlMasterServer, $dbMasterPw, $dbMasterDB, 
		$mysqlMasterPort, $master_confixx;
	global $DEBUG;

	if( $master_confixx < 2 ){
		return db_connect();
	}

	if( array_key_exists( 'db_connection_id', $GLOBALS ) && 
			$GLOBALS['db_connection_id'] ) {
		
		$id = db_query( "SELECT DATABASE()", $GLOBALS['db_connection_id'] );
		if( $id ){
			list( $currDb ) = db_fetch_array( $id, 'N' );
			if( $DEBUG ){
				echo "db_master_connect: current database: $currDb<br>\n";
			}
			db_free_query( $id );
			if( $currDb == $dbMasterDB ){
				return $GLOBALS['db_connection_id'];
			}
		}
		mysql_close($GLOBALS['db_connection_id']);
	}  

	if ( $mysqlMasterPort ) {
		$server = $mysqlMasterServer.':'.$mysqlMasterPort;
	} else {
		$server = $mysqlMasterServer;
	}
		
	$GLOBALS['db_connection_id'] = mysql_connect($server, $dbMasterUser, $dbMasterPw) 
		or die("Verbindung zur Datenbank fehlgeschlagen!");

	$GLOBALS['db_connection_db'] = $dbMasterDB;		

	if($DEBUG){
		echo "db_master_connect: $server, $dbMasterUser, $dbMasterPw, $dbMasterDB<br>\n";
	}

	return mysql_select_db( $dbMasterDB );

}

## datenbankfunktionen
function db_connect()
{
	global $db_type, $db_user, $db_host, $db_pass, $db_db, $db_port;
	global $confixx_master, $oldServerID, $ServerID;
	global $DEBUG;

	if( $confixx_master == 2 && /* in master panel */
			$oldServerID && /* the is a saved original value */
			$oldServerID != $ServerID  /* the original values is changed */
			){
		return db_master_connect();
	}

	if (!isset($db_type)) {
		die("Database type is not defined.");

	}	elseif ( $db_type == 'mysql' ) {
		if ( array_key_exists( 'db_connection_id', $GLOBALS ) && 
				 $GLOBALS['db_connection_id'] ) {
			$id = db_query( "SELECT DATABASE()", $GLOBALS['db_connection_id'] );
			if( $id ){
				list( $currDb ) = db_fetch_array($id,'N');
				db_free_query( $id );
				if( $currDb == $db_db ){
					return $GLOBALS['db_connection_id'];
				}
			}
	    mysql_close($GLOBALS['db_connection_id']);
		}  

		if ( $db_port ) {
			$server = $db_host.':'.$db_port;
		} else {
			$server = $db_host;
		}
		
		$GLOBALS['db_connection_id'] = mysql_connect($server, $db_user, $db_pass) 
	    or die("Verbindung zur Datenbank fehlgeschlagen!");

		$GLOBALS['db_connection_db'] = $db_db;		

		if($DEBUG){
			echo "db_connect: $server, $db_user, $db_pass, $db_db<br>\n";
		}

		return mysql_select_db($db_db);
	
	} elseif ( $db_type == 'Pg' ) {
		if( array_key_exists( 'db_connection_id', $GLOBALS ) && 
				$GLOBALS['db_connection_id'] ) {
			$stat = pg_connection_status( $GLOBALS['db_connection_id'] );
			if( $stat == PGSQL_CONNECTION_OK ){
				return $GLOBALS['db_connection_id'];
			}
	    pg_close( $GLOBALS['db_connection_id'] );
		}  
		$DSN = "user=$db_user password=$db_pass dbname=$db_db";
		if( $db_host != 'localhost' ){
			$DSN .= " host=$db_host";
		}
		if ( $db_port ) {
			$DSN .= " port=$db_port"; 
		}
		$GLOBALS['db_connection_id'] = pg_connect( $DSN ) 
	    or die("Verbindung zu Datenbank fehlgeschlagen!");

		$GLOBALS['db_connection_db'] = $db_db;		

		if( $DEBUG ){
			echo "db_connect: $server, $db_user, $db_pass, $db_db<br>\n";
			echo "db_connect: OK (".$GLOBALS['db_connection_id'].")<br>\n";
		}

		return $GLOBALS['db_connection_id'];

	} elseif ( !$db_type ) {
		die('Database type is empty.');

	} else {
		die("Unsupported database type. ");
	}
}

function db_query($query_string, $show_errors = true){
	global $db_type,$confixx_master,$db_last_id;
	global $DEBUG;

	if( is_object( $show_errors ) ) { ## typo: do_query -> safe_query2
		$laArgs = func_get_args();			
		return call_user_func_array( 'safe_query2', $laArgs );
	}

	$connId = $GLOBALS['db_connection_id'];
	if( ! is_bool( $show_errors ) ){
		if( $show_errors ){
			$connId = $show_errors;
		}
		$show_errors = FALSE;
	}

	if( $DEBUG ){
		$show_errors = TRUE;
		echo "db_query: ".htmlspecialchars($query_string)."<br>\n";
	}

	if( $db_type == 'mysql' || $confixx_master == 2 ){

		if( $show_errors ){
			$db_last_id = mysql_query( $query_string, $connId );
		}else{
			$db_last_id = @mysql_query( $query_string, $connId );
		}

		if( ! $db_last_id && $show_errors ){
			$message = 'MySQL error: '.mysql_errno( $connId ).
				': '.mysql_error( $connId );
			log_debug_message( $message );
			echo $message."<br>\n";
		}

	} else{
		if( $show_errors ){
			$db_last_id = pg_exec( $connId, $query_string );
		}else{
			$db_last_id = @pg_exec( $connId, $query_string );
		}

		if( $db_last_id ){
			$iid = (int) $db_last_id;
			$counter = 'pgresindex'.$iid;
			$GLOBALS[$counter] = 0;

		}else{
			if( $show_errors ){
				$message = pg_last_error( $connId );
				log_debug_message( $message );
				echo "Error execute: $query_string: $message<br>\n";
			}
		}
	}
	if($DEBUG){
		echo "db_query: ".$db_last_id."<br>\n";
	}
	return $db_last_id;

}

function db_free_query( $id = NULL ){
	global $db_type, $DEBUG, $server_id, $db_last_id;

	if( is_null( $id ) ){
		$llClean = 1;
		$id = $db_last_id;
	} else {
		$llClean = ( (int)$db_last_id == (int)$id )? 1: 0;
	}
	if($DEBUG){
		echo "db_free_query: $id<br>\n";
	}
	if( $id && ! is_bool( $id ) ){

		if( $db_type == 'Pg' ){
			pg_free_result( $id );
		} else {
			if( $DEBUG ){
				mysql_free_result( $id );
			}else{
				@mysql_free_result( $id );
			}
		}

		if( $llClean ){
			$db_last_id = NULL;
			unset( $db_last_id );
		}
	}
}

function safe_query_error ( $show_errors, $message ){
	global $db_last_id;
  global $DEBUG; 
	if( $show_errors ){
    if( $DEBUG ){ 
	   	echo ($message);
    }
		log_debug_message($message);
	}
	return $db_last_id;
}

// this files contains types used as an arguments of safe_query
// I included them here for not to include them in each file
include_once('class.SQLString.php');
include_once('class.SQLInteger.php');
include_once('class.SQLType.php');

function safe_query ( $query_string, $show_errors = true ){
	global $DEBUG;
	global $db_type, $db_last_id;

	$arguments = func_get_args();
	if( is_object( $show_errors ) ){
		$show_errors = TRUE;
		array_splice( $arguments, 0, 1 );
	} else {
		array_splice( $arguments, 0, 2 );
	}

	$process = $query_string;
	$result = "";
	while( ( $index = strpos( $process, "?" ) ) !== FALSE ){
		$result .= substr( $process, 0, $index );
		$process = substr( $process, $index+1 );
		if( !count($arguments) ){
			return safe_query_error( $show_errors, "Error in query: Zero number of arguments in safe query: $query_string");
		}
		$type = array_shift($arguments);
		if( !is_object( $type ) ){
			return safe_query_error( $show_errors, "Error in query: $type argument is not an object in safe query: $query_string");
		}
		if( !$type->Validate() ){
			return safe_query_error( $show_errors, "Error in query: one of safe query arguments is not valid: ".$type->GetError(). " : $query_string");
		}
		$result .= $type->SQL();
	}
	$result .= $process;
	if( $DEBUG ){
	    echo "safe_query: sql: $result<br>\n";
	}
	if( $db_type == 'mysql' ){
		$db_last_id = @mysql_query( $result, $GLOBALS['db_connection_id'] );
		if( ! $db_last_id ){
			return safe_query_error( $show_errors, "Error while executing query: $result : " . mysql_error() );
		}
	} else {
		$db_last_id = pg_exec( $GLOBALS['db_connection_id'], $result );

		if( $db_last_id ){
			$iid = (int)$db_last_id;
			$counter = 'pgresindex'.$iid;
			$GLOBALS[$counter] = 0;

/*
			if( $DEBUG ){
				echo "safe_query: OK (".$db_last_id.")<br>\n";
			}
*/

		} else {
			return safe_query_error( $show_errors, 
															 "Error while executing query: $result : " . pg_last_error() );
		}
	}

	return $db_last_id;
}

/**
	the analogue of safe_query, but 
	1) will always show errors (if any)
	2) allows specifying him string/int values, not wrapper object

 	sample call: safe_query2("SELECT a FROM b WHERE c=? AND d=?", $var1, $var2);
 */
function safe_query2( $query_string ){
    global $DEBUG;
	$arguments = func_get_args();
	$arguments2 = array();		// resulting array

	array_splice( $arguments, 0, 1 );	// drop out the first parameter

	for( $i = 0, $n = count( $arguments ); $i < $n; ++$i ){
		if( is_string( $arguments[$i] ) ){
			array_push($arguments2, new SQLString($arguments[$i]));
		} elseif( is_int( $arguments[$i] ) ){
			array_push($arguments2, new SQLInteger($arguments[$i]));
		} elseif( is_object( $arguments[$i] ) && is_subclass_of( $arguments[$i], 'SQLType' ) ){
			array_push( $arguments2, $arguments[$i] );	// already wrapped with object
		} else {
			array_push( $arguments2, new SQLString( $arguments[$i] ) );
		}
	}
	array_unshift($arguments2, $query_string, TRUE); // prepend list of vars by implied values
	return call_user_func_array( 'safe_query', $arguments2 );
}

function db_fetch_array($id, $type = 'B'){
	global $db_type;
	if ($db_type == "mysql"){
		switch( $type){
		case 'A':
			return mysql_fetch_array( $id, MYSQL_ASSOC );
		case 'N':
			return mysql_fetch_array( $id, MYSQL_NUM );
		default:
			return mysql_fetch_array( $id );
		}
	} else{
		if (!$id){
			return false;
		}
		$iid = 0+$id;
		$counter = "pgresindex".$iid;
		$rows = pg_numrows($id);

		if( ! array_key_exists( $counter, $GLOBALS ) ){
			$GLOBALS[$counter] = 0;
		}

		if( $rows > $GLOBALS[$counter] ){
			switch( $type ){
			case 'A':
				$array = pg_fetch_array($id, $GLOBALS[$counter], PGSQL_ASSOC );
				break;
			case 'N':
				$array = pg_fetch_array($id, $GLOBALS[$counter], PGSQL_NUM );
				break;
			default:
				$array = pg_fetch_array($id, $GLOBALS[$counter]);
			}
			if ( $array ){
				$GLOBALS[$counter]++;
				return $array;
			} else{
				$GLOBALS[$counter] = 0;
			}
		} else{
			$GLOBALS[$counter] = 0;
		}
	}
}


function db_fetch_array_all( $id, $type = 'B' ){
  $laRows = array();
  while( $laRow = db_fetch_array( $id, $type ) ){
    $laRows[] = $laRow;
  }
  return $laRows;
}

function db_close($id = NULL ){
	global $db_type;

	db_free_query();

	if( is_null( $id ) ){
		$id = $GLOBALS["db_connection_id"];
	}
	if ($db_type == "mysql"){
#		 return mysql_close($id);	# nicht noetig

	} else	{
#		 return pg_close($id);
		}
	}

function db_error( $id = NULL ){
	global $db_type, $db_last_id;
	 if( $db_type == 'mysql' ){
	 	 if( is_null( $id ) ){
			 $id = $db_last_id;
		 }
		 return mysql_error( $id );
	 } else {
	 	 if( is_null( $id ) ){
			 $id = $GLOBALS["db_connection_id"];
		 }
		 return pg_errormessage($id);
		}
	}

function db_num_rows($id)
	{
	 global $db_type;
	 if ($db_type == "mysql")
		{
		 return mysql_num_rows($id);
		} else
		{
		  if($id){
		    return pg_numrows($id);
		  }else{
		    return false;
		  }
		}
	}

 function db_insert_id($sequenz_name, $field = ""){
   global $db_type;
	 global $master_confixx;

   global $DEBUG;
   if ($db_type == 'mysql' || $master_confixx == 2 ){
     return mysql_insert_id();
   } else{
     if($field){
       $sequenz_name.='_'.$field.'_seq';
     }
     $pg_id = pg_exec($GLOBALS["db_connection_id"], "SELECT last_value FROM $sequenz_name");
     if($pg_id){
       $ret=pg_result($pg_id, 0, 0);
     }else{
       if($DEBUG){
	 echo "Error get last ID from: '$sequenz_name'<br>\n";
       }
       $ret=false;
     }
     return $ret;
   }
 }

# converts unix timestamp to full TIMESTAMP type value 
# of the current DBMS (mysql/posgresql)
function db_timestamp($unix_timestamp)
{
	global $db_type;
	if ($db_type == "mysql") {
		return date('YmdHis', $unix_timestamp);		# mysql
	} else {
		return date('Ymd His', $unix_timestamp);	# postgresql (with space between date and time)
	}
}
## //

function domain_aendern( $domain, $aktion, $kunde, $server_id=NULL ){
	global $ServerID;
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loDomain = new SQLString( $domain );
	$loServerID = new SQLString( $server_id );
	$loKunde = new SQLString($kunde);

	$id = safe_query2( " SELECT COUNT(*) FROM domains WHERE domain=? ".
										 " AND domain NOT LIKE '*.%' AND kunde = ? AND richtigedomain <> 7 AND server_id=?", 
										 $loDomain, $loKunde, $loServerID);
	list( $cnt ) = db_fetch_array( $id );
	db_free_query( $id );

	if( $cnt > 0 ){

		if( $aktion == 'anlegen' ){
			$id = safe_query2( "SELECT COUNT(*) FROM domainlog WHERE domain=? AND neu = 1 AND server_id=?", 
												 $loDomain, $loServerID );
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );

			if( $cnt ){
				safe_query2( "UPDATE domainlog SET kunde = ?, neu = 1 WHERE domain = ? AND server_id=?", 
										 $loKunde, $loDomain, $loServerID );
			} else{
				safe_query2( "INSERT into domainlog (kunde, neu, domain, loeschen,server_id) VALUES (?, 1, ?, 0,?)",
										 $loKunde, $loDomain, $loServerID);
				safe_query2( "UPDATE allgemein SET domains = 1 WHERE server_id=?",
										 $loServerID);
			}

		} else {
			$id = safe_query2( "SELECT COUNT(*) FROM domainlog WHERE domain=? AND loeschen = 1 AND server_id=?", 
												 $loDomain,$loServerID);
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );
			if( $cnt ){
				safe_query2( "DELETE FROM domainlog WHERE domain = ? AND neu = 1 AND server_id=?", $loDomain, $loServerID);

			} else { 
				safe_query2( "INSERT INTO domainlog (kunde, loeschen, domain, neu,server_id) VALUES (?, 1, ?, 0,?)",
										 $loKunde, $loDomain, $loServerID );
				safe_query2( "UPDATE allgemein SET domains = 1 WHERE server_id=?",
										 $loServerID );
			}
		}
	}
}

function fpalias_aendern($domain, $aktion, $kunde, $server_id=NULL) {
	global $ServerID;
	
	if( ! $server_id ){
		$server_id = $ServerID;
	}

	$loKunde = new SQLString( $kunde );
	$loServerID = new SQLString( $server_id );
	 ## frontpage aliase
	$fpid = safe_query2( "SELECT frontpage, anbieter FROM kunden ".
											 " WHERE kunde = ? AND server_id=?", 
											 $loKunde, $loServerID );
	list($frontpage,$anbieter) = db_fetch_array($fpid,'N');
	db_free_query( $fpid );

	$loRes = new SQLString($anbieter);

	$add = 0;
	$del = 0;
	if( $frontpage != 1 ) {
		return;
	}
	$loDomain = new SQLString($domain);
	## nicht ssl domains
	$id = safe_query2( "SELECT COUNT(*) FROM domains WHERE domain = ? AND pfad = '/'".
										 " AND domain NOT LIKE '*.%' AND cssl = 0 AND server_id=?",
										 $loDomain, $loServerID );
	list($cnt) = db_fetch_array( $id );
	db_free_query( $id );

	if( $cnt ) {

		if( $aktion == 'anlegen')	{ ## anlegen
			$id = safe_query2( "SELECT COUNT(*) FROM frontpagealias WHERE domain = ? ".
												 "AND kunde = ? AND loeschen = 1 AND port=80 AND server_id=?", $loDomain, $loKunde, $loServerID );
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );
			if( $cnt == 0){
				safe_query2( "INSERT INTO frontpagealias (domain, kunde, anbieter, port, neu, loeschen,server_id) ".
										 "VALUES (?, ?, ?, 80, 1, 0, ?)", 
										 $loDomain, $loKunde, $loRes, $loServerID);
				$add++;
				
			} else {
				safe_query2( "DELETE FROM frontpagealias WHERE domain = ? AND kunde = ? AND port=80 AND server_id=?",
										 $loDomain, $loKunde, $loServerID);
			}
			
		} else { ## loeschen
			$id = safe_query2( "SELECT COUNT(*) FROM frontpagealias WHERE domain = ? AND kunde = ?".
												 " AND neu = 1 AND port = 80 AND server_id=?", 
												 $loDomain, $loKunde, $loServerID );
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );

			if( $cnt == 0){
				safe_query2( "INSERT INTO frontpagealias (domain, kunde, anbieter, port, neu, loeschen,server_id) ".
								 "VALUES (?, ?, ?, 80, 0, 1, ?)", 
										 $loDomain, $loKunde, $loRes, $loServerID );
				$del++;

			} else {
				safe_query2( "DELETE FROM frontpagealias WHERE domain = ? AND kunde = ? AND port = 80 AND server_id=?",
										 $loDomain, $loKunde, $loServerID );
			}
		}
	}
		 ## ssl domains

	$id = safe_query2( "SELECT COUNT(*) FROM domains WHERE domain = ? and pfad = '/'".
										 " AND domain NOT LIKE '*.%' AND cssl = 1 AND server_id=?",
										 $loDomain,$loServerID);
	list($cnt) = db_fetch_array( $id );
	db_free_query( $id );
	if( $cnt > 0)	{
		if ($aktion == 'anlegen') { ## anlegen
			$id = safe_query2( "SELECT COUNT(*) FROM frontpagealias WHERE domain = ? ".
												 "AND kunde = ? AND loeschen = 1 AND port=443 AND server_id=?", 
												 $loDomain, $loKunde, $loServerID );
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );
			if( $cnt == 0) {
				safe_query2( "INSERT INTO frontpagealias (domain, kunde, anbieter, port, neu, loeschen,server_id) ".
										 " VALUES (?, ?, ?, 443, 1, 0,?)", 
										 $loDomain, $loKunde, $loRes, $loServerID );
				$add++;

			} else {
				safe_query2( "DELETE FROM frontpagealias WHERE domain = ? AND kunde = ? AND port = 443 AND server_id=?",
										 $loDomain, $loKunde, $loServerID);
			}
			
		} else { ## loeschen
			$id = safe_query2( "SELECT COUNT(*) FROM frontpagealias WHERE domain = ? ".
												 " AND kunde = ? AND neu = 1 AND port = 443 AND server_id=?",
												 $loDomain, $loKunde, $loServerID);
			list($cnt) = db_fetch_array( $id );
			db_free_query( $id );
			if( $cnt == 0){
				safe_query2( "INSERT INTO frontpagealias (domain, kunde, anbieter, port, neu, loeschen, server_id)".
										 " VALUES (?, ?, ?, 443, 0, 1, ?)", 
										 $loDomain, $loKunde, $loRes, $loServerID);
				$del++;
			} else {
				safe_query2( "DELETE FROM frontpagealias WHERE domain = ? AND kunde = ? AND port = 443 AND server_id=?",
										 $loDomain, $loKunde, $loServerID);
			}
		}
	}

	$set = array();
	if( $add > 0 ){
		$set[] = "fpaliasadd = 1";
	}
	if( $del > 0 ){
		$set[] = "fpaliasdel = 1";
	}
	if( count($set) ){
		safe_query2( "UPDATE allgemein SET ".join(',',$set)." WHERE server_id=?",
								 $loServerID );
	}
}

function getVersionNumber( $pcVer ){
	global $DEBUG;
	if(preg_match('/^\s*(\d+)\.(\d+)\.?(\d+)?/', $pcVer, $laChunks)){
		$liNumber =  $laChunks[1]+ $laChunks[2]*0.001;
		if( $laChunks[3]){
			$liNumber += $laChunks[3]*0.000001;
		}
	}else{
		list($liNumber,$lcTail) = split( '-', $pcVer, 2);
	}
	/*
	if($DEBUG){
		echo "getVersionNumber: $pcVer<br><pre>\n";
		print_r($laChunks);
		echo "</pre><hr>\n";
	}
	*/
	return $liNumber;
}
	
function compare_confixx_version( $pcVersion ){
	global $version;
	return getVersionNumber($pcVersion)> getVersionNumber( $version )?1:0;
}

function check_new_versions(){
	global $db_type, $version;
	global $DEBUG,$ServerID;

	$versions = false;

	if( $db_type == 'Pg' ){
		$id = db_query( "SELECT id, version FROM updates WHERE 'new' = 1 AND server_id='$ServerID'");
	}else{
		$id = db_query( "SELECT id, version FROM updates WHERE new = 1 AND server_id='$ServerID'");
	}
	if( db_num_rows($id) ){
		$liCurVersion = getVersionNumber( $version );

		/*
		if($DEBUG){
			echo "current version: $version ($liCurVersion)<br>\n";
		}
		*/

		while ($werte = db_fetch_array($id)){
			$liNewVersion = getVersionNumber( $werte['version'] );

			/*
			if($DEBUG){
				echo "new version: ".$werte['version']." ($liNewVersion)<br>\n";
			}
			*/

			if( $liNewVersion > $liCurVersion ){
				$versions[$werte['id']] = $werte['version'];
			}
		}	
	}
	db_free_query( $id );
	return $versions;	
}

function sendPhpHeaders(){
	header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );
	header( "Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT" ); // always modified
	header( "Cache-Control: no-store, no-cache, must-revalidate" );  // HTTP/1.1
	header( "Pragma: no-cache" );                          // HTTP/1.0
}

function newLocation($url){

	sendPhpHeaders();

  echo "<html>\n<head>\n";
  echo "\t<meta http-equiv=\"refresh\" content=\"1, URL=$url\">\n";
  echo "</head>\n<body onLoad=\"location.href='$url'\">\n";
  echo "<a href=\"$url\">$url</a>\n";
  echo "</body>\n</html>\n";

}

function log_debug_message($msg) {
	$stderr = fopen('php://stderr', 'w');
	$today = date("D M j G:i:s T Y");   	
	fwrite($stderr,"[$today] confixx: $msg\n");
	fclose($stderr); 
}

#
# user's MySQL
#

function userdb_connect( $show_errors = true ) {
	global $mysql_user_user, $mysql_user_host, 
		$mysql_user_pass, $mysql_user_port;
	global $db_type;

	if ( $mysql_user_port ) {
		$server = $mysql_user_host.':'.$mysql_user_port;
	} else {
		$server = $mysql_user_host;
	}
		
	$GLOBALS['mysql_connection_id'] = mysql_connect( $server, 
																									 $mysql_user_user, 
																									 $mysql_user_pass);

	if ( $GLOBALS['mysql_connection_id']) {
		if( $db_type == 'mysql' ){  ## restore default link to database
			db_connect( $db_host, $db_user, $db_pass);
		}
		
		$GLOBALS['mysql_connection_db'] = 'mysql';

		return mysql_select_db( 'mysql', $GLOBALS['mysql_connection_id'] );

	} else {
		if ($show_errors ) {
			$message = mysql_error();
			log_debug_message( $message );
			echo $message;
		}
		return NULL;
	}
}

function userdb_has_connect(){
	return $GLOBALS['mysql_connection_id']?1:0;
}

function userdb_query ($query_string, $show_errors = true) {

	global $DEBUG;

	if ( $DEBUG ) {
		echo "user's mysql: $query_string<br>\n";
		$show_errors = true;
	}

	$GLOBALS['mysql_last_id'] = mysql_query( $query_string, 
																						$GLOBALS['mysql_connection_id']
																						);

	if ( $DEBUG ) {
		echo "user's mysql: resurce id: ".$GLOBALS['mysql_last_id']."<br>\n";
	}
	if ( !$GLOBALS['mysql_last_id'] && $show_errors ) {
		$message = mysql_error();
#		log_debug_message( $message );
		echo $message;
	}
	return $GLOBALS['mysql_last_id'];

}

function userdb_close() {
	global $db_type;
	if (isset($GLOBALS['mysql_connection_id']) && $GLOBALS['mysql_connection_id'] ) {
		userdb_query( "FLUSH PRIVILEGES" );
		if( $db_type != 'mysql' ){
			mysql_close( $GLOBALS['mysql_connection_id'] );
		}
	}  
}


function prepMasterURL( $srcURL, $confixxDomain = NULL ){
	global $master_confixx, $ServerID;

	if( $master_confixx == 2 
	    && strpos( $srcURL , 'http://') !== 0 
	    && strpos( $srcURL , 'https://') !== 0 ){

		if( ! $confixxDomain ){
			$id = db_query("SELECT confixx_domain FROM admin WHERE server_id='$ServerID'");
			list( $confixxDomain ) = db_fetch_array( $id, 'N' );
			db_free_query( $id );
		}

		if( strpos( $srcURL, '/' ) === 0 ){
			$srcURL = 'http://'.$confixxDomain.$srcURL;

		}else{
			$lcScript = basename( $_SERVER['PHP_SELF'] );
			list( $lcUriDir, $lcArgs ) = explode( $lcScript, $_SERVER['REQUEST_URI'], 2);
			$srcURL = 'http://'.$confixxDomain.$lcUriDir.$srcURL;
		}

	}
	return $srcURL;
}
	

} // end of twice include protection block

//
// Fix for PHP 4.1.2
//
if( ! function_exists( 'file_get_contents' ) ){
	function file_get_contents( $pcFile = null ){
	  if( is_string( $pcFile ) ){
  	  return implode( '', file( $pcFile ) );
	  }
	}
}

//
// Fix for PHP 4.1.2
//
if( ! function_exists( 'debug_backtrace' ) ){
  function debug_backtrace(){
      return array();
  }
}

function getErrorMessage(){
	global $fehlertext, $fehlertitle;
	global $error_text, $error_title, $error_args;
  
	if( $error_text ){
		$fehlertext = ltext( $error_text, explode( '|', $error_args ) );
	}else{
		$fehlertext = NULL;
	}

	if( $error_title ){
		$fehlertitle = ltext( $error_title );
	}else{
		$fehlertitle = NULL;
	}
 
}

/**
 * Checks if $pcPath is local Confixx path
 *
 * @param  string $pcPath
 * @return bool
 *
 */
function isSafePath( $pcPath ){

  if( strpos( $pcPath, '/' ) === false ){
        return true;
  }

  return false;
}

?>
