<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ListColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.CompoundDataField.php" );





class CompoundColumn extends ListColumn
{

    /* -------------------- Members -------------------- */
    var $ma_Columns; // contains columns
    var $ms_Separator; // separator to use between columns
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function CompoundColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
	    $ps_ID=NULL )
    {
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->ClearColumns ();
	$this->SetSeparator ( ", " );
	$this->SetWithLabel ( FALSE );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- methods to manage columns -------------------- */
    function AddColumn ( $po_Column )
    {
	$this->ma_Columns[] = $po_Column;
    }

    function ClearColumns ()
    {
	$this->ma_Columns = array();
    }

    function CallOnColumns ( $ps_Method )
    {
	$la_Arguments = func_get_args();
	array_shift ($la_Arguments);
	for ( $i=0; $i<count($this->ma_Columns); $i++ )
	    call_user_func_array ( array( &$this->ma_Columns[$i], $ps_Method ), $la_Arguments );
    }
    /* -------------------- end methods to manage columns -------------------- */





    /* -------------------- separator -------------------- */
    function SetSeparator ( $ps_Separator )
    {
	$this->ms_Separator = $ps_Separator;
    }

    function GetSeparator()
    {
	return $this->ms_Separator;
    }
    /* -------------------- end separator -------------------- */





    /* -------------------- Set... -------------------- */
    function SetFromArray ( $pa_Data, $ps_ID )
    {
	$this->CallOnColumns ( "SetFromArray", $pa_Data, $ps_ID );
	ListColumn::SetFromArray ( $pa_Data, $ps_ID );
    }

    function SetFromPostGet ()
    {
	$this->CallOnColumns ( "SetFromPostGet" );
	ListColumn::SetFromPostGet ();
    }

    function SetInput ( $ps_Input )
    {
	$this->CallOnColumns ( "SetInput", $ps_Input );
	ListColumn::SetInput ( $ps_Input );
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- Is... -------------------- */
    function IsSetInQuery ()
    {
	for ( $i=0; $i<count($this->ma_Columns); $i++ )
	    if ( $this->ma_Columns[$i]->IsSetInQuery() )
		return TRUE;
	return ListColumn::IsSetInQuery();
    }
    /* -------------------- end Is... -------------------- */





    /* -------------------- GetHTML & related -------------------- */
    function GetHTML()
    {
	$la_Result = array();
	for ( $i=0; $i<count($this->ma_Columns); $i++ )
	{
	    $ls_Append = $this->GetWithLabel() ? $this->ma_Columns[$i]->GetLabel() : "";
	    $ls_Append .= $this->ma_Columns[$i]->GetHTML();
	    if ( strlen($ls_Append) )
		$la_Result[] = $ls_Append;
	}
	return implode ( $this->GetSeparator(), $la_Result );
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		$lo_Result = new CompoundDataField();
		for ( $i=0; $i<count($this->ma_Columns); $i++ ) {
			if( $this->GetWithLabel() ) {
				$lo_Field = new CompoundDataField();
				$lo_Field->SetSeparator( " " );
				$lo_Field->AppendToContent( $this->ma_Columns[$i]->GetLabelDataField() );
				$lo_Field->AppendToContent( $this->ma_Columns[$i]->GetDataField() );
				$lo_Result->AppendToContent( $lo_Field );
				
			}
			else
				$lo_Result->AppendToContent( $this->ma_Columns[$i]->GetDataField() );
		}
		$lo_Result->SetSeparator( $this->GetSeparator() );
		return $lo_Result;
	}
    /* -------------------- end GetHTML & related -------------------- */





    /* -------------------- GetValue -------------------- */
    function GetValue()
    {
	if ( ! is_null($this->GetName()) )
	    return ListColumn::GetValue();
	foreach ( $this->ma_Columns as $lo_Column )
	    if ( ! is_null($lo_Column->GetName()) )
		return $lo_Column->GetValue();
	return ListColumn::GetValue();
    }


		function &getColumn( $piInd=NULL ){
			if( is_numeric( $piInd ) ){
				if( ( $piInd >= 0 ) && 
						( $piInd < count($this->ma_Columns) ) 
						){
					return $this->ma_Columns[$piInd];
				} else {
					return NULL;
				}
			}else{
				return $this->ma_Columns;
			}
		}
    /* -------------------- end GetValue -------------------- */
    
}
?>
