<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Validator.php" );





class DefinableValidator extends Validator
{

    /* -------------------- Members -------------------- */
    var $ms_Label; // label of the field
    var $ms_LabelEmpty; // which value of label is considered as empty
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function DefinableValidator ( $ps_Required, $ps_Empty="" )
    {
	$this->Validator ( $ps_Required, $ps_Empty );
	$this->SetLabel ("");
	$this->SetLabelEmpty ("");
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Set.../Get... -------------------- */
    function SetLabel ( $ps_Label )
    {
	$this->ms_Label = $ps_Label;
    }

    function GetLabel()
    {
	return $this->ms_Label;
    }

    function SetLabelEmpty ( $ps_Empty )
    {
	$this->ms_LabelEmpty = $ps_Empty;
    }

    function GetLabelEmpty()
    {
	return $this->ms_LabelEmpty;
    }
    /* -------------------- end Set.../Get... -------------------- */





    /* -------------------- definition of "abstract" methods -------------------- */
    function Validate ( $ps_Value )
    {
	if ( $this->GetLabel() == $this->GetLabelEmpty() )
	    return TRUE;
	return $this->GetEmpty() != $ps_Value;
    }
    /* -------------------- end definition of "abstract" methods -------------------- */

}
?>
