<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





class FormPageAbstractRow{

    /* -------------------- Members -------------------- */
    var $ms_Wide; // if TRUE, then row fill both columns of table
    var $mo_Field; // object of type ListColumn
    var $ma_Attributes; // additional attributes for <tr>
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function FormPageAbstractRow ( $po_Field, $ps_Wide=FALSE, $pa_Attributes=array() )
    {
	$this->SetField ($po_Field);
	$this->SetWide ($ps_Wide);
	$this->SetAttributes ($pa_Attributes);
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get.../Set... -------------------- */
    function SetWide ( $ps_Wide )
    {
	$this->ms_Wide = $ps_Wide;
    }

    function GetWide()
    {
	return $this->ms_Wide;
    }

    function SetField ( $po_Field )
    {
	$this->mo_Field = $po_Field;
    }

    function GetField ()
    {
	return $this->mo_Field;
    }

    function GetAttributes()
    {
	return $this->ma_Attributes;
    }

    function SetAttributes ( $pa_Attributes )
    {
	$this->ma_Attributes = $pa_Attributes;
    }
    /* -------------------- end Get.../Set... -------------------- */





    /* -------------------- CallOnField -------------------- */
    function CallOnField ( $ps_Method, $ps_DefaultValue=NULL )
    {
	if ( is_null($this->mo_Field) )
	    return $ps_DefaultValue;
	$la_Arguments = func_get_args();
	array_splice ( $la_Arguments, 0, 2 );
	return call_user_func_array ( array( &$this->mo_Field, $ps_Method ), $la_Arguments );
    }
    /* -------------------- end CallOnField -------------------- */





    /* -------------------- GetAttributesHTML & related -------------------- */
    // "static"
    function GetAttributesHTML ( $pa_Attributes )
    {
	$ls_Result = "";
	foreach ( $pa_Attributes as $ls_Key => $ls_Value )
	    $ls_Result .= " $ls_Key=\"" . $ls_Value . "\"";
	return $ls_Result;
    }

    function GetTRHTML()
    {
	return FormPageAbstractRow::GetAttributesHTML ( $this->ma_Attributes );
    }
    /* -------------------- end GetAttributesHTML & related -------------------- */





    /* -------------------- GetRequiredHTML & related -------------------- */
    function GetRequiredHTML ()
    {
	if ( ( $lo_Validator = $this->CallOnField("GetValidator") ) && $lo_Validator->GetRequired() )
	    return " <sup class=required>*</sup>";
	return "";
    }

    function GetErrorHTML ( $ps_ErrorFields )
    {
	if ( !$ps_ErrorFields || $this->CallOnField("IsValid",TRUE) )
	    return "";
	return " class=required";
    }
    /* -------------------- end GetRequiredHTML & related -------------------- */





    /* -------------------- "Abstract" methods -------------------- */
    function GetHTML ( $ps_ErrorFields )
    {
	echo ( "method GetHTML should return HTML of row" );
    }

	// method that maps old classes to include/elements/*
	function AppendToData( &$po_Data ) {
		echo( "method AppendToData should append row!" );
	}
    /* -------------------- end "Abstract" methods -------------------- */

}
?>
