<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( dirname(__FILE__) ."/db/class.DBConnect.php");

class CBasePgsql{
  var  $query_class = 'CPgsqlQuery';
	
  var $handle;
  var $errno;
  var $errstr;
  var $quc = 0;	
	var $moDBConnect;

  function CBasePgsql($pcHost, $pcUser, $pcPass, $pcDB, $pcPort){
		global $DEBUG;

		$this->moDBConnect = new DBConnect ( 'Pg', 
																					$pcHost, 
																					$pcUser, 
																					$pcPass, 
																					$pcDB,
																					$pcPort );


		$this->handle = $this->moDBConnect->ConnectionId();

    if(!$this->handle ) {
      echo "Error connect to Confixx DB (host: $pcHost, dbname=$pcDB, user=$pcUser, port=$pcPort)<br>";
    }
  }
	
  function getLimit($pagesize, $pagenum) {

    return " LIMIT $pagesize offset ".($pagenum * $pagesize);
  }

  function &Select($query, $pagesize = 0, $pagenum = 0)	{

    if(isset($GLOBALS['DEBUG']) && $GLOBALS['DEBUG']) echo $query.'<br>';
    $qc = false;
    
    if($pagesize > 0){
      $query .= $this->getLimit($pagesize, $pagenum);
    }
    if(isset($GLOBALS['DEBUG']) && $GLOBALS['DEBUG']) 
      echo "query after limit: " . $query.'<br>';
    
    if($res = @pg_query($this->handle,$query )){
      $this->quc++;
      $qc =& new $this->query_class($res);
      /*
       if(!$qc->getNumRows()){
       $qc->Close();
       $qc = false;
       }
      */
    }else{
      $this->errno = pg_result_status();
    }
    return $qc;
  }
	
  function Insert($query){
    //if($this->Execute($query))
    //{
    //	return $this->LastID();
    //}
    return $this->Execute($query);
    //return false;
  }
  
  function Update($query){
    return $this->Execute($query);
  }
	
  function Delete($query){
    return $this->Execute($query);
  }
	
  function Execute($query){
    if(isset($GLOBALS['DEBUG']) && $GLOBALS['DEBUG']) echo $query.'<br>';
    if(@pg_query($this->handle,$query )){
      $this->quc++;
      return true;
    }else{
      $this->errno = pg_result_status();
      return false;
    }
  }

  function lockTables ( $read, $write=array() )	{
    
    if ( !count($read) && !count($write) )
      return true;

    $readOK = array_map ( array( &$this, "appendRead" ), 
			is_array($read) ? $read : array($read) 
			);
    

    $writeOK = array_map ( array( &$this, "appendWrite" ), 
			 is_array($write) ? $write : array($write) 
			 );
    return array_merge( $readOK, $writeOK );
    
  }

  function unLockTables(){
    return $this->Execute ( "UNLOCK TABLES" );
  }

  function appendRead ( $value ) // to help lockTables
  {
    $sql ='LOCK TABLE '. $value.' IN SHARE MODE';
    return $this->Execute ( $sql );
  }

  function appendWrite ( $value ) // to help lockTables
  {
    $sql ='LOCK TABLE '.$value.' IN EXCLUSIVE MODE';
    return $this->Execute ( $sql );
  }
	
  function getLastID( $sequence, $field=''){
		global $DEBUG;
    if($field){
      $sequence=$sequence.'_'.$field.'_seq';
    }

		$lcSQL = "SELECT last_value FROM $sequence";
		if($DEBUG){
			echo "Pgsql::getLastID : $lcSQL<br>\n";
		}
    $res = pg_query( $this->handle, $lcSQL );
		if( $res ){
			if( @pg_num_rows( $res ) ) {
				$ret=@pg_fetch_result($res,0,0) ;
			}
			@pg_free_result($res);
    }
    return $ret;
  }

  function Quote($str){
    return addslashes($str);
  }
	
  function Close(){
    if( $this->handle ){
      @pg_close($this->handle);
    }
  }

	function finish(){
		$this->Close();
	}
}

class CPgsqlQuery{

  var $errno;
  var $errstr;
  var $result;
	var $num_rows;
  var $thisrow = -1;

// var $row;
	
  function &getNumRows(){
    if( $this->result ){
			$this->num_rows = pg_num_rows( $this->result );
    }else{
     $this->num_rows = FALSE;
		}
		return $this->num_rows;
  }

	
  //function getValue($name)
  //{
  //return $this->row[$name];
  //}
	
  function &nextrow( $type = 'B' ){
		global $DEBUG;
    if( $this->result && $this->thisrow < $this->num_rows ){
			switch( $type ){
			case 'A':
				return pg_fetch_array( $this->result, $this->thisrow++, PGSQL_ASSOC );
				break;
			case 'N':
				return pg_fetch_array( $this->result, $this->thisrow++, PGSQL_NUM );
				break;
			default:
				return pg_fetch_array( $this->result, $this->thisrow++ );
			}
    } else {
      return NULL;
    }
  }
	
  function &getAll( $type = 'B' ){
    $all = array();
    $this->thisrow=0;
    while( $arr = $this->nextrow( $type ) ){
      $all[] = $arr;
    }
    if( count($all) ){
      return $all;	
    }else{
      return false;	
    }
  }
	
  function CPgsqlQuery( &$res ){
    $this->result = &$res;
    $this->thisrow = 0;
		$this->num_rows = pg_num_rows( $this->result );
  }
	
  function Close(){
    if($this->result){
      @pg_free_result($this->result);
      $this->result=false;
      $this->thisrow=-1;
    }
  }
}



function &get_db_connection(){

  static $db_connection;
  global $db_db, $db_host, $db_user, $db_pass, $db_port;
  if( !isset($db_connection) ){
    $db_connection = new CBasePgsql($db_host, $db_user, $db_pass, $db_db, $db_port); 
  }

  return $db_connection;
}

function db_quote($str)
{
  return CBasePgsql::Quote($str);
}

/*
$db_db = 'confixx';
$db_host = 'localhost';
$db_user = 'root';
$db_pass = 'pass';
*/
//$db_connection = new CBasePgsql($db_host, $db_user, $db_pass, $db_db); 

//$DATABASE_CONNECTION = new CBasePgsql($db_host, $db_user, $db_pass, $db_name);
/*
if($rs = $DATABASE_CONNECTION->Select('select a,b from aaa'))
{
	do {
		echo $rs->getValue('a');
	
	} while ($rs->nextrow());
}
*/


?>
