<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( dirname(__FILE__) . "/class.ResellerLimitColumn.php" );
include_once( dirname(__FILE__) . "/elements/data/class.KBLimitDataField.php" );

class ResellerMailSpaceColumn extends ResellerLimitColumn
{
  /**
   * Constructor
   */
  function ResellerMailSpaceColumn( $ps_Name, $ps_Label, $ps_Value, 
                                      $pa_Attributes = array(), $ps_Width = NULL,
	                                    $ps_Align = NULL, $ps_ID = NULL )
  {
    $this->ResellerLimitColumn ( $ps_Name, $ps_Label, $ps_Value, 
                                 $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    $this->CallOnValidator ( "SetMaximum", 0x7FFFFFFF );
  }

  function GetHTML()
  {
    global $popkbtyp, $lang_format_mb_expr, $lang_format_kb_expr;
      
    if( ! $this->GetInput() ){
      return ResellerLimitColumn::GetHTML();
    }
      
    $ls_More = $this->GetAttributesHTML();
      
    switch ( $popkbtyp ){
      case "MB":
        $ls_MB = "selected";
        $ls_KB = "";
      break;
      case "KB":
      default:
        $ls_MB = "";
        $ls_KB = "selected";
      break;
    }
      
    return '<input name="'.htmlspecialchars( $this->GetName() ).'" value="'. 
            htmlspecialchars( $this->GetValue() ).'" $ls_More>'. 
           '<select name="popkbtyp"><option value=MB ' . $ls_MB . '>'.$lang_format_mb_expr.
           '</option><option value=KB '.$ls_KB.'>'.$lang_format_kb_expr.'</option></select>';
  }

	/**
   *  Method that maps old classes to include/elements/*
   */
	function GetDataField()
  {
		global $popkbtyp, $lang_format_mb_expr, $lang_format_kb_expr, $lang_format_gb_expr;
    
		$ls_Value = $this->GetValue();
    
		if( $ls_Value > 0 ){
			switch( $popkbtyp ){
				case "MB":
					$ls_Value *= 1024;
					break;
				case "GB":
					$ls_Value *= 1024*1024;
					break;
			}
    }
      
		$lo_Result = new KBLimitDataField( $this->GetPureName(), "popkbtyp", $ls_Value, $popkbtyp );
		$lo_Result->AppendToOptions( array( "KB" => $lang_format_kb_expr, 
                                        "MB" => $lang_format_mb_expr,
					                              "GB" => $lang_format_gb_expr ) );
		return $lo_Result;
	}
}
?>
