<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ResellerLimitColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.KBLimitDataField.php" );





class ResellerStorageColumn extends ResellerLimitColumn
{

    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ResellerStorageColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	    $ps_Align=NULL, $ps_ID=NULL )
    {
	$this->ResellerLimitColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->CallOnValidator ( "SetMaximum", 0x7FFFFFFF );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- GetHTML & related -------------------- */
    function GetHTML()
    {
	global $kbtyp, $lang_format_mb_expr, $lang_format_kb_expr;
	if ( ! $this->GetInput() )
	    return ResellerLimitColumn::GetHTML();
	$ls_More = $this->GetAttributesHTML();
	switch ( $kbtyp )
	{
	    case "MB":
		$ls_MB = "selected";
		$ls_KB = "";
		break;
	    case "KB":
	    default:
		$ls_MB = "";
		$ls_KB = "selected";
		break;
	}
	return "<input name=\"" . htmlspecialchars($this->GetName()) . "\" value=\"" . htmlspecialchars($this->GetValue())
		. "\" $ls_More> " . '<select name="kbtyp"><option value=MB ' . $ls_MB . '>' . $lang_format_mb_expr .
		'</option><option value=KB ' . $ls_KB . '>' . $lang_format_kb_expr . '</option></select>';
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		global $kbtyp, $lang_format_mb_expr, $lang_format_kb_expr, $lang_format_gb_expr;
		$ls_Value = $this->GetValue();
		if( $ls_Value > 0 )
			switch( $kbtyp ) {
				case "MB":
					$ls_Value *= 1024;
					break;
				case "GB":
					$ls_Value *= 1024*1024;
					break;
			}
		$lo_Result = new KBLimitDataField( $this->GetPureName(), "kbtyp", $ls_Value, $kbtyp );
		$lo_Result->AppendToOptions( array( "KB"=>$lang_format_kb_expr, "MB"=>$lang_format_mb_expr,
					"GB"=>$lang_format_gb_expr ) );
		return $lo_Result;
	}
    /* -------------------- end GetHTML & related -------------------- */

}
?>
