<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ListColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.ServiceDataField.php" );





class ServiceColumn extends ListColumn
{

    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ServiceColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
		$ps_ID=NULL )
    {
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Set... -------------------- */
    function SetValue( $ps_Value )
    {
	ListColumn::SetValue ( $ps_Value ? 1 : 0 );
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	if ( $this->GetValue() )
	{
	    $ls_Yes = "checked";
	    $ls_No = "";
	}
	else
	{
	    $ls_Yes = "";
	    $ls_No = "checked";
	}
	return "<input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=1 $ls_Yes> " . ltext("g_yes") .
		" <input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=0 $ls_No> " . ltext("g_no");
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		return new ServiceDataField( $this->GetValue(), $this->GetPureName() );
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
