<?

class SetOfIP {
	var $ma_IPs;
	var $mi_Index;
	
	function SetOfIP( $pm_List = NULL){
		$this->Clean();

		if( is_a( $pm_List, 'SetOfIP' ) ){ ## copy constructor
			$this->copyFrom( $pm_List );

		} elseif( !is_null( $pm_List ) ) {
			if ( !is_array( $pm_List ) ) {
				$pm_List = func_get_args();
			}
			foreach ($pm_List as $ip){
				$this->AppendIP($ip);
			}	
		}
	}
	
	function Clean(){
		$this->ma_IPs=array();
	}
	
	function AppendIP( $ps_IP ) {
		
		$la_chunks = split('\.',$ps_IP);	
				
		if(count($la_chunks)<4){
			return -1;
		}
		$li_value=0;
		for ($i=0; $i<4; $i++){
			if (!is_numeric($la_chunks[$i])){
				return -1;
			} 
			$li_num = 0+$la_chunks[$i];
			if($li_num >= 0 && $li_num < 256){
				$li_value *= 256;
				$li_value += $li_num;
			}else{
				return -1;
			}
		}
		$this->ma_IPs[$ps_IP] = $li_value;
		return $li_value;
	}
	
	function &GetSet(){
		return $this->ma_IPs;	
	}

	function GetList(){
		return array_keys($this->ma_IPs);
	}
	
	function GetValue( $ps_IP ) {
		if(array_key_exists( $ps_IP, $this->ma_IPs ) ) {
			return $this->ma_IPs[ $ps_IP ];
		}else{
			return -1;
		}	
	}

	function &SortByValue(){
		asort($this->ma_IPs,SORT_NUMERIC);
		reset($this->ma_IPs);
		return $this->ma_IPs;
	}

	function copyFrom( $poSrc ){
		if( is_a( $poSrc,'SetOfIP' ) ){
			$this->ma_IPs = $poSrc->GetSet();
			reset($this->ma_IPs);
		}
	}

	function &getClone(){
		return new SetOfIP( $this );
	}

	function extract( $poThat ){
		if( !is_a( $poThat, 'SetOfIP' ) ){
			$poThat = new SetOfIP( func_get_args() );
		}
		foreach( array_keys( $poThat->GetSet() ) as $lsIP ){
			if( array_key_exists( $lsIP, $this->ma_IPs ) ) {
				unset( $this->ma_IPs[$lsIP] );
			}
		}
		return $this->ma_IPs;
	}
}

?>
