<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ListColumn.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.ReadOnlyDataField.php" );





class TextColumn extends ListColumn
{

    /* -------------------- Constructor -------------------- */
    function TextColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
	$ps_ID=NULL )
    {
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	return htmlspecialchars($this->GetValue());
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		return new ReadOnlyDataField( $this->GetValue() );
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
