<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . "/class.InputTextColumn.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.CompoundDataField.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.ReadOnlyDataField.php" );





class TrafficColumn extends InputTextColumn {

	/* -------------------- Constructor -------------------- */
	function TrafficColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
			$ps_ID=NULL ) {
		$this->InputTextColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetHTML() {
		return InputTextColumn::GetHTML () . " MB";
	}

	// method that maps old classes to include/elements/*
	function GetDataField() {
		global $lang_format_mb_expr;
		$ls_Value = $this->GetValue();
		if ( $ls_Value < 0 )
			return new HTMLDataField( ltext("webshop_ulimit") );
		$lo_Result = new CompoundDataField( new ReadOnlyDataField( $ls_Value/1024 ), $lang_format_mb_expr );
		$lo_Result->SetSeparator( " " );
		return $lo_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
