<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ListColumn.php" );
include_once ( dirname(__FILE__) . "/module.Genlib.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.LinkDataField.php" );





class URLColumn extends ListColumn
{

    /* -------------------- Members -------------------- */
    var $mo_InnerColumn; // object that is responsible for HTML between <a> and </a>
    var $ma_Query; // array - elements of query
    var $ma_QueryValue; // array - values used in query
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function URLColumn ( $po_InnerColumn, $pa_Query, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(),
	    $ps_Width=NULL, $ps_Align=NULL, $ps_ID=NULL )
    {
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->SetInnerColumn ($po_InnerColumn);
	$this->SetQuery ( $pa_Query );
	$this->SetQueryValues ( array() );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get... -------------------- */
    function GetInnerColumn ()
    {
	return $this->mo_InnerColumn;
    }

    function GetQuery()
    {
	return $this->ma_Query;
    }

    function GetQueryValues()
    {
	return $this->ma_QueryValue;
    }
    /* -------------------- end Get... -------------------- */





    /* -------------------- Set... -------------------- */
    function SetInnerColumn ( $po_InnerColumn )
    {
	$this->mo_InnerColumn = $po_InnerColumn;
    }

    function SetQuery ( $pa_Query )
    {
	$this->ma_Query = $pa_Query;
    }

    function SetQueryValues ( $pa_Values )
    {
	$this->ma_QueryValue = $pa_Values;
    }

    function SetFromArray ( $pa_Data, $ps_ID )
    {
	$this->mo_InnerColumn->SetFromArray ( $pa_Data, $ps_ID );
	$this->ma_QueryValue = array();
	foreach ( $this->ma_Query as $ls_Name )
	    $this->ma_QueryValue[$ls_Name] = array_key_exists($ls_Name,$pa_Data) ? $pa_Data[$ls_Name] : "";
	ListColumn::SetFromArray ( $pa_Data, $ps_ID );
    }

    function SetFromPostGet ()
    {
	$this->mo_InnerColumn->SetFromPostGet();
	$this->ma_QueryValue = array();
	foreach ( $this->ma_Query as $ls_Name )
	    $this->ma_QueryValue[$ls_Name] = ff_GetFromPostGet ($ls_Name);
	ListColumn::SetFromPostGet();
    }

    function SetInput ( $ps_Input )
    {
	$this->mo_InnerColumn->SetInput ( $ps_Input );
	ListColumn::SetInput ( $ps_Input );
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	$ls_More = $this->GetAttributesHTML();
	$la_Query = array();
	foreach ( $this->ma_QueryValue as $ls_Key => $ls_Value )
	    $la_Query[] = urlencode($ls_Key) . "=" . urlencode($ls_Value);
	return '<a href="' . $this->GetValue() . "?" . implode( "&", $la_Query ). '" ' . $ls_More . '>' .
		$this->mo_InnerColumn->GetHTML() . '</a>';
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		$lo_Result = new LinkDataField( $this->GetValue(), "", $this->ma_QueryValue,
				$this->mo_InnerColumn->GetDataField() );
		$lo_Result->AppendAttributes( $this->GetAttributes() );
		return $lo_Result;
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
